/**
 * @author pritam.patil
 * Check List Form
 */
Ext.define('Academia.view.completion.completionlistforms.common.CheckListForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.checklistform',
    frame: false,
    border: false,
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        this$.items = [{
            xtype: 'fieldset',
            items: [{
                xtype: 'itemselector',
                itemId: 'checkListSelector',
                labelAlign: 'top',
                name: 'ids',
                width: 700,
                maxHeight: 500,
                autoScroll: true,
                store: store,
                displayField: 'value',
                valueField: 'id',
                fromTitle: getCompletionModuleTranslation('APPLICABLE_CHECK_LIST'),
                toTitle: getCompletionModuleTranslation('COMPLETED_CHECK_LIST'),
                editable: false,
                msgTarget: 'side',
                delimiter: null,
                buttons: ['top', 'add', 'remove', 'bottom'],
                getSubmitData: function(){
                    var me = this,
                        data = null,
                        val;
                    if (!me.disabled && me.submitValue && !me.isFileUpload()) {
                        val = me.getSubmitValue();
                        val = '[' + val + ']';
                        val = Ext.decode(val);
                        if (val !== null) {
                            data = {};
                            data[me.getName()] = val;
                        }
                    }
                    return data;
                }
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            items: [{
                xtype: 'button',
                text: getCompletionModuleTranslation('MARK_AS_COMPLETE'),
                itemId: 'completionCheckListUpdateBtn',
                style: {
                    marginLeft: '20px',
                    marginTop: '-50px'
                },
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }];
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.completion.completionform.CompletionCheckLists');
    }
});