/**
 * @author Pritam.Patil
 * This is used for Student basic Details Form
 */
Ext.define('Academia.view.completion.completionlistforms.common.StudentBasicDetails', {
    extend: 'Ext.form.Panel',
    alias: 'widget.studentbasicdetails',
    cls: 'panelNoSpace',
    width: '100%',
   
    initComponent: function() {

        this.items = [{
            xtype: 'panel',
            region: 'center',
            cls: 'panelNoSpace',
            autoScroll: true,
            layout: {
                type: 'vbox'
            },
            items: [{
                xtype: 'fieldset',
               // marginLeft: '5px',
                minWidth: 500,
                style: {
                    marginTop: '0px !important'
                },
                width: '100%',
                items: [this.getStudentProfileView()]
            }]
        }];

        this.callParent(arguments);
    },
    getStudentProfileView: function() {

        var studentProfile = new Ext.XTemplate('<tpl><div class="thumb-wrap">', 
        		'<table cellspacing="0" cellpadding="0" border="0" style="width:100%">', 
        			'<tr>', 
        			'<td style="width:30%">', 
        				'<table cellspacing="0" cellpadding="0" border="0" style="width:100%">', 
        					'<tr>', 
        						'<td><img style="border:1px solid black;" src="{photoUrl}" width="100px" height="120px"/></td>', 
        					'</tr>', 
        				'</table>', 
        			'</td>', 
        			'<td style="width:30%;vertical-align:top;">', 
        				'<table cellspacing="0" cellpadding="0" border="0" style="width:100%">', 
        					'<tr>', 
        						'<td> <span style="font-weight:bold; color:blue;">{firstName} {middleName} {lastName}</span></td>', 
        					'</tr>', 
        					'<tr>', 
        						'<td>' + getCompletionModuleTranslation('PHONE_NO') + ': {phoneNo}</td>', '</tr>', 
        					'<tr>', 
        						'<td>' + getCompletionModuleTranslation('EMAIL_ID') + ': {emailId} </td>', 
        					'</tr>', 
        					'<tr>', 
        						'<td>' + getCompletionModuleTranslation('ENROLLED_IN') + ': {enrolled_in} </td>',  
        					'</tr>', 
        				'</table>', 
        			'</td>', 
        			'<td>', 
        				'<table cellspacing="0" cellpadding="0" border="0" style="width:100%">', 
        					'<tr>', 
        						'<td>Effective Date: </td>', 
        					'</tr>', 
        					'<tr>', 
        						'<td>Pending documents: </td>', 
        					'</tr>', 
        					'<tr>', 
        						'<td>Returnable Documents: </td>', 
        					'</tr>', 
        					'<tr>', 
        						'<td>Issue Certificates: </td>', 
        					'</tr>', 
        					'<tr>', 
        						'<td>Checklist: </td>', 
        					'</tr>', 
        					'<tr>', 
        						'<td>Pending Payments: </td>', 
        					'</tr>', 
        					'<tr>', 
        						'<td>Pending Refunds: </td>', 
        					'</tr>', 
        				'</table>', 
        			'</td>', 
        		'</tr>', 
        	'</table></div></tpl>');

        var studentProfileView = Ext.define('Academia.view.personinfo.student.StudentProfileView', {
            extend: 'Ext.view.View',
            alias: 'widget.studentprofileview',
            itemId: 'studentProfileView',
            width: '100%',
            tpl: studentProfile,
            itemSelector: 'div.thumb-wrap'
        });

        return studentProfileView;
    }

});