/**
 * By Kamlesh
 */
Ext.define('Academia.view.course.CourseMasterGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.coursemastergrid',
	store : 'course.CourseMasterGridStore',
	title : getCommonTranslation('COURSE_MASTER_LIST'),
	border: true,
	autoScroll: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'course.CourseMasterGridStore',
			displayInfo : true
		} ]
	}
	],tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),//View department
		iconCls: 'view-icon'
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],

	columns : [{
		header : 'ID',
		hidden : true,
		dataIndex:'id'
	},{
		header : getCommonTranslation('COURSE_CODE'),
		dataIndex : 'courseCode',
		flex : 1,
		renderer : function(value){
			return  '<a  id:tab1, href="#">'+value+'</a>';
		}

	}, {
		header : getCommonTranslation('COURSE_NAME'),
		dataIndex : 'courseName',
		flex : 1	

	}, {
		header : getCommonTranslation('CREATED_ON'),
		dataIndex : 'createdOn',
		flex : 1
	}, {
		header : getCommonTranslation('SELECTION_STAGE'),
		dataIndex : 'selectionStage',
		flex : 1,
		renderer : function(value){
			if(value!=null){
				return value.value;
			}else{
				return value;
			}
		}
	}, {
		header : getCommonTranslation('NO_OF_PROG_COURSES'),
		dataIndex : 'noOfProgramAssociated',
		flex : 1,
		renderer:function(value){
			return  '<a href="#">'+value+'</a>';
		}
	}, {
		header : getCommonTranslation('NO_OF_REGULAR_COURSE_GROUP_COURSE'),
		dataIndex : 'noOfRegularCourseGroups',
		flex : 1,
		renderer:function(value){
			return  '<a href="#">'+value+'</a>';
		}
	}, {
		header : getCommonTranslation('COURSE_NO_OF_AUDIT_GRP_ASS'),
		dataIndex : 'noOfAuditGroups',
		flex : 1,
		renderer:function(value){
			return  '<a href="#">'+value+'</a>';
		}
	}, {
		header : getCommonTranslation('COURSE_NO_OF_COURSE_SPE_ASS'),
		dataIndex : 'noOfCourseSpecialization',
		flex : 1,
		renderer:function(value){
			return  '<a href="#">'+value+'</a>';
		}
	}, {
		header : getCommonTranslation('NO_OF_COURSE_VARIENTS'),
		dataIndex : 'noOfCourseVarient',
		flex : 1,
		renderer:function(value){
			return  '<a href="#">'+value+'</a>';
		}
	}, {
		header : getCommonTranslation('DEPT_NAME'),
		dataIndex : 'department',
		flex : 1,
		renderer : function(value){
			if(value!=null){
				return value.value;
			}else{
				return value;
			}
		}
	}, {
		header : getCommonTranslation('SUB_DEPT_NAME'),
		dataIndex : 'subDepartment',
		flex : 1,
		renderer : function(value){
			if(value!=null){
				return value.value;
			}else{
				return value;
			}
		}
	}, {
		header : getCommonTranslation('COURSE_COORDINATORE'),
		hidden:true,
		dataIndex : 'courseCoordinator',
		flex : 1
	}],
	listeners: {
		cellclick: function (view, cell, cellIndex, record, row, rowIndex, e) {

			if(e.target.tagName=='A'){

				if(cellIndex==0){
					this.fireEvent('editCourse',view,rowIndex,record);	
				}
				if(cellIndex==4){
					this.fireEvent('NoOfProgram',view,rowIndex,record);	
				}
				if(cellIndex==5){
					this.fireEvent('NoOfReqCourse',view,rowIndex,record);	
				}
				if(cellIndex==6){
					this.fireEvent('NoOfAudit',view,rowIndex,record);	
				}
				if(cellIndex==7){
					this.fireEvent('NoOfCourse',view,rowIndex,record);	
				}
				if(cellIndex==8){
					this.fireEvent('NoOfVariants',view,rowIndex,record);	
				}
			}
		}
	}
});
