/**
 * @author Akshay Sharma
 */
Ext.define('Academia.view.course.NoOfCourseSpclAssoGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.noofcoursespclassogrid',
	border: true,
	autoScroll: true,
	title:getProgramandcourseTranslation('SPECIALIZATION_ASSOCIATED'),
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	store : 'course.NoOfCourseSpecializationAssoGridStore',
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'course.NoOfCourseSpecializationAssoGridStore',
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments); 
	},
	columns : [{
		header : 'ID',
		hidden : true,
		dataIndex:'id'
	}, {
		header : getCommonTranslation('SPECIALIZATION_NAME'),
		dataIndex : 'specializationName',
		flex : 1
	}, {
		header : getCommonTranslation('OPTIONAL_MENDATORY'),
		dataIndex : 'optionalOrMandatory',
		flex : 1,
		renderer : function(value){
			if(value){
				return getCommonTranslation('MANDATORY');
			}else{
				return getCommonTranslation('OPTIONAL');
			}
		}
	}, {
		header : getCommonTranslation('PROGRAMS_ASSOCIATED'),
		dataIndex : 'classAssociated',
		flex : 1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	}]
});
