/**
 * @author seshagiri.k
 */
Ext.define('Academia.view.course.coursegroup.CourseGroupStructureGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.courseGroupStructureGrid',
    id:'assignCoursesStructureGrid_Id',
    store: 'course.coursegroup.CourseGroupStructureStore',
    title: getCommonTranslation('LIST_OF_COURSE_GROUP'),
    border: false,
    autoScroll: true,
    viewConfig: {
        stripeRows: true
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
            store: 'course.coursegroup.CourseGroupStructureStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],

    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
    columns: [{
        header: getCommonTranslation('COURSE_GROUP_CODE'),
        dataIndex: 'code',
        sortable:true,
        flex: .1
    }, {
        header: getCommonTranslation('COURSE_GROUP_NAME'),
        dataIndex: 'groupName',
        sortable: true,
        flex: .2
    }, {
        header: getCommonTranslation('NO_OF_COURSES_ASSOCIATED'),
        dataIndex: 'noOfAssociatedCourses',
        sortable:true,
        flex: .1
    }, {
        header: getCommonTranslation('NO_OF_PROGRAMS_ASSOCIATED'),
        dataIndex: 'noOfAssociatdPrograms',
        sortable:true,
        flex: .1
    }]

});