Ext.define('Academia.view.coursetransaction.courseSectionManagment.CreateCourseSectionForm', {
	extend:'Academia.view.common.DynamicFieldForm',
	alias: 'widget.createcoursesectionform',
	title: getProgramandcourseTranslation('ADD_SECTIONS'),
	autoScroll: true,
	frame: true,
	modal: true,
	method: 'POST',
	plugins:"formlabelrequired",
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	layout: {
		type: 'vbox'
	},
	standardSubmit: false,
	defaults: {
		labelAlign: 'top'
	},
	items: [{
		xtype: 'fieldcontainer',
		width:'100%',
		layout: {
			type: 'hbox'
		},
		defaults :{
			width: 226,
			labelAlign:'top'
		},
		items: [{
			xtype: 'hidden',  
			name : 'sectionCourseId',
			itemId : 'sectionCourseId',
		},{
			xtype: 'textfield',  
			name : 'locationCode',
			itemId : 'locationCodeItemId',
			fieldLabel: getCommonTranslation('LOCATION_CODE'),
			readOnly : true,
			width:  150
		},{
			xtype: 'textfield',
			name: 'createAcademicTermValue',
			itemId: 'createAcademicTermValue',
			fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
			hidden:true
		},{
			xtype: 'textfield',
			name: 'periodIds',
			itemId: 'periodIds',
			hidden:true
		},{	
			xtype: 'customcombobox',
			name: 'createAcademicTermId',
			fieldLabel: getCommonTranslation('ACADEMIC_TERM') ,
			store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
			valueField:'id',
			displayField:'value',
			itemId: 'createAcademicTermId',
			allowBlank: false,
			editable:true,
			allowBlank:false,
			typeAhead:true,
			queryMode:'local',
             forceSelection : true,
             anyMatch : true
		},{	
			xtype: 'customcombobox',
			name: 'calendar',
			fieldLabel: getCourseTxCommonTranslation('ASSIGN_CALENDER') ,
			store:Ext.create('Academia.store.facilitiesresources.resourcemaster.MappedCalenderStore'),
			valueField:'id',
			displayField:'value',
			itemId: 'calendar',
			editable:false,
			allowBlank:false
		},{
			xtype : 'customcombobox',
			name : 'evalutionPlanName',
			itemId : 'evalutionPlan',
			hidden:false,
			fieldLabel : getExaminationTranslation('EVALUATION_PLAN'),
			store:Ext.create('Academia.store.common.EvalutionPlanIdInSectionStore'),
			valueField : 'id',
			displayField : 'value',
			editable:false
		}]
	},{
		xtype: 'fieldcontainer',
		width:'100%',
		defaults :{
			width: 400,
			labelAlign:'top'
		},
		items: [{
			xtype: 'radiogroup',
			itemId: 'definedSectionId',
			name: 'definedSection',
			layout: 'hbox',
			items: [{
				boxLabel  :getProgramandcourseTranslation('SECTION_PRE_DEFINED'),
				name      : 'definedSection',
				inputValue: true,
				checked:true
			}, {
				boxLabel  : getProgramandcourseTranslation('SECTION_USER_DEFINED'),
				name      : 'definedSection',
				inputValue: false
			}]
		}]
	},{
		xtype:'panel',
		itemId:'preDefinedPanelId',
		layout : 'vbox',
		style:{
			marginLeft:'0px',
			marginTop:'0px'
		},
		items:[{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				labelAlign : 'top',
				width:226
			},
			layout : {
				type : 'hbox'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'preDefinedSection',
				itemId: 'preDefinedSectionId',
				fieldLabel: getProgramandcourseTranslation('SECTIONS_NAME'),
				store:Ext.create('Academia.store.coursetransaction.sectionmanagement.SectionMasterStore'),
				displayField:'code',
				valueField:'id',
				allowBlank:false,
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'textfield',
				name: 'preDefinedSectionCode',
				itemId: 'preDefinedSectionCodeId',
				fieldLabel: getCommonTranslation('SECTION_PRINT_NAME'),
				readOnly:true,
				hidden:true
			},{
				xtype: 'textfield',
				name: 'preDefinedSectionPrintName',
				itemId: 'preDefinedSectionPrintNameId',
				fieldLabel: getCommonTranslation('SECTION_PRINT_NAME'),
				readOnly:true
			},{
				xtype: 'customcombobox',
				width:226,
				name: 'preDefinedAssignHomeRoom',
				itemId: 'preDefinedAssignHomeRoomId',
				fieldLabel: getCommonTranslation('HOME_ROOM'),
				store:Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.ClassRoom'),
				displayField:'value',
				valueField:'id',
				typeAhead:true,
				forceSelection:true,
				editable:false
			},{
				xtype: 'numberfield',
				name: 'preDefinedMaxCapacity',
				itemId:'preDefinedMaxCapacity_id',
				fieldLabel: getCommonTranslation('MAX_CAPACITY'),
				minValue:1,
				hideTrigger:true,
				maxValue : 5000,
				hideTrigger:true,
				allowExponential:false,
				allowDecimals:false
			},{
				xtype: 'button',
				itemId: 'preDefinedDetailedBtn',
				width: 'auto',
				cls: 'CustomBodyBtnSettings',
				width: 'auto',
				text: getCommonTranslation('ADDBUTTONTEXT'),
				tooltip: getCommonTranslation('ADD'),
				style:{
					marginTop:'30px'
				},
				listeners:{
					click:function(obj){
						var form = obj.up('form');
						form.down('#programFormSubmitButtonId').setDisabled(true);
					}
				}
			}]
		}]
	},{
		xtype:'panel',
		itemId:'usrDefinedPanelId',
		layout : 'vbox',
		hidden:true,
		style:{
			marginLeft:'0px',
			marginTop:'0px'
		},
		items:[{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				labelAlign : 'top',
				width:226
			},
			layout : {
				type : 'hbox'
			},
			items:[{
				xtype: 'textfield',
				name: 'usrDefinedSectionName',
				itemId: 'usrDefinedSectionNameId',
				fieldLabel: getProgramandcourseTranslation('SECTIONS_NAME'),
				maxLength : 99,
				allowBlank:true
			},{
				xtype: 'textfield',
				name: 'usrDefinedSectionPrintName',
				itemId: 'usrDefinedSectionPrintNameId',
				maxLength : 99,
				fieldLabel: getCommonTranslation('SECTION_PRINT_NAME'),
			},{
				xtype: 'customcombobox',
				width:226,
				name: 'usrDefinedAssignHomeRoom',
				itemId: 'usrDefinedAssignHomeRoomId',
				fieldLabel: getCommonTranslation('HOME_ROOM'),
				store:Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.ClassRoom'),
				displayField:'value',
				valueField:'id',
				typeAhead:true,
				forceSelection:true,
				editable:false
			},{
				xtype: 'numberfield',
				name: 'usrDefinedMaxCapacity',
				itemId:'usrDefinedMaxCapacity_id',
				fieldLabel: getCommonTranslation('MAX_CAPACITY'),
				minValue:1,
				hideTrigger:true,
				maxValue : 5000,
				hideTrigger:true,
				allowExponential:false,
				allowDecimals:false
			},{
				xtype: 'button',
				itemId: 'usrDefinedDetailedBtn',
				width: 'auto',
				cls: 'CustomBodyBtnSettings',
				width: 'auto',
				text: getCommonTranslation('ADDBUTTONTEXT'),
				tooltip: getCommonTranslation('ADD'),
				style:{
					marginTop:'30px'
				},
				listeners:{
					click:function(obj){
						var form = obj.up('form');
						form.down('#programFormSubmitButtonId').setDisabled(true);
					}
				}
			}]
		}
		]},{
			xtype:'fieldcontainer',
			width:'100%',
			layout : {
				type : 'hbox'
			},
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'programFormSubmitButtonId',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'createCourseSectionResetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCommonTranslation('ADD_MORE_DETAILS'),
				itemId: 'addMoreDetailsButtonId',
				disabled: true,
				hidden:true, 
				ui: 'CustomBtnThird',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
});