/*
 * @author Rajkumar.patidar
 */
Ext.define('Academia.view.coursetransaction.courseSectionManagment.OpenSectionSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.opensectionsearch',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
	method : 'POST',
	standardSubmit : false,
	defaults: {
		labelAlign:'top',
		width:226
	},
	plugins : "formlabelrequired",
	items: [{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items: [{
			xtype : 'customcombobox',
			name : 'academyLocation',
			itemId:'academyLocation',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:Ext.create('Academia.store.coursetransaction.sectionmanagement.AcademyLocationsByUserStore'),
			width: 460,
			valueField : 'id',
			displayField : 'value',
			//allowBlank : false,
			minChars:3,
			typeAhead : false,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			//queryParam:'qry',
			//emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			 editable : true,
			 queryMode: 'local',
			 anyMatch : true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'academicTerm',
			fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
			itemId:'academicTerm',
			store : Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
			valueField: 'id',
			displayField: 'value',
			editable : true,
			typeAhead:true,
			queryMode:'local',
             forceSelection : true,
             anyMatch : true
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items: [{
			xtype: 'customcombobox',
			name: 'department',
			itemId:'courseDepartment',
			fieldLabel: getCommonTranslation('COURSE_DEPARTMENT'),			
			store:Ext.create('Academia.store.course.DepartmentByALCourseStore'),
			valueField: 'id',
		    displayField: 'value',
			allowBlank:false,
			typeAhead:false,
			forceSelection:true,
			queryParam:'qry',
			minChars:3,
			width:226,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			
		listConfig: {
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}'+ 
				'</div>';
			}
		  }
		 },{
			xtype: 'customcombobox',
			name: 'subDepartment',
			width:226,
			itemId: 'courseSubDepartment',
			fieldLabel: getCommonTranslation('COURSE_SUB_DEPARTMENT'),
			store:Ext.create('Academia.store.course.CourseSubDepartmentStore'),
			displayField:'value',
			valueField:'id',
			editable: false,
			hideTrigger:false,
			disabled:true,		
		},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype: 'customcombobox',
				name: 'courseCategory',
				itemId:'courseCategory',
				fieldLabel: getCommonTranslation('COURSE_CATEGORY'),
				store:Ext.create('Academia.store.course.CourseCategoryByUserStore'),
				valueField: 'id',
				displayField: 'value',
				editable: false,
				disabled:true
			}]  
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:460
		},
		items:[{
			xtype: 'customcombobox',
			name: 'courseMarkGrad',
			itemId:'courseMarksGrades_id',
			width:226,
			fieldLabel: getCommonTranslation('COURSE_MARK_GRADES'),
			valueField: 'id',
			displayField: 'value',
			editable: false,
			disabled:false,
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.course.CourseMarkGradeStore');
					combo.bindStore(store)
				}
			}
		},{
			xtype: 'multiselectcombofield',
			name: 'courseSectionId',
			itemId:'courseSectionId',
			cls:'ProgramCourseMultiselectField',
			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
			store:Ext.create('Academia.store.coursetransaction.sectionmanagement.CoursesByDeptMarks'),
			valueField: 'id',
			displayField: 'valueCode',
			allowBlank:true,
			queryParam:'qry',
			typeAhead : true,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			disabled:true,
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}	 
		}]  
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:460
		},
		items:[{
			xtype: 'multiselectcombofield',
			name: 'openWiseSection',
			itemId:'openWiseSectionId',
			queryParam:'qry',
			fieldLabel: getCommonTranslation('SECTION'),
			store: Ext.create('Academia.store.coursetransaction.sectionmanagement.CourseSectionsByAcademicTerm'),
			valueField: 'id',
			displayField: 'code',
			typeAhead : true,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			disabled:true,
			minChars:3,
			cls:'ProgramCourseMultiselectField',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			  }
		  }]  
	  },{
		xtype: 'fieldcontainer',
		defaults : {
			labelAlign : 'left'
		},
		layout: {
			type: 'hbox'
		},
		items: [{
			xtype: 'checkbox',
			labelWidth: 300,
			itemId:'programWiseCheckBoxId',
			name: 'programWiseCheckBox',
			inputValue: true,
			uncheckedValue:true,
			checked:false,
			disabled:true,
			boxLabel: getProgramandcourseTranslation('COURSE_WITHOUT_SECTION')
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		items:[{  
			xtype: 'button',
			itemId: 'searchBtn',
			formBind:true,
			text: getCourseTxCommonTranslation('SEARCH'),
			ui:'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCourseTxCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]	
	}]
	});