/*
 * @author Rajkumar.patidar
 */
Ext.define('Academia.view.coursetransaction.courseSectionManagment.ProgramWiseSectionSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.programwisesectionsearch',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	method : 'POST',
	standardSubmit : false,
	plugins : "formlabelrequired",
	bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
	items: [{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items: [{
			xtype : 'customcombobox',
			name : 'academyLocation',
			itemId:'academyLocation',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:Ext.create('Academia.store.coursetransaction.sectionmanagement.AcademyLocationsByUserStore'),
			width: 460,
			valueField : 'id',
			displayField : 'value',
			//allowBlank : false,
			//minChars:3,
			typeAhead : false,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			//queryParam:'qry',
			queryMode: 'local',
			editable : true,
			anyMatch : true,
			//emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'programWiseAcademicTerm',
			fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
			itemId:'programWiseAcademicTermId',
			store : Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
			valueField: 'id',
			displayField: 'value',
			//queryParam:'qry',
			allowBlank:false,
			//minChars:3,
		    editable : true,
		    typeAhead:false,
		    queryMode: 'local',
			anyMatch : true,
		    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    	    forceSelection:true,
    			listConfig: {
    			listeners: {
    				beforeshow: function(picker) {
    					picker.minWidth = picker.up('combobox').getSize().width;
    				}
    			},
    			loadingText: getCommonTranslation('SEARCHING'),
    			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    			getInnerTpl: function() {
    				return '<div class="search-item">' +
    				'{code} / {value}'+ 
    				'</div>';
    			  }
    		    }
		     }]
	     },{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items: [{
			xtype: 'customcombobox',
			name: 'programWiseCourseMarkGrade',
			itemId:'programWiseCourseMarkGrade_id',
			width:226,
			store:Ext.create('Academia.store.course.CourseMarkGradeStore'),
			fieldLabel: getProgramandcourseTranslation('PROGRAM_MARK_GRADES'),
			valueField: 'id',
			displayField: 'value',
			allowBlank:true,
			typeAhead:false,
			forceSelection:false,
			disabled:false,
		},{
			xtype: 'multiselectcombofield',
			name: 'programWiseProgram',
			width:460,
			itemId: 'programWiseProgramId',
			fieldLabel: getProgramandcourseTranslation('PROGRAM_BATCH'),
			store: Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramBatchPeriodCourse'),
			displayField:'valueCode',
			valueField:'id',
			queryParam:'programName',
			typeAhead : true,
			allowBlank:false,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			disabled:true,
			minChars:3,
			autoloadStore:false,
			cls:'ProgramCourseMultiselectField',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:460
		},
		items:[{
			xtype: 'multiselectcombofield',
			name: 'programWisePeriod',
			itemId:'programWisePeriodId',
			fieldLabel: getCourseTxCommonTranslation('PERIOD'),
			store: Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramBatchPeriodCourse'),
			valueField: 'id',
			displayField: 'value',
			disabled:true,
			queryParam:'programName',
			allowBlank:false,
			autoloadStore:false,
			cls:'ProgramCourseMultiselectField resetPasswordMultiselect',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}
		}]  
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:460
		},
		items:[{
			xtype: 'multiselectcombofield',
			name: 'programWiseCourse',
			itemId:'programWiseCourseId',
			queryParam:'programName',
			fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
			store: Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.CoursesMappedWithPeriod'),
			valueField: 'id',
			displayField: 'valueCode',
			typeAhead : true,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			disabled:true,
			minChars:3,
			autoloadStore:false,
			cls:'ProgramCourseMultiselectField resetPasswordMultiselect',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}
		},{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:460
			},
			items:[{
				xtype: 'multiselectcombofield',
				name: 'programWiseSection',
				itemId:'programWiseSectionId',
				queryParam:'qry',
				fieldLabel: getCommonTranslation('SECTION'),
//				store: Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.CoursesMappedWithPeriod'),
				store: Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ParameterizedCourseSections'),
				valueField: 'id',
				displayField: 'value',
				typeAhead : true,
				forceSelection:true,
				hideTrigger:false,
				triggerAction: 'all',
				disabled:true,
				minChars:3,
				autoloadStore:false,
				cls:'ProgramCourseMultiselectField resetPasswordMultiselect',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}'  +
						'</div>';
					}
				}
			}]  
		}]  
	},{
		xtype: 'fieldcontainer',
		defaults : {
			labelAlign : 'left'
		},
		layout: {
			type: 'hbox'
		},
		items: [{
			xtype: 'checkbox',
			labelWidth: 300,
			itemId:'programWiseCheckBoxId',
			name: 'programWiseCheckBox',
			inputValue: true,
			uncheckedValue:false,
			checked:false,
			boxLabel: getProgramandcourseTranslation('COURSE_WITHOUT_SECTION'),
			disabled:true
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		items:[{  
			xtype: 'button',
			itemId: 'searchBtn',
			formBind:true,
			text: getCourseTxCommonTranslation('SEARCH'),
			ui:'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			disabled:true
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCourseTxCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]	
	}]
});