/**
 * Amit Gupta
 * 
 */
Ext.define('Academia.view.coursetransaction.manageperiodenrollment.ManageStudentEnrollmentSearch', {
	extend : 'Ext.form.FormPanel',
	alias : 'widget.managestudentenrollmentsearch',
	plugins : "formlabelrequired",
	autoScroll : true,
	frame : false,
	method : 'POST',
	standardSubmit : false,
	cls : 'customSearchPanel',
	items : [ {
		xtype : 'fieldcontainer',
		width : 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [ {
			xtype : 'customcombobox',
			name : 'studentNameSearch',
			itemId : 'studentNameSearch',
			store : Ext.create('Academia.store.coursetransaction.studentenrollment.studentenrollmentdetail.StudentIdByAdmissionCodeBySmartSearch'),
			fieldLabel : getCommonTranslation('ADMISSIONID_STUDENTID_STUDENTNAME'),
			width : 450,
			valueField : 'id',
			displayField : 'valueCode',
			queryParam : 'name',
			minChars : 3,
			typeAhead : false,
			hideTrigger : true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			emptyText : getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction : '',
			forceSelection : true,
			allowBlank : false,
			enableKeyEvents : 'true',
			listConfig : {
				listeners : {
					beforeshow : function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText : getCommonTranslation('SEARCHING'),
				emptyText : getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl : function() {
					return '<div class="search-item">' + '{code} / {value}' + '</div>';
				}
			},
			listeners:{
				select:function(obj,record){
					obj.admissionId =record[0].data.secondId
				}
			}
		} ]
	}, {
		xtype : 'fieldcontainer',
		width : 'auto',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SEARCH'),
			itemId : 'searchBtn',
			buttonAlign : 'left',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}, {
			xtype : 'button',
			text : getCourseTxCommonTranslation('RESET'),
			itemId : 'resetBtn',
			buttonAlign : 'left',
			ui : 'CustomBtnCancel',
			scale : CONSTANTS.BUTTONSIZE
		} ]
	} ]
// }]
});