Ext.define('Academia.view.coursetransaction.promotion.PromotionPanelViewDetailsWindow',{
	extend:'Ext.window.Window',
	alias:'widget.promotionpanelviewdetailswindow',
	modal : true,
	resizable:false,
	autoScroll:true,
	title: getCommonTranslation('PROGRESSION_PANEL_DETAILS'),
	height: '90%',
	width: 1150,
	frame: true,
	layout: 'vbox',
	cls: 'progressionPanelDetailsCls',
	closeAction: 'destroy',
	tools: [{
		type: 'gear', // placeholder icon (can be removed with style)
		itemId: 'selectedCountTool',
		qtip: 'Selected Count',
		style: {
			backgroundImage: 'none',
			padding: '0 10px',
			fontSize: '13px',
			color: 'white',
			fontWeight: 'bold',
			marginLeft: '40px !important'
		}
	}, {
		xtype: 'tbspacer',
		flex: .05
	}],
	dockedItems: [{
		xtype: 'toolbar',
		dock: 'top',
		items: [{
			xtype: 'button',
			text: getCommonTranslation("PREVIOUS"),
			itemId: 'viewDetailsPrevBtnItemId'
		}, {
			xtype: 'tbspacer',
			flex: 1
		}, {
			xtype: 'customcombobox',
			fieldLabel: getProgramandcourseTranslation('Complete Button'),
			itemId: 'completeButtonId',
			labelStyle: 'font-weight: bold;',
			labelAlign: 'right',
			labelWidth: 150,
			width: 400,

			store: new Ext.data.SimpleStore({
				fields: ['id', 'name'],
				data: [
					['DO_NOT_SHOW', getProgramandcourseTranslation('DO_NOT_SHOW')],
					['SHOW_WITH_CONFIRMATION', getProgramandcourseTranslation('SHOW_WITH_CONFIRMATION')],
					['SHOW_WITHOUT_CONFIRMATION', getProgramandcourseTranslation('SHOW_WITHOUT_CONFIRMATION')]
				]
			}),

			queryMode: 'local',
			displayField: 'name',
			valueField: 'id',
			editable: false,
			triggerAction: 'all',

			listConfig: {
				width: 280,
				maxHeight: 120,
			}
		}, {
			xtype: 'tbspacer',
			flex: 1
		}, {
			xtype: 'button',
			text: getCommonTranslation("NEXT"),
			itemId: 'viewDetailsNextBtnItemId'
		}]
	}],
	items: [{
		xtype: 'panel',
		height: 145,
		// cls: 'progressionPanelDetailsStudentDetailsPanelCls',
		layout: {
			type: 'hbox'
		},
		style: {
			// 	'border': '1px solid #e0e0e0;',
			// 	'border-radius': '5px;',
			// 	'box-sizing': 'border-box',
			// 	'box-shadow': '0px 2px 10px rgba(0, 0, 0, 0.1)',
			// 	'border-radius': '4px'
			marginTop: '-45px !important'
		},
		width: 1060,
		items: [{
			xtype: 'image',
			itemId: 'student_profile_image',
			border: 1,
			style: {
				borderColor: '#e0e0e0',
				borderStyle: 'solid',
				borderRadius: '50%',
				marginTop: '44px !important',
				marginLeft: '13px !important'
			},
			width: 100,
			height: 100
		}, {
			xtype: 'grid',
			//title: getCommonTranslation('LEARNING_ALLOWANCE'),
			itemId: 'decisionTempleteRemarkGrid',
			border: true,
			width: 926, 
			minHeight: 100, // Set the minimum height
			viewConfig: {
				stripeRows: true,
				enableTextSelection: true,
				getRowClass: function() {
					return 'wrap-row';
				}
			},
			style: {
				marginTop: '3px !important'
			},
			store: Ext.create('Academia.store.coursetransaction.promotion.DecisionTempleteRemarkGridStore'),
			columns: [{
				header: getProgramandcourseTranslation('DECISION') + '<span class="required" style="color:red"> *</span>',
				dataIndex: 'progressionStatus',
				sortable: false,
				flex: 1,
				editor: {
					xtype: 'customcombobox',
					itemId: 'promotionStatusId',
					name: 'promotionStatus',
					store: Ext.create('Academia.store.program.programDetails.programBatches.programPeriod.ProgressionStatusPeriodStore'),
					valueField: 'value',
					displayField: 'value',
					typeAhead: false,
					forceSelection: true,
					queryParam: 'qry'
				},
				renderer: function (val, rec) {
					if (isNullOrEmpty(val)) {
						rec.tdCls = 'gridInputCustomStyle';
						return getExaminationTranslation('CLICK_TO_ENTER');
					} else {
						return val;
					}
				}
			}, {
				header: getProgramandcourseTranslation('TEMPLATE'),
				dataIndex: 'template',
				sortable: false,
				flex: 1,
				hidden: true
			}, {
				header: getProgramandcourseTranslation('REMARK'),
				dataIndex: 'remark',
				sortable: false,
				flex: 2,
				editor: {
					xtype: 'textarea',
					name: 'remark',
					itemId: 'remark',
					maxLength: 512,
					height: 50
				},
				renderer: function (val, metaData) {
					if (isNullOrEmpty(val)) {
						metaData.tdCls = 'gridInputCustomStyle';
						return getExaminationTranslation('CLICK_TO_ENTER');
					}

					var encodedValue = Ext.String.htmlEncode(val).replace(/\n/g, '<br>');
					metaData.tdAttr = 'data-qtip="' + encodedValue + '"'; // Tooltip to show full content on hover

					return '<div class="promotion-panel-remark-cell">' + encodedValue + '</div>';
				}
			}],
			plugins: [
				{
					ptype: 'cellediting',
					clicksToEdit: 1,
					listeners: {}
				}]
		}]
	}, {
			xtype: 'panel',
			height: 100,
			// cls: 'progressionPanelDetailsStudentDetailsPanelCls',
			layout: {
				type: 'hbox'
			},
			style: {
				// 	'border': '1px solid #e0e0e0;',
				// 	'border-radius': '5px;',
				// 	'box-sizing': 'border-box',
				// 	'box-shadow': '0px 2px 10px rgba(0, 0, 0, 0.1)',
				// 	'border-radius': '4px'
				marginTop: '-35px'
			},
			width: 1060,
			items: [
				{
					xtype: 'panel',
					height: 100,
				// cls: 'progressionPanelDetailsStudentDetailsPanelCls',
					layout: {
						type: 'hbox',
						align: 'middle',
						pack: 'start'
					},
					// style: {
					// 	border: '1px solid #e0e0e0',
					// 	borderRadius: '5px',
					// 	boxSizing: 'border-box',
					// 	boxShadow: '0px 2px 10px rgba(0, 0, 0, 0.1)'
					// },
					width: 1060,
					padding: 10,
					defaults: {
					margin: '10px',
					marginTop: '-30px !important'
					},
					items: [
						{
							xtype: 'customcombobox',
							fieldLabel: getExaminationTranslation('REPORT_CARD_JOB'),
							// labelAlign: 'top',
							itemId: 'marksheetJobField',
							width: 300,
							store: Ext.create('Academia.store.program.programDetails.programBatches.programPeriod.ProgressionPanelExamEventStore'),
							queryMode: 'local',
							displayField: 'value',
							valueField: 'id',
							editable: false,
							triggerAction: 'all',
							matchFieldWidth: true,
							style: {
								marginTop: '30px !important'
							},
							listConfig: {
								listeners: {
									beforeshow: function (picker) {
										picker.minWidth = picker.up('combobox').getSize().width;
									},
									afterrender: function (combo) {
										combo.getStore().on("load", function (store, items) {
											try {
												var item = Ext.select('.x-boundlist-item').elements[0];
												if (items.length === 0 && item) item.hidden = true;
												else if (item) item.hidden = false;
											} catch (e) { }
										});
									}
								},
								loadingText: getCommonTranslation('SEARCHING'),
								emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
								getInnerTpl: function () {
									return '<div class="search-item">{objectName}</div>';
								}
							}
						},
						{
							xtype: 'fieldcontainer',
							layout: 'hbox',
							defaults: {
								xtype: 'button',
								ui: 'CustomBtnCancel',
								scale: CONSTANTS.BUTTONSIZE,
								style: {
									margin: '10px',
									marginTop: '10px !important'
								}
							},
							items: [
								{
									text: getProgramandcourseTranslation('SAVE_AS_DRAFT'),
									itemId: 'saveAsDraftBtn',
									formBind: true
								},
								{
									text: getProgramandcourseTranslation('SUBMIT'),
									itemId: 'submitBtn'
								}
							]
						},
						{
							xtype: 'container',
							flex: 1 // 👈 Pushes this item to the end of the hbox
						},
						{
							xtype: 'fieldcontainer',
							width: 'auto',
							layout: {
								type: 'hbox',
								align: 'middle'
							},
							itemId: 'marksheetPreviewContainer',
							defaults: {
								xtype: 'button',
								scale: CONSTANTS.BUTTONSIZE,
								ui: 'CustomBtnCancel',
								// style: {
								// 	fontSize: '12px',
								// 	fontWeight: 'bold',
								// 	color: '#3e4657',
								// 	fontFamily: '"Open Sans", sans-serif, "Myriad Pro"',
								// 	margin: '10px',
								// 	border: '1px solid #3093d4',
								// 	borderRadius: '6px',
								// 	padding: '3px'
								// }
								style: {
									margin: '10px',
									marginTop: '10px !important'
								}
							},
							items: [
								{
									text: getCommonTranslation('EMAIL_PREVIEW'),
									itemId: 'emailPreviewBtn'
								},
								{
									text: getCommonTranslation('MARKSHEET_PREVIEW'),
									itemId: 'marksheetPreviewBtn'
								}
							]
						}
					]
				}
			]
		}, {

			xtype: 'fieldcontainer',
			width: '100%',
			height: 50,
			style: {
				marginTop: '-40px !important',
				marginLeft: '144px !important'
			},
			defaults: {
				xtype: 'button',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE,
				style: {
					margin: '0px 10px 0px 0px',
				}
			},
			items: [{
				xtype: 'button',
				text: getProgramandcourseTranslation('COMPLETE'),
				itemId: 'complteBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}, {
				xtype: 'button',
				text: getProgramandcourseTranslation('SEND_PROGRESSION_LETTER'),
				itemId: 'sendProgressionBtn',
				ui: 'CustomBtnCancel',
				hidden: true,
				scale: CONSTANTS.BUTTONSIZE
				}, {
					xtype: 'button',
					text: getCommonTranslation('REGENERATE_LETTER'),
					itemId: 'regenerateLetterBtn',
					ui: 'CustomBtnCancel',
					hidden: true,
					scale: CONSTANTS.BUTTONSIZE
				}]

		},{
			xtype: 'panel',
			layout: {
				type: 'hbox',
				align: 'middle',
				pack: 'start'
			},
			width: 1060,
			margin: '0 0 0 144', // Left margin of 144px
			defaults: {
				xtype: 'panel',
				width: 300,       // Adjusted width to match screenshot proportions
				height: 30,       // Adjusted height
				margin: '0 10 0 0',
				bodyPadding: 5,
				border: 1,
				style: {
					borderColor: 'black', // Light blue-gray border like screenshot
					borderStyle: 'solid',
					borderWidth: '1px',
					borderRadius: '6px',
					backgroundColor: '#fff'
				},
				layout: {
					type: 'hbox',
					align: 'middle',
					pack: 'center'
				}
			},
			items: [{
				itemId: 'spaDisplayBox',
				html: '<div style="text-align:center;font-size:13px;font-family:Arial, sans-serif;">Projected Semester Average: <b style="color:#1E1E1E;">66.66</b></div>'
			}, {
				itemId: 'usCreditDisplayBox',
				html: '<div style="text-align:center;font-size:13px;font-family:Arial, sans-serif;">Projected US Credit: <b style="color:#1E1E1E;">4.00</b></div>'
			}, {
				itemId: 'ectsCreditDisplayBox',
				html: '<div style="text-align:center;font-size:13px;font-family:Arial, sans-serif;">Projected ECTS Credit: <b style="color:#1E1E1E;">4.00</b></div>'
			}]
		},{
			xtype: 'box',
			height: 2, // Thicker line
			width: '98%',
			style: {
				borderTop: '2px dashed #999', // Thicker and spaced-out line
				margin: '20px 0px 0px 13px'
			}
		},{
			xtype:'grid',
			title: getProgramandcourseTranslation('STUDENT_HOLDS'),
			itemId : 'studentHoldItemId',
			border: true,
			width: 1060,
			minHeight: 100, // Set the minimum height
			maxHeight: 300, // Set the maximum height
			viewConfig: {
				stripeRows: true
			},
	
			store: Ext.create('Academia.store.student.managehold.ProgressionPanelStudentHoldGridStore'),
	
			columns: [{
				header:  getCommonTranslation("HOLD_CATEGORY_NAME"),
				dataIndex:'holdCategoryName',
				flex:.1,
				sortable:true
			},{
				header:  getCommonTranslation("HOLD_SUB_CATEGORY_NAME"),
				dataIndex: 'subHoldCategoryName',
				flex:.1,
				sortable:true
			},{
				header:  getCommonTranslation("APPLIED_DATE"),
				dataIndex: 'studentHoldAppliedDate',
				flex:.1,
				sortable:true,
				renderer: function(date) {
					return date;
				}
			},{
				header: getCommonTranslation("APPLIED_BY"),
				dataIndex: 'holdAppliedBy',
				flex: .1,
				sortable: true
			},{
				header: getProgramandcourseTranslation("Reason_for_Applying_Hold_Alert"),
				dataIndex: 'reasonForApply',
				flex: .1,
				sortable: true,
				renderer: function (val, metaData) {
					if (!isNullOrEmpty(val)) {
						var encodedValue = Ext.String.htmlEncode(val).replace(/\n/g, '<br>');
						metaData.tdAttr = 'data-qtip="' + encodedValue + '"'; // Tooltip to show full content on hover

						return '<div class="promotion-panel-list-remark-cell">' + encodedValue + '</div>';
					}
				}
			}]
		},{
		xtype:'grid',
		title: getCommonTranslation('PERIOD'),
		itemId: 'promotionPanelPeriodGrid',
		border: true,
		width: 1060,
		minHeight: 100, // Set the minimum height
		maxHeight: 300, // Set the maximum height
		viewConfig: {
			stripeRows: true
		},
		store: Ext.create('Academia.store.coursetransaction.promotion.PromotionPanelPeriodList'),
		columns: [{
			header: getCommonTranslation('PROGRAM'),
			dataIndex: 'programName',
			sortable: false,
			flex: .2
		}, {
			header: getCommonTranslation('PERIOD'),
			dataIndex: 'periodName',
			sortable: false,
			flex: .2
		}, {
			header: getCommonTranslation('CAMPUS'),
			dataIndex: 'academyLocationName',
			sortable: false,
			flex: .2

		}, {
			header: getCommonTranslation('WEIGHTED_AVERAGE'),
			dataIndex: 'spa',
			align: 'center',
			sortable: false,
			flex: .2

		}, {
			header: getCommonTranslation('PERIOD_CREDITS'),
			dataIndex: 'obtainedCreditSum',
			sortable: false,
			flex: .2
		}],
	},{
		xtype: 'container',
		layout: 'absolute',
		style: {
			marginLeft: '4% !important',
			zIndex: 2
		},
		items: [{
			xtype: 'checkbox',
			boxLabel: getProgramandcourseTranslation('SHOW_NON_PASSING_COURSES'),
			name: 'showNonPassingCourses',
			itemId: 'showNonPassingCourses',
			inputValue: true,
			uncheckedValue: false,
			width: 315,
			style: {
				marginLeft: '30px !important',
				marginTop: '100px !important',
				zIndex: '10 !important'
			},
			listeners: {
				change: function (checkbox, newValue, oldValue) {
					var grid = checkbox.up('panel').down('#promotionPanelCurrentPeriodGrid');
					var store = grid.getStore();
					var win = checkbox.up('window');
					var scrollTop = win.body.getScrollTop();

					var applyNonPassingFilter = function () {
						store.filterBy(function (record) {
							var moderate = parseFloat(record.get('moderate')) || 0;
							var effectiveMarks = parseFloat(record.get('effectiveMarks')) || 0;
							var minMarks = parseFloat(record.get('minMarksOrGrade')) || 0;
							var total = moderate + effectiveMarks;
							return total < minMarks;
						});
					};

					store.clearFilter();

					if (newValue === true) {
						applyNonPassingFilter();
					}

					win.body.scroll('top', scrollTop, false);
					// Store the function on grid for reuse in edit event
					grid.applyNonPassingFilter = applyNonPassingFilter;
				}
			}
		}],
	}, {
		xtype: 'panel',
		title: getCommonTranslation('CURRENT_PERIOD'),
		width: 1060,
		itemId: 'currentPeriodPanel',
		collapsible: true,
		collapsed: false,
		header: {
			titlePosition: 0,
			items: [{
				xtype: 'label',
				itemId: 'expandCollapseLabel',
				html: '<img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" ' +
				'style="margin-right: 5px;"> ' +
				'Collapse',
				style: {
					'font-weight': 'bold',
					'font-size': '13px',
					'cursor': 'pointer',
					'margin-left': '10px',
					'display': 'inline-block'
				},
				listeners: {
					afterrender: function(label) {
						var panel = label.up('#currentPeriodPanel');
						setTimeout(function () {
							panel.down('tool').el.on('click', function() {
								var win = panel.up('window');
								var scrollTop = win.body.getScrollTop();
								panel.scrolledHeight = scrollTop;
							});
						},2000)
					}
				}
			}]
		},
		listeners: {
			expand: function(panel) {
				var label = panel.down('#expandCollapseLabel');
				var showNonPassingCourses = panel.up('window').down('#showNonPassingCourses');
				var win = panel.up('window');

				if (label) {
					showNonPassingCourses.show();
					label.setText(
							'<img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" ' +
							'style="margin-right: 5px;"> ' +
							'Collpase', false
					);
				}

				win.body.scroll('top', panel.scrolledHeight + 30, false);
			},
			collapse: function(panel) {
				var label = panel.down('#expandCollapseLabel');
				var showNonPassingCourses = panel.up('window').down('#showNonPassingCourses');
				var win = panel.up('window');

				if (label) {
					showNonPassingCourses.hide();
					label.setText(
							'<img src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" ' +
							'style="margin-right: 5px;"> ' +
							'Expand', false
					);
				}

				win.body.scroll('top', panel.scrolledHeight - 30, false);
			}
		},
		items: [{
			xtype: 'grid',
			itemId: 'promotionPanelCurrentPeriodGrid',
			border: true,
			width: 1050,
			autoHeight: true,
			viewConfig: {
				stripeRows: true,
				scroll: false
			},
			store: Ext.create('Academia.store.coursetransaction.promotion.PromotionPanelCurrentPeriodList'),
			columns: [{
				header: getCommonTranslation('COURSE_CODE_NAME'),
				dataIndex: 'courseName',
				sortable: false,
				flex: .4
			}, {
				header: getProgramandcourseTranslation('US_ECTS'),
				dataIndex: 'combinedCredits',
				sortable: false,
				align: 'center',
				flex: .11
			}, {
				header: getCommonTranslation('ASSESSMENTS'),
				dataIndex: 'eventMarks',
				sortable: false,
				align: 'center',
				flex: .15
			}, /*{
				header: getCommonTranslation('Remark'),
				dataIndex: 'remark',
				sortable: false,
				align: 'center',
				flex: .15,
				renderer: function(value) {
					if (!value || value.trim() === '') {
						return 'None';
					}
					return value;
				}
			},*/{
				header: getCommonTranslation('RESIT'),
				dataIndex: 'resitStatus',
				sortable: false,
				align: 'center',
				flex: .1

			}, {
				header: getCommonTranslation('SCORES'),
				dataIndex: 'combinedScore',
				align: 'center',
				sortable: false,
				flex: .15,
				renderer: function (val, rec, record) {
					var thisGrid = this;
					var win = thisGrid.up('window');
					var isCompleted = win.isCompleted;
					var isSubmitted = win.isSubmitted;
					var moderateMarks = record.raw.moderate;
					var effectiveMarks = record.raw.effectiveMarks;
					if((!isNullOrEmpty(isCompleted) && isCompleted == true) && !isNullOrEmpty(moderateMarks)){
						var actualEffectiveMarks = parseFloat(effectiveMarks) - parseFloat(moderateMarks);
						record.set('moderate', '');
						return effectiveMarks + ' (<span class="effectiveMarksSpanCls" title="' + getCommonTranslation('SCORES') + '">' + actualEffectiveMarks + '</span>+<span class="moderateMarksSpanCls" title="' + getCommonTranslation('MODERATE') + '">' + moderateMarks + '</span>)';
					} else {
						return val;
					}
				}

			}, {
				header: getCommonTranslation('MODERATE'),
				dataIndex: 'moderate',
				sortable: false,
				flex: .12,
				align: 'center',
				editor: {
					xtype: 'numberfield',
					name: 'moderate',
					itemId: 'moderateId'
				},
				renderer: function (value, meta, record) {
					// Gray out non-editable cells
					if (record.raw && record.raw.marksOrGrade == 'MARKS') {
						meta.style = 'color: gray; background-color: #f5f5f5;';
					}
					return value;
				}
			}, {
				header: getCommonTranslation('RETAKE'),
				dataIndex: 'enrollCourseStatus',
				sortable: false,
				align: 'center',
				flex: .09
			}, {
				header: getCommonTranslation('DECISIONS'),
				dataIndex: 'status',
				sortable: false,
				align: 'center',
				flex: .2,
				renderer: function (val, rec, record) {
					if (!isNullOrEmpty(record.data.moderate)) {
						var scores = parseFloat(record.get('effectiveMarks'));
						var moderate = parseFloat(record.data.moderate);
						var minMarksOrGrade = parseFloat(record.get('minMarksOrGrade'));
						var total = scores + moderate;
						if(total>=minMarksOrGrade){
							return getCommonTranslation("PASS");
						}
						else{
							return getCommonTranslation("FAIL");
						}
					} else {
						return getCommonTranslation(val);
					}
				}
			}],
			plugins: [{
				ptype: 'cellediting',
				clicksToEdit: 1,
				listeners: {
					edit: function (editor, context) {
						var grid = context.grid;
						var win = grid.up('window');
						var checkbox = win.down('#showNonPassingCourses');

						if (checkbox && checkbox.getValue() == true) {
							var store = grid.getStore();
							store.clearFilter();
							grid.applyNonPassingFilter();
						}
					},
					beforeedit: function (ed, e) {
						var win = ed.grid.up('window');
						var decisionTempleteRemarkGrid = win.down('#decisionTempleteRemarkGrid')
						var decisionTempleteRemarkGridStore = decisionTempleteRemarkGrid.getStore();

						if (e.field == 'moderate') {
							if (e.record.raw && (e.record.raw.marksOrGrade == 'GRADE' || e.record.raw.whetherSpecialGrade == true)) {
								return false; // cancel editing for this cell
							}
						}

						if (decisionTempleteRemarkGridStore.getCount()) {
							if(decisionTempleteRemarkGridStore.data.items[0].data.value=="Submitted"){
								showNotificationMessage(getCommonTranslation('ALERT'), getCommonTranslation('CANNOT_UPDATE_MODERATION_FOR_COMPLETED_RECORDS'));
								return false;
							}

							if(decisionTempleteRemarkGridStore.data.items[0].data.value=="Completed"){
								showNotificationMessage(getCommonTranslation('ALERT'), getCommonTranslation('CANNOT_UPDATE_MODERATION_FOR_COMPLETED_RECORDS'));
								return false;
							}
						}
					}
				}
			}]
		}]
	},{
		xtype:'grid',
		title: getCommonTranslation('UPCOMMING_PERIOD'),
		itemId: 'promotionPanelUpcommingPeriodGrid',
		border: true,
		width: 1060,
		minHeight: 100, // Set the minimum height
		maxHeight: 300, // Set the maximum height
		viewConfig: {
			stripeRows: true
		},
		store: Ext.create('Academia.store.coursetransaction.promotion.PromotionPanelUpcomingPeriod'),
		columns: [{
			header: getCommonTranslation('ACADEMIC_TERM'),
			dataIndex: 'academicTermCode',
			sortable: false,
			flex: .2
		}, {
			header: getCommonTranslation('PERIOD_STATUS'),
			dataIndex: 'periodStatus',
			sortable: false,
			flex: .15,
			renderer:function(val,rec){
				if(isNullOrEmpty(val)){
					return "";
					//rec.tdCls = 'gridInputCustomStyle'; 
					//return getExaminationTranslation('CLICK_TO_SELECT');
				}else{
					if(rec.record.data.resultStatus == "Suspended" || rec.record.data.resultStatus.indexOf("Suspended")!=-1){
						return "Suspended";
					}else if(rec.record.data.periodStatus == 'ADD_ENROLLMENT'){
						return getProgramandcourseTranslation('STUDENT_JOURNEY_ADD_ENROLLMENT');
					}else{
						return getCommonTranslation(rec.record.data.periodStatus);
					}
				}
			}
		}, {
			header: getCommonTranslation('ACADEMY_LOCATION'),
			dataIndex: 'academicLocationName',
			sortable: false,
			flex: .2
		}, {
			header: getCommonTranslation('CAMPUS'),
			dataIndex: 'campusName',
			sortable: false,
			flex: .1

		}, {
			header: getCommonTranslation('PROGRAM_NAME'),
			dataIndex: 'programName',
			sortable: false,
			flex: .1

		}, {
			header: getCommonTranslation('BATCH'),
			dataIndex: 'batchName',
			sortable: false,
			flex: .2,
		}, {
			header:  getCommonTranslation('PERIOD_NAME'),
			dataIndex: 'periodName',
			sortable: false,
			flex: .1
		}, {
			header: getCommonTranslation('ENROLLMENT_STATUS'),
			dataIndex: 'resultStatus',
			sortable: false,
			flex: .2
		}],
	},{
		xtype:'grid',
		title: getCommonTranslation('DOCUMENTS_AND_NOTES'),
		itemId: 'promotionPanelDocumentsAndNotesGrid',
		border: true,
		width: 1060,
		minHeight: 100, // Set the minimum height
		maxHeight: 300, // Set the maximum height
		viewConfig: {
			stripeRows: true
		},
		listeners: {
		    afterrender: function(grid) {
				// Adding the "View All" button directly to the grid header after render
				grid.getHeader().add({
					xtype: 'button',
					text: getCommonTranslation('VIEW_ALL'), // Text for the button
					ui: 'CustomBtnSubmit', // Optional styling class (adjust if necessary)
					cls: 'common-btn-cls', // Optional styling class (adjust if necessary)
					scale: CONSTANTS.BUTTONSIZE,
					itemId: 'documentsAndNotesViewAllBtn'
				});
			}
		},
		store: Ext.create('Academia.store.personinfo.student.StudentForAcademicToicsStore'),
		columns: [{
			header: getCommonTranslation('CATEGORY'),
			dataIndex: 'academicTopic',
			sortable: false,
			flex: .2
		}, {
			header: getCommonTranslation('SUB_CATEGORY'),
			dataIndex: 'academicSubTopic',
			sortable: false,
			flex: .2
		}, {
			header: getCommonTranslation('DATE'),
			dataIndex: 'createdAt',
			sortable: false,
			flex: .2,
	        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
				return dateRender(val);
			}
		},{
			header: getCommonTranslation("URLS"),
			dataIndex: 'academicTopicUrls',
			flex:.2,
			sortable: true,
			renderer:function(value,rec){
				if(!isNullOrEmpty(rec.record.get('urlName'))) {
					if(rec.record.get('academicTopicUrls').length == 1) {
						value = rec.record.get('academicTopicUrls')[0].name;
						var value1=!isNullOrEmpty(value)?value:rec.record.get('academicTopicUrls')[0].name;
						var newPath=rec.record.get('academicTopicUrls')[0].path;    
						var val=!isNullOrEmpty(value1)?value1:newPath;
						return "<a href="+newPath+" target='_blank'>"+val;
					}
					else {
						var value1=!isNullOrEmpty(rec.record.get('urlName'))?rec.record.get('urlName'):rec.record.data.name;
						var newPath=rec.record.data.path;    
						var val=!isNullOrEmpty(value1)?value1:newPath;
						return "<a href='javascript:void(0)'>"+val;
					}
				}
				else {
					return "";
				}
			}
		},{
			header: getCommonTranslation("DOCUMENTS"),
			dataIndex: 'academicTopicDocuments',
			flex:.2,
			sortable: true,
			renderer:function(value,rec){
				if(!isNullOrEmpty(rec.record.get('documentName'))) {
					var value1=!isNullOrEmpty(rec.record.get('documentName'))?rec.record.get('documentName'):rec.record.data.name;
					var newPath=rec.record.data.path;    
					var val=!isNullOrEmpty(value1)?value1:newPath;
					return "<a href='javascript:void(0)'>"+val;
				}
				else {
					return "";
				}
			}
		}, {
			header: getProgramandcourseTranslation('REMARKS'),
			dataIndex: 'description',
			sortable: false,
			flex: .2

		}],
	},
	{
		xtype:'grid',
		title: getProgramandcourseTranslation('PREVIOUS_PROGRESSION_LETTERS'),
		itemId: 'previousProgressionLettersGrid',
		border: true,
		width: 1060,
		minHeight: 100, // Set the minimum height
		maxHeight: 300, // Set the maximum height
		viewConfig: {
			stripeRows: true
		},
		store: Ext.create('Academia.store.coursetransaction.promotion.PreviousProgressionLetters'),
		columns: [{
			header: getProgramandcourseTranslation('SENT_DATE'),
			dataIndex: 'sentDate',
			sortable: false,
			flex: .2
		}, {
			header: getProgramandcourseTranslation('DECISON'),
			dataIndex: 'progressionStatus',
			sortable: false,
			flex: .2
		},{
			header: getProgramandcourseTranslation('SUBJECT'),
			dataIndex: 'sujectLine',
			sortable: false,
			flex: .2,
			renderer: function (value, rec) {
				return "<a href='javascript:void(0)'>" + value;
			}
		}]
	},
	{
		xtype: 'grid',
		title: getPersonModuleTranslation('LEARNING_ALLOWANCE'),
		itemId : 'learningAllowanceItemId',
		border: true,
		width: 1060,
		minHeight: 100, // Set the minimum height
		maxHeight: 300, // Set the maximum height
		viewConfig: {
			stripeRows: true
		},

		store: Ext.create('Academia.store.personinfo.common.pasthistory.LearningAllowanceStore'),
		columns: [{
			header: getPersonModuleTranslation('LEARNING_ALLOWANCE'),
			dataIndex: 'learningAllowanceCSMMapping',
			sortable: true,
			flex: .2,
			renderer: function (record) {
				var result = '';
				for (var i in record) {
					result = result.concat(record[i].learningAllowancesCSM.value);
					result = result.concat(",");
				}
				return result.substring(0, result.length - 1);
			}
		},{
			header: getCommonTranslation('VALID_FROM'),
			dataIndex: 'validForm',
			sortable: true,
			flex: .2,
			renderer: function (record) {
				return dateRender(record);
			}
		},{
			header: getCommonTranslation('APPLIES_TO'),
			dataIndex: 'appliesTo',
			sortable: true,
			flex: .2,
			renderer: function (record) {
				var result = '';
				for (var i in record) {
					result = result.concat(record[i].lAAcademyLocation.value);
					result = result.concat(",");
				}
				return result.substring(0, result.length - 1);
			}
		}]
	}]
});