/**
 * @author Dharmendra.prajapati
 * 
 */
Ext.define('Academia.view.coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.SectionCourseCvrgPlan',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.sectioncoursecvrgplan',
	plugins : "formlabelrequired",
	autoScroll : true,
	cls:'customSearchPanel',
	frame: true,
	method : 'POST',
	standardSubmit : false,
	items : [ {
		xtype : 'form',
		width : '100%',
		items : [{
			xtype:'hidden',
			name:'courseVariantId'
		},{
			xtype:'hidden',
			name:'roomId'
		},{
			xtype:'hidden',
			name:'classTeacher'
		},
		{
			xtype : 'radiogroup',
			itemId : 'courseSectionRadio_Id',
			items : [{
				boxLabel : getCourseTxCommonTranslation('PROGRAM_BATCH_SECTION'),
				name : 'sectionCourse',
				inputValue : 'programBatchSection',
				checked : true
			},{
				boxLabel : getCourseTxCommonTranslation('COURSE_SECTION'),
				name : 'sectionCourse',
				inputValue : 'courseSection'

			}
			]
		},
		{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			layout : {
				type : 'hbox'
			},
			items : [
			         {
			        	 xtype : 'customcombobox',
			        	 fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
			        	 name : 'course',
			        	 itemId : 'course_Id',
			        	 store : 'attendance.StudentCourses',
			        	 displayField : 'courseCodeName',
			        	 valueField : 'courseId',
			        	 typeAhead : true,
			        	 forceSelection : true,
			        	 allowBlank : false,
			        	 queryParam:'name',
			        	 minChars:3,
			        	 typeAhead:false,
			        	 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			        	 listConfig: {
			        		 listeners: {
			        			 beforeshow: function(picker) {
			        				 picker.minWidth = picker.up('combobox').getSize().width;
			        			 }
			        		 },
			        		 loadingText: getCommonTranslation('SEARCHING'),
			        		 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			        		 getInnerTpl: function() {
			        			 return '<div class="search-item">' +
			        			 '{code}'  +
			        			 '</div>';
			        		 }
			        	 }
			         },
			         {
			        	 xtype : 'customcombobox',
			        	 fieldLabel : getCourseTxCommonTranslation('COMPONENT'),
			        	 name : 'componentSectionId',
			        	 itemId : 'componentSectionId',
			        	 store : 'course.coursetopic.CourseComponentStore',
			        	 displayField : 'value',
			        	 valueField : 'id',
			        	 typeAhead : true,
			        	 forceSelection : true,
			        	 hidden : true,
			        	 allowBlank : false
			         },
			         {
			        	 xtype : 'customcombobox',
			        	 fieldLabel : getCourseTxCommonTranslation('SECTION'),
			        	 name : 'section',
			        	 itemId : 'courseSection_Id',
			        	 store : 'attendance.SectionByCourseNComponent',
			        	 displayField : 'sectionCode',
			        	 valueField : 'sectionId',
			        	 typeAhead : true,
			        	 forceSelection : true,
			        	 allowBlank : false,
			        	 disabled:true
			         } ]
		},
		         {
		        	 xtype : 'fieldcontainer',
		        	 layout : 'hbox',
		        	 defaults : {
		        		 width : 226,
		        		 labelAlign : 'top'
		        	 },
		        	 layout : {
		        		 type : 'hbox'
		        	 },
		        	 items : [
		        	          {
		        	        	  xtype : 'customcombobox',
		        	        	  fieldLabel : getCourseTxCommonTranslation('PROGRAM'),
		        	        	  name : 'program',
		        	        	  itemId : 'program_Id',
		        	        	  store : 'common.ProgramByAcademyLocationStore',
		        	        	  displayField : 'value',
		        	        	  valueField : 'id',
		        	        	  typeAhead : true,
		        	        	  forceSelection : true,
		        	        	  allowBlank : false,
		        	        	  hidden : true
		        	          },
		        	          {
		        	        	  xtype : 'customcombobox',
		        	        	  fieldLabel : getCourseTxCommonTranslation('BATCH'),
		        	        	  name : 'batch',
		        	        	  itemId : 'batch_Id',
		        	        	  store : 'enquiry.AcademicBatchStore',
		        	        	  displayField : 'value',
		        	        	  valueField : 'id',
		        	        	  typeAhead : true,
		        	        	  forceSelection : true,
		        	        	  allowBlank : false,
		        	        	  hidden : true
		        	          },
		        	          {
		        	        	  xtype : 'customcombobox',
		        	        	  fieldLabel : getCourseTxCommonTranslation('PERIOD'),
		        	        	  name : 'period',
		        	        	  itemId : 'period_Id',
		        	        	  store : 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
		        	        	  displayField : 'value',
		        	        	  valueField : 'id',
		        	        	  typeAhead : true,
		        	        	  forceSelection : true,
		        	        	  allowBlank : false,
		        	        	  hidden : true
		        	          } ]
		         },
		         {
		        	 xtype : 'fieldcontainer',
		        	 layout : 'hbox',
		        	 defaults : {
		        		 width : 226,
		        		 labelAlign : 'top'
		        	 },
		        	 layout : {
		        		 type : 'hbox'
		        	 },
		        	 items : [
		        	          {
		        	        	  xtype : 'customcombobox',
		        	        	  fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
		        	        	  name : 'programCourse_Id',
		        	        	  itemId : 'programCourse_Id',
		        	        	  store : 'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.CourseStore',
		        	        	  displayField : 'value',
		        	        	  valueField : 'id',
		        	        	  typeAhead : true,
		        	        	  hidden : true,
		        	        	  forceSelection : true,
		        	        	  allowBlank : false,
		        	        	  queryParam:'name',
		        	        	  minChars:3,
		        	        	  typeAhead:false,
		        	        	  emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		        	        	  listConfig: {
		        	        		  listeners: {
		        	        			  beforeshow: function(picker) {
		        	        				  picker.minWidth = picker.up('combobox').getSize().width;
		        	        			  }
		        	        		  },
		        	        		  loadingText: getCommonTranslation('SEARCHING'),
		        	        		  emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		        	        		  getInnerTpl: function() {
		        	        			  return '<div class="search-item">' +
		        	        			  '{code}'  +
		        	        			  '</div>';
		        	        		  }
		        	        	  }
		        	          },
		        	          {
		        	        	  xtype : 'customcombobox',
		        	        	  name : 'componentSection_Id',
		        	        	  itemId : 'componentSectionItemId',
		        	        	  fieldLabel : getCourseTxCommonTranslation('COMPONENT'),
		        	        	  store : 'course.coursetopic.CourseComponentStore',
		        	        	  displayField : 'value',
		        	        	  valueField : 'id',
		        	        	  typeAhead : true,
		        	        	  forceSelection : true,
		        	        	  hidden : true,
		        	        	  allowBlank : false
		        	          },
		        	          {
		        	        	  xtype : 'customcombobox',
		        	        	  fieldLabel : getCourseTxCommonTranslation('SECTION'),
		        	        	  name : 'programCoursesection',
		        	        	  itemId : 'programCoursesection_ID',
		        	        	  store : 'coursetransaction.facultytopicassignment.CourseSectionByPeriodIDCourseIDStore',
		        	        	  displayField : 'value',
		        	        	  valueField : 'id',
		        	        	  typeAhead : true,
		        	        	  forceSelection : true,
		        	        	  allowBlank : false,
		        	        	  hidden : true
		        	          } ]
		         },
		         {
		        	 xtype : 'fieldcontainer',
		        	 width : 'auto',
		        	 cls : 'windowBtnPos',
		        	 items : [ {
		        		 xtype : 'button',
		        		 text : getCourseTxCommonTranslation('GET_TOPICS'),
		        		 itemId : 'courseCoverageGetTopics',
		        		 buttonAlign : 'left',
		        		 ui : 'CustomBtnSubmit',
		        		 scale : CONSTANTS.BUTTONSIZE,
		        		 formBind : true
		        	 } ]
		         }
		         ]
	} ]
});