/**
 * @author Rajkumar.patidar
 */

Ext.define('Academia.view.coursetransaction.sectionmanagement.CourseSectionWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.coursesectionwin',
	autoScroll: true,
	title:getCourseTxCommonTranslation('ADD_NEW_SECTION'),
	frame: true,
//	 width : 350,
	autoScroll:true,
	modal:true,
	
	method: 'POST',
	items: [{
		xtype: 'dynamicfieldformwin',
		customFieldEntity:CONSTANTS.SECTION_CUSTOM_FIELD,
		bodyPadding: '5 5 5 5',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			width:'auto'
		},
		standardSubmit: false,
		items: [{
			xtype:'fieldcontainer',
      	    layout:'hbox',
      	    defaults: {
      		   labelAlign: 'top'
      	    },
      	   items: [{
					xtype: 'textfield',  
					name : 'locationCode',
					itemId : 'locationCodeItemId',
					fieldLabel: getCommonTranslation('LOCATION_CODE'),
					readOnly : true,
					hidden:true,
					width:  150
				}]	
		},{
			xtype:'fieldcontainer',
      	    layout:'hbox',
      	    defaults: {
      		   width: 226,
      		   labelAlign: 'top'
      	    },
      	   items: [{
					xtype: 'hidden',
					name: 'id'
				},{
					xtype: 'textfield',
					name: 'sectionCode',
					fieldLabel: getCourseTxCommonTranslation('SECTION_NAME'),
					maxLength:99,
			    	enforceMaxLength : true,
					allowBlank:false
					
				},{
					xtype: 'textfield',
					name: 'alternateName',
					maxLength:20,
					fieldLabel: getCourseTxCommonTranslation('ALTERNATE_NAME')
					
				}/*,{
					xtype: 'textfield',
					name: 'sectionRule',
					fieldLabel: getCourseTxCommonTranslation('CONFIGURE_RULE')
				}*/]	
		},{
			xtype:'fieldcontainer',
      	    layout:'hbox',
      	    defaults: {
      		   width: 226,
      		   labelAlign: 'top'
      	    },
      	   items: [{
					xtype: 'customcombobox',
					name:'courseVariant',
					hidden:true,
					readOnly:true,
					itemId: 'courseVariantId',
				    store:'coursetransaction.sectionmanagement.CoruseVariantSectionStore',
				    fieldLabel: getCourseTxCommonTranslation('COURSE_VARIANT'),
					displayField: 'code',
					valueField: 'id',
					typeAhead:true,
					forceSelection:true
				},{	
					xtype: 'customcombobox',
				    name: 'calendar',
				    fieldLabel: getCourseTxCommonTranslation('ASSIGN_CALENDER') ,
				    //store:'calendar.ActiveCalendarStore',
				    store:'facilitiesresources.resourcemaster.MappedCalenderStore',
				    valueField:'id',
				    displayField:'value',
				    itemId: 'calendar',
				    editable:false,
				    allowBlank:false
				},{
					xtype: 'customcombobox',
					width:226,
					name: 'assignHomeRoom',
					itemId: 'assignHomeRoom',
					fieldLabel: getCourseTxCommonTranslation('ASSIGN_HOME_ROOM'),
					//store:'coursetransaction.sectionmanagement.AssignHomeRoomStore',
					store:'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.ClassRoom',
					displayField:'value',
					valueField:'id',
					typeAhead:true,
					forceSelection:true,
					allowBlank:false,
					editable:false
				}]	
		},{	
			xtype:'fieldcontainer',
      	    layout:'hbox',
      	    defaults: {
      		   width: 226,
      		   labelAlign: 'top'
      	    },
      	   items: [{
					xtype: 'numberfield',
		  		    name: 'minCapacity',
		  		    itemId:'minCapacity_id',
		  		    fieldLabel: getCourseTxCommonTranslation('MIN_CAPACITY'),
		  		    minValue:0,
		  		    maxValue : 5000,
		  		    hideTrigger:true,
		  		    allowBlank:false,
					allowExponential:false,
					allowDecimals:false,
		  			validator : function(val) {
						var maxValuefield = Ext.ComponentQuery.query('numberfield#maxCapacity_id')[0];
						var maxValue = maxValuefield.getValue();
						if (maxValue != null) {
							if (val <= maxValue) {
								maxValuefield.clearInvalid();
								return true;
							} else {
								return 'Should be less than max capacity';
							}
						} else {
							return true;
						}
					}
				},{
					xtype: 'numberfield',
		  		    name: 'maxCapacity',
		  		    itemId:'maxCapacity_id',
		  		    fieldLabel: getCourseTxCommonTranslation('MAX_CAPACITY'),
		  		    minValue:1,
		  		    hideTrigger:true,
		  		    maxValue : 5000,
		  		   allowBlank:false,
		  		    hideTrigger:true,
					allowExponential:false,
					allowDecimals:false,
		  			validator : function(val) {
						var minValueField = Ext.ComponentQuery.query('numberfield#minCapacity_id')[0];
						var minValue = minValueField.getValue();
						if (minValue != null) {
							if (val >= minValue) {
								minValueField.clearInvalid();
								return true;
							} else {
								return 'Should be greater than min capacity';
							}

						} else {
							return true;
						}
					}
				}] 
		},{	
			xtype:'fieldcontainer',
      	    layout:'hbox',
      	    defaults: {
      		   width: 226,
      		   labelAlign: 'top'
      	    },
      	   items: [{
			xtype : 'customcombobox',
			name : 'academicTerm',
			itemId : 'academicTerm',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
			store : 'common.AcademicTermStore',
			valueField : 'id',
			displayField : 'value',
			queryMode:'local',
			editable:true,
			typeAhead : false,
			forceSelection : true,
			allowBlank:false,
			anyMatch : true
		},{
			xtype : 'customcombobox',
			name : 'evalutionPlan',
			itemId : 'evalutionPlan',
			hidden:false,
			fieldLabel : getExaminationTranslation('EVALUATION_PLAN'),
			store : 'common.EvalutionPlanIdInSectionStore',
			valueField : 'id',
			displayField : 'value',
			editable:false
		}] 
		}, 	{	
			 xtype:'fieldcontainer',
      	     layout:'hbox',
      	     defaults: {
        	 width: 160,
      		 labelAlign: 'top'
      	    },
            
      	    items: [{
           	 xtype : 'datefield',
		 	 width : 150,
		  	 name : 'examDate',
		     itemId : 'examDate',
           	 minValue: new Date(),
			 fieldLabel : getCommonTranslation('EXAM_DATE'),
			 listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
		    },
          {
			xtype : 'timefield',
			 name : 'startTime',
			 width: 150,
			 itemId : 'startTime',
		     fieldLabel : getCommonTranslation('EXAM_START_TIME'),
			 format : 'g:i A',
			 vtype : 'timerange',
			 increment: 5,
		     endTimeField : 'endTime',
             hidden:true,
		   },
		   {
			 xtype : 'timefield',
			 name : 'endTime',
			 width: 150,
			 itemId : 'endTime',
		     fieldLabel : getCommonTranslation('EXAM_END_TIME'),
		     format : 'g:i A',
	         vtype : 'timerange',
             startTimeField : 'startTime',
             increment: 5,
             hidden:true,
			 validator : function(val) {
        	 var startTime = Ext.ComponentQuery.query('timefield#startTime')[0].rawValue;
        	    if(!isNullOrEmpty(val))
	 			   {
                         if (!isNullOrEmpty(startTime) ) {
        			        if (val > startTime) {
        				  			return true;
        			  							}
                       		  else if(startTime>val) {
          	                   return true;
                           		 }
                       		 else
								{
        					  return 'Exam Start Time & End Time can’t be the same';
								}
        						  }
        	  		}
         		else 
           	   {
	    	   return true;
           		  }
        	  		}
		}]}
		,{
      	  xtype : 'radiogroup',
      	  fieldLabel : getCourseTxCommonTranslation('STUDENT_COURSE_ENROLLMENT_CRITERIA'),
      	  itemId : 'programPeriodInherited_Id',
      	  allowBlank : false,
      	  layout : {
	        		 type : 'vbox'
	        	 },
    	  defaults: {
    		   width: 226,
    		   labelAlign: 'top'
    	    }, 
      	  items : [{
      	        	   boxLabel : getCourseTxCommonTranslation('FIRST_COME_SERVE'),
      	        	   name : 'studentCourseEnrollmentCriteria',
      	        	   inputValue : 'FIRST_COME'

      	           },{
      	        	   boxLabel : getCourseTxCommonTranslation('FACULTY_APPROVED'),
      	        	   name : 'studentCourseEnrollmentCriteria',
      	        	   inputValue : 'BY_FACULTY'
      	        	   
      	           } 
		]},{
				xtype: 'checkboxfield',
				labelAlign: 'right',
				name :'isShowOnCourseRegistration',
				itemId:'isShowOnCourseRegistration',
				boxLabel: getCommonTranslation('SHOW_ON_STUDENT_PORTAL_FOR_REGISTRATION'),
				inputValue : true,
				checked : true,
				uncheckedValue: false
		},{	
			layout: {
				type: 'hbox'
			},
			style:{
				marginLeft:'-03px'
			},
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'addSectionSaveBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			  },{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'addSectionCancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]     
});
