Ext.define('Academia.view.coursetransaction.sectionmanagement.SectionGroupEnrolledStudent', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.sectiongroupenrolledstudent',
	store : 'coursetransaction.sectionmanagement.GetEnrolledStudentListing',
	border: true,
	title: getProgramandcourseTranslation('ENROLLED_STUDENTS'),
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'coursetransaction.sectionmanagement.GetEnrolledStudentListing',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}
	],
	initComponent: function() {

		var grid=this;
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     

	},
	columns :[{
		header : getCourseTxCommonTranslation('SECTION_GROUP'),
		dataIndex : 'sectionName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('ADMISSION_CODE'),
		dataIndex : 'admissionCode',
		flex:1
	},{
		header : getCourseTxCommonTranslation('STUDENT_CODE'),
		dataIndex : 'studentCode',
		flex:1,
		renderer:function(value,meta,record){
			if(record.data.studentId == 0){
				return record.data.studentId ;
			} else {
				return '<a href=#>'+record.data.studentCode +'</a>'
			}
		}
	},{
		header : getCourseTxCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1
	},{
		header : getCommonTranslation('STUDENT_FIRST_NAME'),
		dataIndex : 'firstName',
		flex:1,
		hidden :true
	},{
		header : getCommonTranslation('STUDENT_MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex:1,
		hidden :true
	},{
		header : getCommonTranslation('STUDENT_LAST_NAME'),
		dataIndex : 'lastName',
		flex:1,
		hidden :true
	}]
});


