/**
 * 
 */

Ext.define('Academia.view.coursetransaction.sectionmanagement.SectionTeacherMappingForm', {
    extend: 'Ext.window.Window',
    alias: 'widget.sectionteachermappingform',
    modal: true,
    title: getCommonTranslation('ADD_FACULTY'),
    autoScroll:true,
    frame:true,
    border: true,
    plugins:"formlabelrequired",
    items: [{
        xtype: 'idgeneratorformwin',
        items: [{
        	xtype : 'fieldcontainer',
        	width : '100%',
        	defaults : {
        		width : 440,
        		labelAlign : 'top'
        	},
        	items : [{
        		xtype: 'multiselectcombofield',
        		name: 'facultyId',
        		itemId:'facultyNameItemId',
        		store:Ext.create('Academia.store.coursetransaction.sectionmanagement.AssignClassTeacherSmartSearch'),
        		fieldLabel: getCommonTranslation('PRIMARY_FACULTY_CODE'),
        		valueField: 'id',
        		displayField: 'value',
        		queryParam:'nameOrCode',
        		forceSelection:true,
        		typeAhead:true,
        		minChars:3,
    			allowBlank: false,
    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				triggerAction: 'all',
		    	forceSelection:true,
        		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        		listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
        	},{
        		xtype: 'multiselectcombofield',
        		name: 'alternateId',
        		itemId:'alternateNameItemId',
        		fieldLabel: getCommonTranslation('ALTERNATE_FACULTY_CODE'),
        		store:Ext.create('Academia.store.program.programbatchdetail.AlternateFacultyStoreExpectTheseIds'),
        		valueField:'id',
        		displayField:'value',
        		queryParam:'codeOrName',
        		forceSelection:true,
        		typeAhead:true,
        		minChars:3,
        		triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        		enableKeyEvents  : 'true',
        		triggerAction: 'all',
        		forceSelection:true,
        		hidden : true,
        		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        		beforeBlur: function(){
        			var value = this.getRawValue();
        			if(value == ''){
        				this.lastSelection = [];
        			}
        			this.doQueryTask.cancel();
        			this.assertValue();
        		},
        		listConfig: {
        			listeners: {
        				beforeshow: function(picker) {
        					picker.minWidth = picker.up('combobox').getSize().width;
        				}
        			},
        			loadingText: getCommonTranslation('SEARCHING'),
        			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        			getInnerTpl: function() {
        				return '<div class="search-item">' +
        				'{value}' +
        				'</div>';
        			}
        		}
        	},{
            	xtype: 'fieldcontainer',
                width:'100%',
                cls:'windowBtnPos',
                items: [{
                    xtype: 'displayfield',
                    value : getProgramandcourseTranslation('PARAMETER_ADD_FACULTY_MSG')
                }]
            }
        	]},{
        		xtype:'fieldcontainer',
        		width:'100%',
        		cls:'windowBtnPos',
        		items: [{
        			xtype: 'button',
        			text: getCommonTranslation('SAVE'),
        			itemId: 'sectionTeacherMappingFormSubmit',
        			ui: 'CustomBtnSubmit',
        			scale: CONSTANTS.BUTTONSIZE,
        			formBind: true
        		}, {
        			xtype: 'button',
        			text: getCommonTranslation('CANCEL'),
        			itemId: 'sectionTeacherMappingFormCancel',
        			ui: 'CustomBtnCancel',
        			scale: CONSTANTS.BUTTONSIZE
        		}]
        	}]
    }]
});
