Ext.define('Academia.view.coursetransaction.studymaterialdistributionnew.CourseSmdGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.coursesmdgrid',
	store : 'coursetransaction.studymaterialdistributionnew.CourseSmdStr',
	title: getCommonTranslation('LIST_OF_COURSE_READING_MATERIAL'),
	border: true,
	refreshStoreData:true,
	selType:'checkboxmodel',
	selModel: {
		mode : 'MULTI',
		 allowDeselect: true,
		 checkOnly : true
	},
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
		      xtype: 'custompagingtoolbar',
		      itemId:'custompagingtoolbarcoursesmd',
	            plugins:['pagesize'],
			store : 'coursetransaction.studymaterialdistributionnew.CourseSmdStr',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	tbar: [{
		xtype: 'customcombobox',
		name: 'disributionId',
		itemId:'disributionId',
		emptyText: getCourseTxCommonTranslation('SMD_DISTRIBUTION_LIST'),
		store:'coursetransaction.studymaterialdistributionnew.DistributionListStr',
		displayField:'value',
		valueField:'id',
		width:226,
		forceSelection:true,
		typeAhead:true,
		style:{
			marginLeft:'15px'
		}
	},{
        xtype: 'button',
        text:getCourseTxCommonTranslation('DISPATCH_FORM'),
        itemId: 'printCourseDispatchForm',
        disabled: true
    },'->',{
		xtype: 'button',
		itemId: 'btnDownloadDispatchForms',
		disabled:true,
		text:getCourseTxCommonTranslation('DOWNLOAD_ALL_DISPATCH')
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);     
 },
	columns : [{
		header :getCourseTxCommonTranslation('ADMISSION_ID'),
		dataIndex : 'admissionCode',
		flex:1
	},{
		header : getCourseTxCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('HW_SECTION'),
		dataIndex : 'sectionCode',
		flex:1
	},{
	       header : getCourseTxCommonTranslation('DOCUMENT'),
		   dataIndex : 'documentPath',
		   flex:1,
		   renderer:function(value){
			   if(!isNullOrEmpty(value)){
				   return "<a href='#'>"+value+"</a>";
			   }
		   }
	 },{
			header : getCourseTxCommonTranslation('STATUS'),
			dataIndex : 'isAlreadyExist',
			flex:1,
			renderer : function(value) {
				if (value) {
					return value = getCourseTxCommonTranslation('MATERIAL_STATUS');
				} else {
					return "";
				}
			}
		}]
});
