Ext.define('Academia.view.dashboard.dashlets.AlertCountDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.alertcountdashlet',

   /* requires : ['Academia.view.dashboard.dashlets.GridDashlet',
               'Academia.model.common.AcademyLocationProgramModel' ], */

    graphView:true,
    layout:'card',
    activeItem: 0, 
    loadDashlet :function(){
		var this$=this;
		var view= this.layout.getActiveItem();
		if(view.xtype=='griddashlet' || view.xtype=='columnchartdashlet'){
			var store= view.getStore();
			var extraparams=this$.getParams();
			var userId = this$.getCurrentlyLoggedInDashletUser().id;
			/*store.load({params:extraparams,
				callback: function(rec, operation, success) {
					if(rec.length==0){
						this$.layout.setActiveItem(2);
					}
				}
			});*/
			store.getProxy().extraParams = {
				userId: userId,
				messageType: 'Alerts'
			 };
			 store.load();
		}
	},
	defaults: {
		cls:'panelNoSpace',
		xtype:'griddashlet'
    },
    
	items:[{
		fields:['id','subject','msgContent','creationTime'],
		url : SERVERURL.FIND_LATEST_ALERT_NOTIFICATION_POST,
		addPagingToolbar : true,
		 columns: [/*{    	
		           dataIndex: 'imageUrl',
		           flex: .1,
		           hidden:true
		       },*/ {    	
		       	header:getCommonTranslation('SUBJECT'), //Subject
		           dataIndex: 'subject',
		           flex: .3,        
		           renderer: function(value,metaData,record) {
		           	if(!isNullOrEmpty(value) && (!isEmpty(record.data) && !record.get("whetherRead"))){
		           		value="<b>"+value+"</b>";
		           	}            	   
		               return value;
		           }
		       }, {
		       	header:getCommonTranslation('CONTENT'), //Content
		           dataIndex: 'msgContent',
		           flex: .45,        
		           renderer: function(value,metaData,record) {
		           	//metaData.tdAttr = 'data-qtip="' + value + '"';
		           	var regex = /(<([^>]+)>)/ig;
		           	var result = value.replace(regex, "");
		           	result = result.replace("&nbsp;", " ");
		           	result = result.trim();
		           	if(result.length > 50){
		           		result = result.substring(0,50)+"...";
		           	}
		           	 
		           	if(!isNullOrEmpty(result) && (!isEmpty(record.data) && !record.get("whetherRead"))){
		           		result="<a href='#'><b>"+result+"</b></a>";
		           	}else if(!isNullOrEmpty(result) && (!isEmpty(record.data) && record.get("whetherRead"))){
		           		result="<a href='#'>"+result+"</a>";
		           	}else if(!isNullOrEmpty(result)){
		           		result="<a href='#'>"+result+"</a>";
		           	}else{
		           		result="<a href='#'>"+result+"</a>";
		           	}            	   
		               return result;
		           }
		       }, {            	
		       	header:getCommonTranslation('TIMING'), //Timing
		           dataIndex: 'creationTime',
		           flex: .15,        
		           renderer: function(value,metaData,record) {
		           	if(!isNullOrEmpty(value) && (!isEmpty(record.data) && !record.get("whetherRead"))){
		           		value="<b>"+value+"</b>";
		           	}            	   
		               return value;
		           }        
		       }],
				listeners:{
		    		cellclick: function( cell, td, cellIndex) {
		    			var alertDetailGrid = cell.up('grid');
		    			var columnName = alertDetailGrid.columnManager.columns[cellIndex].dataIndex;
		    			if(columnName == 'msgContent') {
		    				var record = alertDetailGrid.getSelectionModel().getSelection()[0];
		    			        var personController=  Academia.app.getController('Academia.controller.authentication.AuthenticationController');
					            personController.tabDashletForAlert(true,record,'Alerts');
		    			}
		    		}
				}
			}]
		});