/**
 * @author Deepak.Mathur
 */
Ext.define('Academia.view.dashboard.dashlets.BrandCampusEnrolmentSummary', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.brandcampusenrolmentsummary',
	layout:'card',
	activeItem: 0, 
	autoScroll:false,
	cls:'AdmissionALEnrolmentDashletCLS dashlet',
	loadDashlet :function(){
		var this$=this;
		var view= this.layout.getActiveItem();
		if(view.xtype=='griddashlet'){
			var store= view.getStore();
			var extraparams=this$.getParams();
			var userId = this$.getCurrentlyLoggedInDashletUser().id;
			store.getProxy().extraParams = {
				//userId: userId,
				//messageType: 'Notifications'
			};
			store.load({params:extraparams,
				callback: function(rec, operation, success) {
					if(rec.length==0){
						this$.layout.setActiveItem(0);
					}
				}
			});
		}
	},
	defaults: {
		cls:'panelNoSpace',
		//xtype:'griddashlet'
	},

	items:[{
		xtype:'griddashlet',
    	itemId:'brandCampusSummaryId',
		model:'Academia.model.enquiry.reports.BrandCampusEnrolmentDashletModel',
		url : SERVERURL.MT_FIND_ACADEMY_ENROLMENT_SUMMARY_DASHLET,
		addPagingToolbar : true,
		columns : [{
			text : getCommonTranslation('BRAND_CAMPUS'),
			dataIndex: 'academyLocationName',
			sortable : true,
			flex:0.3
		}, {
			text : getCommonTranslation('INTAKE_YEAR'),
			dataIndex : 'intakeYearCode',
			sortable : true,
			flex:0.3
		}, {
			text : getCommonTranslation('ACTUAL'),
			dataIndex : 'actual',
			sortable : true,
			flex:0.2
		},  {
			text : getCommonTranslation('TARGET'),
			dataIndex: 'enrolmentTarget',
			sortable : true,
			flex:0.2
		},  {
			text : getCommonTranslation('VARIANCE'),
			dataIndex: 'variance',
			sortable : true,
			flex:0.2
		},  {
			text : getCommonTranslation('MANNED_CAPACITY'),
			dataIndex: 'mannedCapacity',
			sortable : true,
			flex:0.2
		},  {
			text : getCommonTranslation('BUILDING_CAPACITY'),
			dataIndex: 'buildingCapacity',
			sortable : true,
			flex:0.2
		}],
		listeners:{
			activate:function(portlet){
				var brandcampusenrolmentsummary=portlet.up('brandcampusenrolmentsummary');				
				brandcampusenrolmentsummary.activeTab = 0;
				brandcampusenrolmentsummary.addForGroupByAcademyEnrolmentSummary(brandcampusenrolmentsummary,portlet);
				brandcampusenrolmentsummary.addExportToPdf(brandcampusenrolmentsummary,portlet);
				brandcampusenrolmentsummary.addExportToExcel(brandcampusenrolmentsummary,portlet);
			},
			deactivate:function(portlet){
				var brandcampusenrolmentsummary=portlet.up('brandcampusenrolmentsummary');
				brandcampusenrolmentsummary.removeGroupByAcademyEnrolmentSummary(brandcampusenrolmentsummary,portlet);
				brandcampusenrolmentsummary.removeExportToPdf();
				brandcampusenrolmentsummary.removeExportToExcel();
			}
		}
	},{
		xtype:'griddashlet',
    	itemId:'groupByAcademySummaryId',
		model:'Academia.model.enquiry.reports.BrandCampusEnrolmentDashletModel',
		url : SERVERURL.MT_FIND_GROUPBY_ACADEMY_TYPE_ENROLMENT_SUMMARY_DASHLET,
		addPagingToolbar : true,
		columns : [{
			text : getCommonTranslation('BRAND_CAMPUS'),
			dataIndex: 'academyLocationName',
			sortable : true,
			flex:0.3
		}, {
			text : getCommonTranslation('SCHOOL_TYPE'),
			dataIndex : 'academyType',
			sortable : true,
			flex:0.3
		}, {
			text : getCommonTranslation('INTAKE_YEAR'),
			dataIndex : 'intakeYearCode',
			sortable : true,
			flex:0.3
		}, {
			text : getCommonTranslation('ACTUAL'),
			dataIndex : 'actual',
			sortable : true,
			flex:0.2
		},  {
			text : getCommonTranslation('TARGET'),
			dataIndex: 'enrolmentTarget',
			sortable : true,
			flex:0.2
		},  {
			text : getCommonTranslation('VARIANCE'),
			dataIndex: 'variance',
			sortable : true,
			flex:0.2
		},  {
			text : getCommonTranslation('MANNED_CAPACITY'),
			dataIndex: 'mannedCapacity',
			sortable : true,
			flex:0.2
		},  {
			text : getCommonTranslation('BUILDING_CAPACITY'),
			dataIndex: 'buildingCapacity',
			sortable : true,
			flex:0.2
		}],
		listeners:{
			activate:function(portlet){
				var brandcampusenrolmentsummary=portlet.up('brandcampusenrolmentsummary');
				brandcampusenrolmentsummary.activeTab = 1;
				brandcampusenrolmentsummary.addForCampusEnrolmentSummary(brandcampusenrolmentsummary,portlet);
				brandcampusenrolmentsummary.addExportToPdf(brandcampusenrolmentsummary,portlet);
				brandcampusenrolmentsummary.addExportToExcel(brandcampusenrolmentsummary,portlet);
			},
			deactivate:function(portlet){
				var brandcampusenrolmentsummary=portlet.up('brandcampusenrolmentsummary');
				brandcampusenrolmentsummary.removeCampusEnrolmentSummary(brandcampusenrolmentsummary,portlet);
				brandcampusenrolmentsummary.removeExportToPdf();
				brandcampusenrolmentsummary.removeExportToExcel();
			}
		}	
	}]
});
