Ext.define('Academia.view.dashboard.dashlets.StackBarChartDashlet', {
	extend : 'Ext.chart.Chart',
	alias : 'widget.stackbarchartdashlet',
	   requires: ['Ext.chart.axis.OverlapLabelOptions'], // added for get rid of not showing  bigger length labels
	    animate: true,
	    shadow: true,
	    width: 800,
        height: 400,
	    initComponent: function() {
	        var this$ = this;
	        
	        var numberField = this.xAxesNumericField || 'number'; 
	        var categoryField = this.yAxesCategoryField || 'category';
	        var numericTitle = this.xAxesNumericTitle|| getCommonTranslation('NUMERIC_TITLE');
	        var categoryTitle = this.yAxesCategoryTitle||getCommonTranslation('CATEGOTY_TITLE');
	        var columnWidth = this.columnWidth|| REPORT_CONSTANTS.COMMON_COLUMN_WIDTH;
	        var columnColor = this.columnColor|| REPORT_CONSTANTS.COMMON_COLOR;
	        var titleLegend= this.titleLegend;
	        var chartStore = this$.buildStore();
	        Ext.apply(this$, {
	        	store: chartStore,
	        	legend: {
	                position: 'right',
	                labelFont: '10px Arial',
	                padding:10,
	            },
	            axes: [{
	                type: 'Numeric',
	                position: 'bottom',
	                //fields: [numberField],
	                title: numericTitle,
	                labelTitle: { font: 'bold 10px Arial' },
	                label: {
	                	renderer: Ext.util.Format.numberRenderer('0,0'),
	                	font: '10px Arial' 
	                },
	                grid: true,
	                minimum: 0
	            }, {
	                type: 'Category',
	                position: 'left',
	                label: {
	                	font: '10px Arial' 
	                },
	                fields: [categoryField],
	            }],
	            series: [{
	            	type: 'bar',
	                axis: 'bottom',
	                xField: categoryField,
	                yField: numberField,
	                gutter : 40,
	                label: {
	                     font: '2px Arial' 
	                },
	                stacked: true,
	                title: titleLegend,
	                tips: {
	                  trackMouse: true,
	                  width:140,
	                  height:28,
	                 // layout: 'fit',
	                  renderer: function(storeItem, item) {
	                	 // var tipTitle = storeItem.get(categoryField) + ' : ' + storeItem.get(numberField);
	                	 //var length = (tipTitle.length)* 10;
	                	  this.setWidth(5);
	                	  this.setTitle(item.value[1]);
	                  }
	                },
	            }]
	        });

	        this$.callParent(arguments);
	    },

createPostGridStore: function(columnModel, url, params,fields1,xAxesNumericField) {
    var store = Ext.create('Ext.data.Store', {
    	model : columnModel,
    	fields : fields1,
        autoDestroy: true,
        autoLoad: false,
        pageSize: CONSTANTS.DEFAULT_PAGESIZE,
        extraParams: params,
        proxy: {
    		type : 'jsonajax',
    		header: {
                contentType: 'application/json'
            },
            actionMethods: {
                read: 'POST' 
            },  
    		api : {
    			 read: url
    		},
    		reader : {
    			type : 'json',
    			root : 'rows',
    			totalProperty: 'records'
    		},
            extraParams: params
        },
        listeners:{
        	load: function(store,option,success){
        		for(var i=0; i< store.getCount(); i++){
        			var record = store.getAt(i);
        			var value='';
        			if (xAxesNumericField != undefined) {
        				for (var j = 0; j < xAxesNumericField.length - 1; j++) {
        					value = record.get(xAxesNumericField[j]);
        				}
        				value=value + record.get(xAxesNumericField[j]);
        				record.set("Category",value);
        			}
        		}
        		store.commitChanges();
        	}
        }
    });
    return store;
},

buildStore: function(xAxesCategoryField) {
    return this.createPostGridStore(this.model,this.url, this.params,this.fields,this.xAxesCategoryField );
}
});