/**
 * @author Raghavendra.Soni
 * 
 */
Ext.define('Academia.view.datagridconfiguration.ConfigureDatagridStructure', {
	extend: 'Ext.panel.Panel',
	alias: 'widget.configuredatagridstructure',
	autoScroll: true,
	bodyStyle: {
		overflow: 'auto !important'
	},
	bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL} ,
	cls:'horizontalScrollingFixed' ,
	items: [{
		xtype:'panel',
		style:{
			marginTop:'-2px !Important;'
		},
		items: [{
			xtype: 'form',
			autoScroll: true,
			frame: false,
			cls:'customSearchPanel',
			layout: 'vbox',
			method: 'POST',
			standardSubmit: false,
			plugins:"formlabelrequired",
			items: [{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					width: 226,
					labelAlign: 'top'
				},
				items: [{
					xtype: 'customcombobox',
					name: 'gridNameCombo',
					itemId:'gridNameComboItemId',
					store:new Ext.data.ArrayStore({
						id: 0,
						fields: [ 
							'id',
							'name'
							],
							data: [
								['Academia.view.campaignnew.CampaignNewGrid','Manage Campaign Grid'],
								['UserList', "User List"],
								['TRACK_ENQUIRY_ADMISSION','Manage Enquiry for Admission'],
								['CORPORATE_ENQUIRY_LIST','Manage Enquiry for Corporate'],
								['TRACK_ENQUIRY_NON_ADMISSION','Manage Enquiry for Others'],
								['STUDENT_LIST','Students List'],
								['Academia.view.sgappointment.sgappointment.SGAppointmentDetailGrid',getCommonTranslation('ENQUIRY_APPOINTMENT')],
								['Academia.view.feeandpayment.ProjectedBillingReportGrid',getFeeAndPaymentCommonTranslation('PROJECTED_BILLING')],
								['Academia.view.feeandpayment.ProjectedDiscountReportGrid',getFeeAndPaymentCommonTranslation('PROJECTED_DISCOUNT_REPORT')],
								['Academia.view.feeandpayment.reports.FeeHeadWiseCollectionReportGrid', getFeeAndPaymentCommonTranslation('FEE_HEAD_WISE_REPORT')],
								['Academia.view.examinationcenters.marksheet.student.StudentMarksheetGrid',getExaminationTranslation('STUDENTS_MARKSHEETS_LIST')],
								['Academia.view.examinationcenters.reports.PendingMarksRemarksResultGrid',getExaminationTranslation('PENDING_MARK_ENTRY')],
								['Academia.view.examinationcenters.reports.PendingRemarksResultGrid',getExaminationTranslation('PENDING_REMARKS_ENTRY')],
								['Academia.view.examinationcenters.reports.GradeRosterReportGrid',getExaminationTranslation('GRADE_ROSTER_REPORT_LIST')],
								['Academia.view.examinationcenters.generatehallticket.GenerateHallTicketGrid',getExaminationTranslation('HALL_TICKETS')],
								['Academia.view.examinationcenters.reports.MarksheetReportGrid',getExaminationTranslation('MARKSHEET_REPORT')],
								['Academia.view.examinationcenters.remark.EvaluationRemarkGrid',getExaminationTranslation('MANAGE_EVALUATION_REMARK_LIST')],
								['Academia.view.examinationcenters.remark.ClassTeacherRemarkGrid',getExaminationTranslation('CLASS_TEACHER_REMARK_LIST')],
								['Academia.view.coursetransaction.promotion.PromotionList',getCommonTranslation('PROMOTION_LIST')],
								['ProgramList', "Program List"],
								['COURSE_LIST', "Course List"],
								['Academia.view.dashboard.dashlets.GridDashlet',getCommonTranslation('COURSE_DASHLET_NO_OF_STUDENT')],
								['Academia.view.attendance.StudentAttendanceGrid',getCommonTranslation('STUDENT_ATTENDANCE_LIST')],
								['Academia.view.coursetransaction.sectioncoursecoverageplan.ExtendedTimeTablePBSGrid',getCommonTranslation('Extended_TT_PBS_LIST')],
								['Academia.view.coursetransaction.sectioncoursecoverageplan.ExtendedTimeTableCBSGrid',getCommonTranslation('Extended_TT_CBS_LIST')],
								['Academia.view.programCourseDashboard.CourseRosterReportGrid',getExaminationTranslation('COURSE_ROSTER_REPORT')],
								['Academia.view.programCourseDashboard.SectionRosterReportGrid' ,getExaminationTranslation('SECTION_ROSTER_REPORT')],
								['Academia.view.coursetransaction.studentcourseenrollment.studentcourseregistrationrevamp.ProgramBatchCourseDetailResultStatusGrid' ,getCourseTxCommonTranslation('STUDENT_ENROLLMENT_LIST')],
								['Academia.view.feeandpayment.reports.StudentOutstandingReportGrid', getCommonTranslation('STUDENT_OUTSTANDING_REPORT')],
								['Academia.view.feeandpayment.reports.StudentFeeReportGrid', getCommonTranslation('STUDENT_FEE_REPORT')],
								['Academia.view.feeandpayment.reports.StudentCollectionReportGrid', getCommonTranslation('STUDENT_COLLECTION_REPORT')],
								['Academia.view.feeandpayment.reports.StudentDiscountReportGrid', getCommonTranslation('STUDENT_DISCOUNT_REPORT')],
								['Academia.view.feeandpayment.ActualAccountStatementGrid',getCommonTranslation('LIST_OF_STUDENT')],
								['Academia.view.feeandpayment.ActualApplicantAccountStatementGrid', getCommonTranslation('LIST_OF_APPLICANTS')],
								['Academia.view.feeandpayment.ActualSponsorAccountStatementGrid', getCommonTranslation('LIST_OF_SPONSORS')],
								['FACULTY_LIST', "Employee List"],
								['Academia.view.examinationcenters.reports.faculty.PendingFacultyMarksGrid',getExaminationTranslation('PENDING_MARK_ENTRY')],
								['Academia.view.admission.manageForm.ManageFormList',getCommonTranslation('MANAGE_FORMS')],
								['Academia.view.enquiry.admission.AdmissionReqmntDetailGrid',getCommonTranslation('ENQ_ADMISSION_DETAILS')],
								['Academia.view.enquiry.EnquiryGrid' ,getCommonTranslation('ENQUIRY_STUDENT_DETAILS_GRID')],
								['APPLICATION_LIST','Applications Grid'],
								['Academia.view.enquiry.followup.FollowUpDetailGrid',getCommonTranslation('ENQUIRY_FOLLOW_UP_GRID')],
								['Academia.view.admission.applicantFormSaleDirectSubmission.AddProgramGrid',getCommonTranslation('APPLICATION_PROGRAM_DETAILS')],
								['Academia.view.admission.applicationFormSale.AddProgramTabGrid',getCommonTranslation('APPLICATION_DETAILS')],
								['Academia.view.feeandpayment.ActualApplicantAccountStatementGrid', getCommonTranslation('LIST_OF_APPLICANTS')],
								['FACULTY_LIST', "Employee List"],
								['Academia.view.feeandpayment.ActualSponsorAccountStatementGrid', getCommonTranslation('LIST_OF_SPONSORS')],
								['Academia.view.feeandpayment.reports.ApplicantFeeHeadWiseCollectionReportGrid',getFeeAndPaymentCommonTranslation('APPLICANT_FEE_HEAD_WISE_COLLECTION_REPORT')],
								['Academia.view.feeandpayment.reports.ApplicantOutstandingReportGrid', getCommonTranslation('APPLICANT_OUTSTANDING_REPORT')],
								['Academia.view.feeandpayment.reports.ApplicantDiscountReportGrid', getCommonTranslation('APPLICANT_DISCOUNT_REPORT')],	
								['Academia.view.transport.vehicle.VehicleList', getTransportTranslation('VEHICLE_LIST')],
								['Academia.view.transport.serviceRoute.ServiceRouteMasterGrid', getTransportTranslation('SERVICE_ROUTE_LIST')],
								['Academia.view.feeandpayment.reports.ApplicantFeeReportCollectionGrid', getCommonTranslation('APPLICANT_COLLECTION_REPORT')],
								['Academia.view.feeandpayment.reports.ApplicantFeeReportGrid', getCommonTranslation('APPLICANT_CONSOLIDATED_FEE_REPORT')],
								['Academia.view.feeandpayment.reports.UserWiseCollectionReportGrid', getCommonTranslation('USER_WISE_COLLECTION_REPORT')],
								['Academia.view.feeandpayment.reports.ProgramWiseFeeReportGrid', getCommonTranslation('PROGRAM_WISE_CONSOLIDATED_FEE_REPORT')],
								['Academia.view.feeandpayment.reports.feeRuleAssociationReportGrid', getCommonTranslation('FEE_RULE_ASSOCIATION_REPORT')],
								['Academia.view.feeandpayment.AdvanceFeeReportGrid', getCommonTranslation('LIST_OF_ADVANCE')],
								['Academia.view.feeandpayment.reports.DependentFeeCollectionReportGrid', getFeeAndPaymentCommonTranslation('DEPENDENT_FEE_COLLECTION_DETAILS')],
								['Academia.view.feeandpayment.reports.InstruemntDetailReportGrid', getFeeAndPaymentCommonTranslation('INSTRUMENT_DETAIL_REPORT')],
								['Academia.view.feeandpayment.reports.ReceiptWithHeadReportGrid', getFeeAndPaymentCommonTranslation('RECEIPTS_WITH_HEAD_DETAILS')],
								['Academia.view.examinationcenters.examresultpublish.ExamResultPublishGrid', getCommonTranslation('EXAMINATION_RESULT_PUBLISH')],
								['Academia.view.examinationcenters.calculateAverage.ExamResultDeletionGrid',getExaminationTranslation('EXAM_RESULT_DELETION_NEW')],
								['Academia.view.examinationcenters.calculateAverage.CalculateAverageGrid',getCommonTranslation('CALCULATE_AVERAGE_TITLE')],
								['Academia.view.examinationcenters.revaluation.RevaluationCoreErpStudentGrid',getCommonTranslation('APPLY_FOR_REVALUATION')],
								['Academia.view.examinationcenters.examstaffallocation.StaffAllocatonGrid',getCommonTranslation('EXAMINATION_STAFF_ALLOC')],
								['Academia.view.examinationcenters.evalution.EvaluationPlanGrid',getCommonTranslation('EVAL_PLAN_LIST')],
								['Academia.view.personinfo.common.pasthistory.EducationHistoryGrid' ,getCommonTranslation('EDUCATION_HISTORY')],
								['Academia.view.student.studentprofile.StudentAcademicsHistoryGrid',getPersonModuleTranslation('ACADEMIC_HISTORY')],
								['Academia.view.feeandpayment.reports.DependentFeeCollectionReportGrid', getFeeAndPaymentCommonTranslation('DEPENDENT_FEE_COLLECTION_DETAILS')],
								['Academia.view.feeandpayment.reports.InstruemntDetailReportGrid', getFeeAndPaymentCommonTranslation('INSTRUMENT_DETAIL_REPORT')],
								['Academia.view.feeandpayment.reports.ReceiptWithHeadReportGrid', getFeeAndPaymentCommonTranslation('RECEIPTS_WITH_HEAD_DETAILS')],
								['Academia.view.feeandpayment.discounts.ManageDiscountApplicantList', getCommonTranslation('MANAGE_DISCOUNT_APPLICANT')],
								['Academia.view.feeandpayment.discounts.DiscountList', getCommonTranslation('DISCOUNTS')],
								['Academia.view.feeandpayment.discounts.ManageDiscountStudentList', getFeeAndPaymentCommonTranslation('MANAGE_DISCOUNT_LIST')],
								['Academia.view.feeandpayment.payment.PaymentListForPCAndServiceProvidedForApplicant',getCommonTranslation('PAYMENT_LIST_PC_SERVICEPROVIDED_FOR_APPLICANT')],
								['Academia.view.feeandpayment.payment.PaymentListForPCAndServiceProvided',getCommonTranslation('PAYMENT_LIST_FOR_PC_AND_SERVICEPROVIDED')],
								['Academia.view.feeandpayment.payment.PaymentListForPCAndServiceProvidedForSponsor',getCommonTranslation('PAYMENT_LIST_FOR_SPONSOR')],
								['Academia.view.feeandpayment.payment.PaymentListForScholarship',getCommonTranslation('PAYMENT_LIST_FOR_SCHOLARSHIP')],
								['Academia.view.feeandpayment.receipts.ReceiptHeaderListForUser',getCommonTranslation('LIST_RECEIPT_FOR_USER')],
								['Academia.view.feeandpayment.receipts.ReceiptHeaderListForSponsor',getCommonTranslation('LIST_RECEIPT_FOR_SPONSOR')],
								['Academia.view.feeandpayment.receipts.ReceiptHeaderList',getCommonTranslation('LIST_RECEIPT_FOR_STUDENT')],
								['Academia.view.feeandpayment.receipts.ReceiptHeaderListForApplicant',getCommonTranslation('LIST_RECEIPT_FOR_APPLICANT')],
								['Academia.view.feeandpayment.receipts.ReceiptHeaderListForScholarship',getCommonTranslation('LIST_RECEIPT_FOR_SCHOLARSHIP')],
								['Academia.view.feeandpayment.payment.FeeOfflinePaymentDetailMainGrid',getCommonTranslation('OFFFLINE_PAYMENT_PROOF_DETAIL')],
								['Academia.view.feeandpayment.discounts.AddDiscountStudentSibilingGrid', getFeeAndPaymentCommonTranslation('SIBLING_DISCOUNT')],
								['Academia.view.feeandpayment.discounts.AddDiscountStudentParentGrid', getFeeAndPaymentCommonTranslation('PARENTS_GUARDIAN_LIST')],
								['Academia.view.feeandpayment.payment.PaymentListForServiceProvided', getCommonTranslation('PAYMENT_LIST_FOR_SERVICE_PROVIDED')],
								['Academia.view.feeandpayment.payment.PaymentListForServiceReceived',getCommonTranslation('PAYMENT_LIST_FOR_SERVICE_RECEIVED')],
								['Academia.view.feeandpayment.discounts.AddDiscountStudentParentGrid', getFeeAndPaymentCommonTranslation('PARENTS_GUARDIAN_LIST')],
								['INFIRMARY_MANAGE_ENTRIES_COUNSELLOR_DETAIL', "Manage Intervention"],
								['Academia.view.sgappointment.sgappointment.SGAppointmentGrid',getServiceRequestTranslation('SG_LIST_OF_APPOINTMENTS')],
								['Academia.view.securitygatemanagement.SgManageVisitorGrid',getServiceRequestTranslation('LIST_OF_VISITOR')],
								['Academia.view.fdmanagement.FDManagementGrid',getServiceRequestTranslation('FD_INWARD_REGISTER'),],
								['Academia.view.fdmanagement.FDManagementOutwardGrid',getServiceRequestTranslation('FD_OUTWARD_REGISTER')],
								['Academia.view.admission.applications.applicantProfileBase.SelectionSnapshotGrid' ,getCommonTranslation('SELECTION_SNAPSHOT_GRID')],
								['Academia.view.hostel.hostelapplication.HostelApplicationList' ,getHostelTranslation('HOSTEL_APPLICATIONS')],
								['Academia.view.examinationcenters.evaluationgrouplisting.EvalGroupListingMasterGrid',getCommonTranslation('LIST_OF_APPLY_FOR_EVALUATION_GROUP')],
								['Academia.view.examinationcenters.roomallocation.RoomAllocationGrid', getCommonTranslation('ROOMALLOCATION_LIST')],
								['Academia.view.examinationcenters.averagereport.StudentAverageReportGrid',getExaminationTranslation('LIST_OF_STUDENTS')],
								['Academia.view.hrRecruitmentProcess.jobPosting.JobPostingGrid', getCommonTranslation('JOB_POSTING')],
								['Academia.view.admission.applicationFormSale.ChangeProgramGrid',getAdmissionTranslation('CHANGE_APPLICATION_PROGRAM')],
								['Academia.view.feeandpayment.adjustment.ReceiptsList', getCommonTranslation('SETTLEMENT_RECEIPT_LIST')],
								['Academia.view.feeandpayment.adjustment.InstumentDetailsList', getCommonTranslation('SETTLEMENT_PAYMENT_DETAILS_LIST')],
								['Academia.view.feeandpayment.adjustment.Allbillslist', getCommonTranslation('SETTLEMENT_INVOICE_LIST')],
								['Academia.view.feeandpayment.adjustment.BillReceivableList', getCommonTranslation('SETTLEMENT_FEE_HEAD_INVOICE_LIST')],
								['Academia.view.feeandpayment.managebill.BillHeaderThirdPartyGrid', getCommonTranslation('LISTOFINVOICES_AND_CREDITNOTES_FOR_THIRDPARTY')],
								['Academia.view.feeandpayment.managebill.BillHeaderPCGrid', getCommonTranslation('LISTOFINVOICES_AND_CREDITNOTES_P&C')],
								['Academia.view.feeandpayment.managebill.BillHeaderScholarshipGrid', getCommonTranslation('LISTOFINVOICES_AND_CREDITNOTES_SCHOLARSHIP')],
								['Academia.view.feeandpayment.managebill.BillHeaderGridForSponsor', getCommonTranslation('LISTOFINVOICES_AND_CREDITNOTES_FOR_SPONSOR')],
								['Academia.view.feeandpayment.managebill.LateFeeForStudentGrid', getCommonTranslation('LISTOFINVOICES_AND_CREDITNOTES_LATEFEEFORSTUDENT')],
								['BILL_FEE_PLAN_PC_LISTING', "BILL FEE PLAN PC LISTING"],
								['Academia.view.feeandpayment.managebill.BillHeaderServiceReceivedGrid', getCommonTranslation('LISTOFINVOICES_AND_CREDITNOTES_SERVICERECEIVED')],
								['Academia.view.feeandpayment.managebill.BillHeaderUserGrid', getCommonTranslation('LISTOFINVOICES_AND_CREDITNOTES_FOR_User')],
								['Academia.view.feeandpayment.controlAccount.ControlAccountList', getCommonTranslation('CONTROL_ACCOUNTS')],
								['Academia.view.feeandpayment.accountingConfigurationMapping.AccountingConfigurationMappingList', getCommonTranslation('CONFIGURATION_MAPPING')],
								['Academia.view.feeandpayment.managebill.BillHeaderApplicantGrid', getCommonTranslation('LISTOFINVOICES_AND_CREDITNOTES_FORAPPLICANT')],
								['Academia.view.feeandpayment.managebill.LateFeeForApplicantGrid', getCommonTranslation('LISTOFINVOICES_AND_CREDITNOTES_FORLATEFEEAPPLICANT')],
								['Academia.view.feeandpayment.accountingConfiguration.AccountingConfigurationList', getCommonTranslation('ACCOUNTING_CONFIGURATION')],
								['Academia.view.feeandpayment.payment.FeeOfflinePaymentDeatilForApplicantGrid', getCommonTranslation('OFFFLINE_PAYMENT_PROOF_DETAIL_FOR_APPLICANT')],						
								['Academia.view.feeandpayment.voucherMode.VoucherModeList', getCommonTranslation('LIST_OF_VOUCHER')],
								['Academia.view.feeandpayment.voucherMode.VoucherModeInnerList', getCommonTranslation('VOUCHER_MODE_DETAIL')],
								['Academia.view.feeandpayment.ManagePaymentPlanList', getCommonTranslation('LIST_PAYMENT_PLAN')],
								['Academia.view.feeandpayment.reports.VoucherSummaryReportGrid', getCommonTranslation('VOUCHER_SUMMARY')],
								['Academia.view.feeandpayment.ManageFeeList', getCommonTranslation('LIST_OF_MANAGE_FEE_PLAN')],
								['Academia.view.feeandpayment.finance.ManageFinanceHoldGrid', getCommonTranslation('LIST_OF_FINANCIAL_HOLD_TYPE')],
								['Academia.view.course.readingmaterial.readingmaterialinformation.ReadingMaterialGrid',getCommonTranslation('LIST_OF_COURSE_READING_MATERIAL')],
								['Academia.view.programCourseDashboard.ProgramPromotionGrid' , getProgramandcourseTranslation('PROMOTION_LIST')],
								['Academia.view.feeandpayment.ProjectedSponsorReportGrid', getCommonTranslation('SPONSORSHIP_PROJECTED_BILLS')],
								['Academia.view.attendance.attendancereport.AttendanceReportGrid' , getCommonTranslation('STUDENT_ATTENDANCE_SUMMARY_PROGRAM')],
								['Academia.view.attendance.attendancereport.AttendanceReportGridConsolidated', getCommonTranslation('STUDENT_ATTENDANCE_SUMMARY_COURSE')],
								['Academia.view.coursesessiondiary.CourseSessionDiaryGrid', getCommonTranslation('COURSE_SESSION_DAIRY')],
								['Academia.view.coursetransaction.sectionmanagement.ManageCourseSectionDetailedViewGrid', getCommonTranslation('COURSE_SECTION_LIST')],
								['Academia.view.attendance.pendingattendance.PendingAttendanceGrid', getCommonTranslation('PENDING_ATTENDANCE_REPORT_PROGRAM_WSE')],
								['Academia.view.attendance.pendingattendance.PendingAttendanceCourseWiseGrid', getCommonTranslation('PENDING_ATTENDANCE_COURSE_WISE')],
								['Academia.view.attendance.pendingattendance.PendingAttendanceCourseWiseReportGrid', getCommonTranslation('PENDING_ATTENDANCE_COURSE_REPORT')],
								['Academia.view.attendance.ConsolidateAttendanceCourseWiseGrid', getCommonTranslation('DAILY_ATTENDANCE_COURSE_REPORT')],
								['Academia.view.attendance.AttendanceForComplateDayList', getCommonTranslation('STUDENT_ATTENDANCE_REPORT')],
								['Academia.view.attendance.AttendanceForCourseLevelList', getCommonTranslation('STUDENT_ATTENDANCE')],
								['RPT_STUDENT_COMMUNITY_REPORT', getCommonTranslation('STUDENT_COMMUNITYREPORT')],
								['Academia.view.personinfo.common.paymentandrefund.HeadWiseBillsGrid', getPersonModuleTranslation('HEAD_WISE_BILLS')],
								['Academia.view.personinfo.common.disciplinaryactivity.DisciplinaryActionSUGrid', getPersonModuleTranslation('SP_DISCIPLINARY_ACTIONS_SU')],
								['Academia.view.student.studentFeePayerReport.StudentFeePayerReportGrid', getPersonModuleTranslation('STUDENT_FEE_PAYER_DETAILS')],
								['Academia.view.examcancellation.ExamCancellationGrid', getCommonTranslation('LIST_OF_EXAM_CANCELLATION')],
								['Academia.view.examcancellation.ExamCancellationRequestGrid',getCommonTranslation('EXAM_CANCELLATION_REQUEST_LIST')],
								['Academia.view.program.programDetails.programBatchDetails.periods.ProgramPeriodsGrid', getCommonTranslation('PERIODS_GRID')],
								['Academia.view.personinfo.common.course.StudentCourseReportByPeriodGrid', getExaminationTranslation('STUDENT_PERIOD_REPORT')],
								['Academia.view.attendance.ConsolidateAttendanceGrid', getProgramandcourseTranslation('DAILY_ATTENDANCE_SUMMARY')],
								['Academia.view.feeandpayment.reports.paymentPlanReportGrid', getCommonTranslation('PAYMENT_PLAN_REPORT')],
								['Academia.view.examinationcenters.reports.AnonymousReportGrid',getExaminationTranslation('LIST_OF_STUDENT')],
								['Academia.view.reports.programcourse.creditbasedreport.CreditBasedGrid',getProgramandcourseTranslation('CREDIT_EARNED_RESULT')],
								['Academia.view.setup.campaignmaster.ManageSchoolGrid', getCommonTranslation('MANAGE_SCHOOL')],
								['Academia.view.examinationcenters.thesisManagement.ThesisManagementGrid', getCommonTranslation('THESIS_MANAGEMENT_LIST')],
								['Academia.view.examinationcenters.thesisManagement.StudentThesisManagementGrid', getCommonTranslation('STUDENT_THESIS_MANAGEMENT_LIST')],
								['Academia.view.admission.applications.applicantProfileBase.AdmissionGrid', getCommonTranslation('APPROVE_WITHDRAW_REJECT_ADMISSION')],
								['Academia.view.admission.applications.admissionAndMidTermAdmission.AdmissionProgramGrid', getAdmissionTranslation('ADMISSION_DETAILS')],
								['Academia.view.admission.applicationFormSale.AddProgramWindowGrid', getCommonTranslation('ADD_PROGRAM_GRID')],
								['ADMISSION_SELECTION_STAGE', 'Admission Selection Stage'],
								['Academia.view.examinationcenters.thesisManagement.FacultyThesisManagementGrid', getCommonTranslation('FACULTY_THESIS_MANAGEMENT_LIST')],
								['Academia.view.programCourseDashboard.CourseDetailReportGrid', getCommonTranslation('SEARCHRESULTSGRIDHEADER')],
								['Academia.view.personinfo.common.NSFAS.BursaryFunddingDetails',  getCommonTranslation('FUNDDING_DETAILS')],
								['Academia.view.personinfo.common.NSFAS.BursaryApplicationStatus', getCommonTranslation('BURSARY_APPLICATION_STATUS')],
								['Academia.view.personinfo.common.NSFAS.BursaryApplicationDetails', getCommonTranslation('BURSARY_APPLICATION_DETAILS')],
								['Academia.view.personinfo.common.paymentandrefund.PaymentReceivedHistoryGrid', getCommonTranslation('RECEIPTS')],
								['Academia.view.personinfo.common.paymentandrefund.ReceiptGridForApplicant', getCommonTranslation('APPLICANT_RECEIPTS')],
								['Academia.view.programCourseDashboard.DailyLogOrSessionReportGrid', getCommonTranslation('DAILY_SESSION_REPORT')],
								['Academia.view.programCourseDashboard.StudentCourseEnrollmentReportGrid', getCommonTranslation('STUDENT_COURSE_ENROLLMENT_REPORT')],
								['CR_COURSE_VARIANTS_ASSOCIATED', "Course Variants Associated"],
								['Academia.view.personinfo.common.pasthistory.PatentDetailsGrid', getPersonModuleTranslation('PATENT_DETAILS')],
								['Academia.view.personinfo.student.StudentHoldReportGrid', getCommonTranslation('MANAGE_REPORT_HOLD_GRID')],
								['Academia.view.campaign.dashboard.SignUpReportGrid',getCommonTranslation('SIGNUP_REPORT_GRID')],
								['Academia.view.student.medicalDetailsReport.StudentMedicalDetailsReportGrid', getCommonTranslation('STUDENT_MEDICAL_DETAILS_REPORT')],
								['Academia.view.student.studentprofile.AcademicsTopicQuickSearchGrid', getPersonModuleTranslation('ACADEMICS_TOPIC')],
								['Academia.view.personinfo.student.StudentForAcademicToicsGrid', getPersonModuleTranslation('PARENTS_ACADEMICS_TOPIC')],
								['Academia.view.feeandpayment.coursefeedefinition.CourseFeeDefinitionSeachGrid', getFeeAndPaymentCommonTranslation('COURSE_FEE_DEFINITION_LIST')],
								['Academia.view.feeandpayment.creditfeemapping.CreditFeeMappingGrid', getCommonTranslation('LIST_OF_PROGRAM')],
								['Academia.view.hostel.manageallocation.manageallocationuserwise.ManageUserWiseList', getHostelTranslation('LIST_OF_ROOMS')],
								['Academia.view.hostel.hostelapplication.HostelApplicationApplicantListGrid', getCommonTranslation('RESIDENCE_APPLICATIONS_APPLICANT')],
								['Academia.view.programCourseDashboard.StudentCourseSectionReportGrid', getCommonTranslation('LIST_OF_COURSE_SECTION')],
								['Academia.view.personinfo.common.pasthistory.VaccinationGrid', getPersonModuleTranslation('VACCINATION_DETAILS')],
								['Academia.view.student.studentLeaversReport.StudentLeaversReportGrid', getCommonTranslation('STUDENT_LEAVERS_REPORT')],
								['Academia.view.student.report.StudentALTransferReportGrid', getCommonTranslation('STUDENTTRANSFERREPORT')],
								['Academia.view.personinfo.common.disciplinaryactivity.PositiveIncidentGrid', getPersonModuleTranslation('POSITIVE_INCIDENT')],
								['Academia.view.personinfo.common.disciplinaryactivity.NegativeIncidentGrid', getPersonModuleTranslation('NEGATIVE_INCIDENT')],
								['Academia.view.personinfo.common.disciplinaryactivity.DisciplinaryActionGrid', getPersonModuleTranslation('DISCIPLINARY_ACTION')],
								['Academia.view.feeandpayment.addsequence.AddSequenceList', getCommonTranslation('FEE_PLAN_RULE_GRID')],
								['Academia.view.coursetransaction.manageperiodenrollment.ManageStudentEnrollmentList', getCommonTranslation('LIST_OF_PROGRAMS_PERIOD')],
								['Academia.view.coursetransaction.manageperiodenrollment.ManagePeriodEnrollmentList', getCommonTranslation('LIST_OF_ENROLLED_STUDENT')],
								['Academia.view.coursetransaction.studentcourseenrollment.studentenrollmentdetail.StudentPortalEnrollmentDetailGrid', getProgramandcourseTranslation('STUDENT_COURSE_REGISTRATION') + "- Student Portal"],
								['Academia.view.coursetransaction.studentcourseenrollment.studentenrollmentdetail.CoreErpStudentEnrollmentDetailGrid', getProgramandcourseTranslation('STUDENT_COURSE_REGISTRATION') + "- Core ERP"],
								['Academia.view.coursetransaction.studentperiodenrollment.StudentPeriodEnrollmentList', getCommonTranslation('LIST_OF_PROGRAMS_PERIOD')+ "- Student Parent Portal"],
								['Academia.view.personinfo.common.documents.DocumentGrid', getPersonModuleTranslation('LIST_OF_DOCUMENTS')],
								['Academia.view.hostel.reports.hosteldetailreport.HostelDetailsReportGrid',getHostelTranslation('HOSTEL_DETAILS_REPORT')],
								['Academia.view.feeandpayment.ViewActualAccountStatementGrid',getFeeAndPaymentCommonTranslation('ACCOUNT_STATEMENT')],
								['Academia.view.setup.dashboard.LicenseDetailsReportGrid',getCommonTranslation('LICENSE_DETAILS')],
								['Academia.view.student.studentprofile.AcademicsHistoryGridForMarkTypeCourse',getCommonTranslation('ACADEMIC_HISTORY_FOR_MARK_TYPE')],
								['Academia.view.sponsorship.SponsorshipAwardeesGrid',getCommonTranslation('SPONSORSHIP_AWARDEES_LIST')],
								['Academia.view.sponsorship.SponsorshipReceiptGrid',getCommonTranslation('SPONSOR_SHIP_RECEIPT_GRID')],
								['Academia.view.sponsorship.SponsorshipBillingGrid',getCommonTranslation('SPONSORSHIP_BILLING_REPORT')],
								['Academia.view.feeandpayment.ViewActualAccountStatementGrid',getFeeAndPaymentCommonTranslation('ACCOUNT_STATEMENT')],
								['Academia.view.admission.applicationFollowUpReport.ApplicationFollowUpDashboardGrid',getCommonTranslation('ADM_APPLICATION_FOLLOWUP_DASHBOARD')],
								['Academia.view.personinfo.common.paymentandrefund.PendingBillsGridForStudentPortal',getPersonModuleTranslation('BILLS')],
								['Academia.view.personinfo.common.paymentandrefund.CreditNoteGridForStudentPortal',getCommonTranslation('BILL_PAYABLE')],
								['Academia.view.examinationcenters.reports.StudentLevelRemarkReportGrid',getCommonTranslation('STUDENT_LEVEL_REMARK_REPORT')],
								['Academia.view.examinationcenters.reports.ExaminationResultReportGrid',getExaminationTranslation('EXAMINATION_RESULTS_REPORT')],
								['Academia.view.facultyPortal.attendance.CaptureAttendanceInnerGrid',getCommonTranslation('CAPTURE_ATTENDANCE_GRID')],
								['Academia.view.coursetransaction.sectionmanagement.ProgramBatchSectionStudentGrid',getCommonTranslation('PROGRAM_BATCH_SECTION_STUDENT_GRID')],
								['Academia.view.feeandpayment.creditfeemapping.CreditFeeMappingRegularTabGrid',getCommonTranslation('LIST_OF_QUALIFICATION_FOR_REGULAR_AND_BACKLOG_COURSES')],
								['Academia.view.feeandpayment.creditfeemapping.creditfeemappingrepeattabgrid',getCommonTranslation('LIST_OF_QUALIFICATION_FOR_REPEAT_COURSES')],
								['Academia.view.examinationcenters.reports.PeriodWiseExamLevelReportGrid',getExaminationTranslation('PERIOD_LEVEL_REPORT')], 
								['Academia.view.examinationcenters.questionPaperBank.questionPaperBankGrid',getExaminationTranslation('LIST_QUESTION_PAPERS')],  
								['Academia.view.facultyPortal.attendance.CaptureAttendanceGrid',getCommonTranslation('CAPTURE_ATTENDANCE_GRID')],
								['Academia.view.coursetransaction.sectionmanagement.ProgramBatchSectionStudentGrid',getCommonTranslation('PROGRAM_BATCH_SECTION_STUDENT_GRID')],
								['Academia.view.program.programDetails.programBatchDetails.courseParameters.AddFacultyGrid',getProgramandcourseTranslation('ADD_FACULTY')],
								['Academia.view.feeandpayment.payment.ManageDebitOrdersGrid',getFeeAndPaymentCommonTranslation('FP_MANAGE_DEBIT_ORDERS')],
								['Academia.view.studentPortal.revaluation.RevaluationStudentGrid', getExaminationTranslation('APPLY_FOR_REVALUATION_FOR_STUDENT')],
								['Academia.view.program.lessonplanning.LessonPlanningGrid',getProgramandcourseTranslation('LESSON_PLANNING')],
								['Academia.view.personinfo.common.personalinfo.PassportDetailGrid', getPersonModuleTranslation('STUDENT_PASSPORT_DETAILS')],
								['Academia.view.personinfo.common.personalinfo.ApplicantPassportGrid', getPersonModuleTranslation('APPLICANT_PASSPORT_DETAILS')],
								['Academia.view.personinfo.common.personalinfo.VisaDetailGrid', getPersonModuleTranslation('VISA_DETAILS')],
	                    	['Academia.view.scholarship.scholarshiplisting.ListOfOnlineDocumentsCerpGrid',getCommonTranslation('LIST_OF_ONLINE_DOCUMENTS')],
	                    	['Academia.view.personinfo.common.personalinfo.StudentJourneyGrid', getPersonModuleTranslation('STUDENT_JOURNEY') + "- Student Portal"],
	                    ['Academia.view.personinfo.common.personalinfo.StudentJourneyCoreERPGrid', getPersonModuleTranslation('STUDENT_JOURNEY') + "- Core ERP"],
    			        ['Academia.view.personinfo.common.personalinfo.PassportDetailGrid', getPersonModuleTranslation('STUDENT_PASSPORT_DETAILS')],
    			        ['Academia.view.personinfo.common.personalinfo.ApplicantPassportGrid', getPersonModuleTranslation('APPLICANT_PASSPORT_DETAILS')],
    			        ['Academia.view.personinfo.common.personalinfo.VisaDetailGrid', getCommonTranslation('STUDENT_VISA_DETAILS')],
    			        ['Academia.view.personinfo.common.personalinfo.ApplicantVisaGrid', getCommonTranslation('APPLICANT_VISA_DETAILS')],
    			        ['Academia.view.personinfo.common.pasthistory.StudentEducationHistoryDetailGrid', getCommonTranslation('STUDENT_EDUCATION_DETAILS')],
    			        ['Academia.view.personinfo.common.personalinfo.PermitDetailGrid', getCommonTranslation('STUDENT_PERMIT')],
    			        ['Academia.view.personinfo.common.pasthistory.HealthInformationDetailGrid', getCommonTranslation('STUDENT_HEALTH_INFORMATION')],
    			        ['Academia.view.personinfo.common.pasthistory.StudentLanguageInformationGrid', getCommonTranslation('STUDENT_LANGUAGE_INFORMATION')],
    			        ['Academia.view.personinfo.common.pasthistory.ApplicantLanguageInformationGrid', getCommonTranslation('APPLICANT_LANGUAGE_INFORMATION')],
    			        ['Academia.view.personinfo.common.personalinfo.ApplicantEducationDetailsGrid', getCommonTranslation('APPLICANT_EDUCATION_DETAILS')],
    			        ['Academia.view.personinfo.common.personalinfo.ApplicantPermitDetailGrid', getCommonTranslation('APPLICANT_PERMIT')],
    			        ['Academia.view.personinfo.common.personalinfo.ApplicantInsuranceDetailsGrid', getCommonTranslation('APPLICANT_INSURANCE')],
    			        ['Academia.view.personinfo.common.personalinfo.StudentInsuranceDetailsGrid', getCommonTranslation('STUDENT_INSURANCE')],
    			        ['Academia.view.personinfo.common.pasthistory.ApplicantHealthInformationGrid', getCommonTranslation('APPLICANT_HEALTH_INFORMATION')],
    			        ['Academia.view.personinfo.common.course.StudentCourseReportGrid', getCommonTranslation('COURSES') + '(Student Profile)'],
    			        ['Academia.view.scholarship.scholarshipmaster.ScholarshipRequestListGridStudent',getCommonTranslation('LIST_OF_STUDENT_SCHOLARSHIP_REQUEST')],
	                    ['Academia.view.scholarship.scholarshipmaster.ScholarshipRequestListGridApplicant',getCommonTranslation('LIST_OF_APPLICANT_SCHOLARSHIP_REQUEST')],
	                    ['Academia.view.personinfo.common.services.HostelApplicationDetailsView',getHostelTranslation('HOSTEL_APPLICATIONS')],
	                    ['Academia.view.hostel.hostelapplication.HostelApplicationsListGrid',getCommonTranslation('RESIDENCE_APPLICATIONS_STUDENTS')],
	                    ['Academia.view.scholarship.scholarshiplisting.SPScholarshipListGrid',getCommonTranslation('SCHOLARSHIP_LIST')],
	                    ['Academia.view.scholarship.scholarshiplisting.ScholarshipStudentAwardeeListGrid',getCommonTranslation('STUDENT_SCHOLARSHIP_AWARDEES_LIST')],
	                    ['Academia.view.scholarship.scholarshiplisting.ScholarshipApplicantAwardeeListGrid',getCommonTranslation('APPLICANT_SCHOLARSHIP_AWARDEES_LIST')],
	                    ['Academia.view.scholarship.managescholarship.ManageScholarshipStudentListGrid',getCommonTranslation('MANAGE_SCHOLARSHIP_STUDENT_LIST')],
	                    ['Academia.view.scholarship.managescholarship.ManageScholarshipApplicantListGrid',getCommonTranslation('MANAGE_SCHOLARSHIP_APPLICANT_LIST')],
	                    ['Academia.view.scholarship.scholarshiplisting.ListOfOnlineDocumentsGrid',getCommonTranslation('LIST_OF_ONLINE_DOCUMENTS_PORTAL')],
	                    ['Academia.view.scholarship.scholarshiplisting.ListOfOnlineDocumentsCerpGrid',getCommonTranslation('LIST_OF_ONLINE_DOCUMENTS')],
	                    ['Academia.view.admission.applications.applicationBase.ApplicationDocumentsAndNotesGrid',getPersonModuleTranslation('DOCUMENTS_AND_NOTES')],
	                    ['Academia.view.admission.applications.applicationBase.SalesforceAdmissionDetailsGrid',getCommonTranslation('APPLICANT_SALESFORCE_ADMISSION_DETAILS')],
	                    ['Academia.view.student.studentprofile.StudentSalesforceAdmissionDetailsGrid',getCommonTranslation('STUDENT_SALESFORCE_ADMISSION_DETAILS')],
	                    ['Academia.view.coursetransaction.sectionmanagement.ProgramBatchSectionGrid',getCommonTranslation('LIST_OF_PROGRAM_BATCH_SECTION')],
	                    ['Academia.view.coursetransaction.sectioncoursecoverageplan.mastertimetable.TimeTableProgamBatchGrid',getCommonTranslation('TIME_TABLE_SESSIONS')],
	                    ['Academia.view.program.programDetails.programBatchDetails.courses.ProgramCoursesGrid',getCommonTranslation('COURSES_GRID')],
	                    ['Academia.view.program.programDetails.programBatches.ProgramBatchesGrid', getProgramandcourseTranslation('PROGRAM_BATCH_DETAILS')],
	                    ['Academia.view.program.programDetails.programBatchDetails.seatTypes.ProgramSeatTypesGrid', getCommonTranslation('SEAT_TYPE_GRID')],
	                    ['Academia.view.program.StudentSpecialEnrollmentGrid', getCommonTranslation('SPECIALIZATION_ENROLLMENT_GRID')],
	                    ['Academia.view.coursetransaction.sectionmanagement.CourseSectionGroupList',getCourseTxCommonTranslation('LIST_OF_SECTION_GROUP')],
	                    ['Academia.view.coursetransaction.sectionmanagement.CourseSectionGrid',getCommonTranslation('COURSE_SECTION_GRID')],
	                    ['Academia.view.examinationcenters.evalresultlisting.CourseWiseGrid', getCommonTranslation('EXAM_RESULT_COURSE_SCREEN')],
	                    ['Academia.view.examinationcenters.examresultpublish.BulkExamResultPublishGrid', getExaminationTranslation('BULK_EXAM_RESULT_PUBLISH_TITLE')],
	                    ['Academia.view.student.studentprofile.StudentProgramCompletionDetailsGrid', getCommonTranslation('STUDENT_PROGRAM_COMPLETION_DETAILS')],
	                    ['Academia.view.scholarship.scholarshipmaster.BursaryMasterGrid', getCommonTranslation('SCHOLARSHIP_MASTER')],
                        ['Academia.view.completion.completionlist.PassingOutGrid', getCommonTranslation('COMPLETION_PASSOUT')],
                        ['Academia.view.reports.admission.dashboard.DtefCourseEnrollmentGrid',getCommonTranslation('DTEF_COURSE_ENROLLMENT')],
                        ['Academia.view.facultyCourseInterest.FacultyInterestReportGrid', getCommonTranslation('FACULTY_INTEREST_REPORT')],
                        ['Academia.view.taskmanagement.TaskManagementTaskGrid', getServiceRequestTranslation('TM_TASK_LIST')],
                        ['Academia.view.coursetransaction.sectionmanagement.CourseSectionStudentGrid', getProgramandcourseTranslation('ENROLLED_STUDENTS')],
                        ['Academia.view.coursetransaction.studentcourseenrollment.studentenrollmentdetail.ChangeExamCenterGrid', getCommonTranslation('CHANGE_EXAM_CENTER')],
						['Academia.view.program.transfercredits.TransferCreditGrid', getCommonTranslation('LIST_OF_STUDENTS_FOR_TRANSFER_CREDIT_GRID')],
	   				    ['Academia.view.coursetransaction.promotion.PromotionPanelList',getCommonTranslation('PROMOTION_PANEL_LIST')],
	   				    ['Academia.view.alumniSystem.alumniList.alumniListGrid',getAlumni('ALUMNI_DATA_GRID')],
                        ['Academia.view.alumniSystem.signUpRequest.SignUpRequestGrid',getAlumni('ALUMNI_SIGN_UP_DATA_GRID')],
                        ['Academia.view.alumniSystem.alumniPortalSetUp.AlumniPortalSetUpGrid',getAlumni('ALUMNI_PORTAL_SETUP_GRID')],
                        ['Academia.view.committee.committee.AlumniCommitteeGrid',getAlumni("LIST_OF_ALUMNI_COMMITTEE")],
                        ['Academia.view.alumniSystem.alumniNewsAndFeeds.AlumniNewsAndFeedsGrid',getAlumni("ALUMNI_NEWS_AND_FEEDS")],
                        ['Academia.view.facilitiesresources.resourcebooking.alumniEventRegistrationDetails.AlumniEventRegistrationDetailsGrid',getAlumni("ALUMNI_EVENT_REGISTRATION_DETAILS")],
                        ['Academia.view.alumniSystem.alumniFundsRaising.AlumniFundsRaisingGrid', getAlumni('ALUMNI_FUND_RAISING_LIST')],
                        ['Academia.view.alumniSystem.alumniFundsRaising.AlumniFundsTransactionListingGrid', getAlumni('ALUMNI_DONORS_LIST')],
                        ['Academia.view.hostel.hostelApplicationSetup.HostelApplicationSetupGrid', getMegaMenuTranslation('HOSTEL_APPLICATION_SETUP')],
                        ['STUDENT_TRACK_REQUEST', getCommonTranslation('STUDENT_REQUEST_CORE_ERP')],
                        ['Academia.view.student.healthInformationReport.StudentHealthInformationReportGrid',getCommonTranslation('STUDENT_HEALTH_INFORMATION_REPORT')],
                        ['Academia.view.admission.applications.applicationBase.EligibilityPointerPopupGrid',getCommonTranslation('ELIGIBILITY_CALCULATION_DETAILS')],
                        ['Academia.view.student.incidentsReport.StudentNegativeIncidentsReportGrid',getCommonTranslation('STUDENT_NEGATIVE_INCIDENT_REPORT')],
                        ['Academia.view.examinationcenters.assessmentEvent.RoomAndStaffAllocationGrid', getExaminationTranslation('ROOM_AND_STAFF_ALLOCATION')],
                        ['Academia.view.examinationcenters.assessmentEvent.ExamConcessionStaffAllocationGrid', getExaminationTranslation('EXAM_CONCESSION_STAFF_ALLOCATION')],
                        ['Academia.view.personinfo.common.pasthistory.QualificationDetailsGrid', getCommonTranslation('QUALIFICATION_DETAILS')],
                        ['Academia.view.personinfo.common.course.FacultyCourseInterestGrid', getPersonModuleTranslation('FACULTY_COURSE_INTEREST')],
                        ['Academia.view.facultyCourseInterest.HighestQualificationInnerGrid', getCommonTranslation('HIGHEST_QUALIFICATION')],
                        ['Academia.view.eventlevelremark.EventLevelRemarkGrid', getMegaMenuTranslation('EVENT_LEVEL_REMARK')],
                        ['Academia.view.examinationcenters.evalresultlisting.EvaluationTypeLevelGrid', getExaminationTranslation('EXAMINATION_RESULT_TYPE')],
                        ['Academia.view.examinationcenters.evalresultlisting.EvaluationSubTypeLevelGrid',getExaminationTranslation('EXAMINATION_RESULT_SUBTYPE')],
                        ['Academia.view.examinationcenters.evalresultlisting.EvaluationMethodLevelGrid',getExaminationTranslation('EXAMINATION_RESULT_METHOD')],
                        ['Academia.view.examinationcenters.evalresultlisting.ExamResultEventGrid',getExaminationTranslation('EXAMINATION_RESULT_EVENT')],
                        ['Academia.view.examinationcenters.evalresultlisting.EvaluationProgramLevelGrid',getExaminationTranslation('EXAMINATION_RESULT_PROGRAM')],
                        ['Academia.view.examinationcenters.evaluationgroup.AssessmentGroupsGridView',getExaminationTranslation('CNTRL_EVALUATION_GROUP')],
                        ['Academia.view.personinfo.common.personalinfo.IdentityDetailsGrid',getPersonModuleTranslation('IDENTITY_DETAILS')],
                        ['Academia.view.coursesessiondiary.CourseSessionDiaryFacultyPortalGrid', getCommonTranslation('FACULTY_COURSE_SESSION_DAIRY')],
                        ['Academia.view.student.studentprofile.StudentExternalTransferCreditRequestGrid', getCommonTranslation('EXTERNAL_TRANSFER_CREDIT')],
                        ['Academia.view.student.studentprofile.StudentInternalTransferCreditRequestGrid', getCommonTranslation('INTERNAL_TRANSFER_CREDIT')],
                        ['Academia.view.admission.applications.applicationBase.TransferCreditsGrid', getCommonTranslation('APPLICANT_TRANFER_CREDIT')],
                        ['STUDENT_SERVICE_REQUEST_ANGULAR', getCommonTranslation('STUDENT_SERVICE_REQUEST_ANGULAR')],
						
						['Academia.view.personinfo.student.StudentForExternalTransferCreditGrid',getCommonTranslation('EXTERNAL_TRANSFER_CREDIT_FOR_SP')],
						['Academia.view.personinfo.student.StudentForInternalTransferCreditGrid', getCommonTranslation('INTERNAL_TRANSFER_CREDIT_FOR_SP')],
						['Academia.view.admission.applicationFormSale.ChangeProgramWindowCurrentGrid',getAdmissionTranslation('CURRENT_APPLICATION_PROGRAM')],
						['Academia.view.lecturerCostingDefinition.LecturerCostingCourseInnerGrid', getCommonTranslation('LECTURER_COURSE_COSTING_LIST')],
						['Academia.view.lecturerCostingDefinition.LecturerCostingServiceInnerGrid', getCommonTranslation('LECTURER_SERVICE_COSTING_LIST')],
						['Academia.view.hrm.ICAttendanceAndPaymentReport.ICAttendanceAndPaymentConsolidatedReportGrid', getCommonTranslation('IC_ATTENDANCE_AND_PAYMENT_CONSOLIDATED_REPORT')],
						['Academia.view.hrm.ICAttendanceAndPaymentReport.ICAttendanceAndPaymentDetailedReportGrid', getCommonTranslation('IC_ATTENDANCE_AND_PAYMENT_DETAILED_REPORT')]
	   				]  // data is local 
					}),
					allowBlank:false,
					fieldLabel: getCommonTranslation('SELECT_GRID'),
					valueField: 'id',
					displayField: 'name',
					queryParam:'gridName',
					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					forceSelection:true,
					triggerAction: 'all',
					editable: false,
					width: 600,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}

				},{
					xtype: 'customcombobox',
					name: 'portalIdCombo',
					itemId: 'portalIdComboItemId',
					store: new Ext.data.ArrayStore({
						id: 0,
						fields: [
							'id',
							'name'
							],
							data: [
								['1','Admin'],
								['2','Faculty'],
								['6','Applicant'],
								['3','Student'],
								['7','Parent'],
								//['10','Alumni']
								/*['2','Teacher']*/
								]
					}),
					allowBlank:false,
					fieldLabel: getCommonTranslation('SELECT_PORTAL'),
					valueField: 'id',
					displayField: 'name'
				}]
			},{
				xtype: 'fieldcontainer',
				width: 'auto',
				items: [{
					xtype: 'button',
					text: getCommonTranslation('SEARCH'),
					itemId: 'searchBtn',
					buttonAlign: 'left',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE,
					formBind:true
				}, {
					xtype: 'button',
					itemId: 'resetBtn',
					text: getCommonTranslation('RESET'),
					ui:'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE
				}]
			}]
		},{
			xtype: 'grid',
			title: getHostelTranslation('SEARCH_RESULT'),
			border: true,
			autoScroll: false,
			refreshStoreData:true,
			frame:false,
			viewConfig: {
				stripeRows: CONSTANTS.STRIPEROWS
			},
			headerFix:{
				headerFix: true,
				portalIdsWithStructure: {
					'configuredatagridstructure':1
				}
			},
			store: new Ext.data.ArrayStore({
				id: 0,
				fields: ['id', 'columnName', 'dataIndex', 'columnVisibility', 'mandatory', 'keyName','orderBy','defaultSortBy'],
				data: []
			}),
			tbar: [{
				xtype: 'button',
				itemId: 'btnSave',
				tooltip: getCommonTranslation('SAVE'),
				text: getCommonTranslation('SAVE'),
				disabled: true
			},{
				xtype: 'checkbox',
				itemId: 'isVisibleColumnItemId',
				boxLabel:getCommonTranslation('SHOW_COLUMN_BUTTON_IN_GRID'),
				inputValue : 'true',
				uncheckedValue : 'false',
				name : 'isVisibleColumn'
			},{
				xtype: 'checkbox',
				itemId: 'enableSortingConfigItemId',
				boxLabel:getCommonTranslation('ENABLE_SORTING_CONFIGURATION'),
				inputValue : true,
				uncheckedValue : false,
				name : 'enableSortingConfig',
				hidden:true
			}], 
			viewConfig: {
				deferEmptyText: false,
				emptyText: getCommonTranslation('NORESULTSNMESSAGE'),
				plugins: {
					ptype: 'gridviewdragdrop',
					dragText: 'Drag and drop to reorganize'
				}
			},
			columns: [{
				header:  getCommonTranslation('COLUMN_NAME'),
				dataIndex: 'columnName',
				flex:1,
				sortable:false                            // sorting need to disable to achieve functionality of sorting by and order by column
			},/*{
    		header:  getCommonTranslation('DATA_INDEX'),
    		dataIndex: 'dataIndex',
    		flex:1,
    		sortable:true
    	},*/{
				header: getCommonTranslation('COLUMN_VISIBILITY'),
				flex:1,
				dataIndex: 'columnVisibility',
				sortable: false, 
				renderer:function(value,meta,record){
					var checkedShow = '';
					var checkedHide = '';
					var checkedRemove = '';
					var checkMandatory = '';
					if(value=="SHOW"){
						checkedShow = "checked";
					}
					else if(value=="HIDE"){
						checkedHide = "checked";
					}
					else if(value=="REMOVE"){
						checkedRemove = "checked";
					}
					if(record.get('mandatory')){
						checkMandatory = 'disabled="disabled"';
					}
					return '<input type="radio" name="visibility_'+record.get('dataIndex')+'"  value="SHOW" '+checkedShow+' '+checkMandatory+' /> Show <input type="radio" name="visibility_'+record.get('dataIndex')+'" value="HIDE" '+checkedHide+' '+checkMandatory+' /> Hide <input type="radio" name="visibility_'+record.get('dataIndex')+'" value="REMOVE" '+checkedRemove+' '+checkMandatory+' /> Remove';
				}
			}],
			plugins: {
				ptype: 'cellediting',
				clicksToEdit: 1,
				listeners: {
					    beforeedit: function(editor, e, opts) {
						if((e.record.data.defaultSortBy) && (e.record.data.columnVisibility == "SHOW")){
							return true;
						}else{
							return false;
						}
					}
			    }
			}
		}]
	}]
});