/**
 * @author Pritam.Patil
 * This is used for add Document template mapping window 
 */
Ext.define('Academia.view.documentmanagement.AddDoumentTemplateMappingWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.adddoumenttemplatemappingwindow',
    modal: true,
    autoScroll: true,
    title: getDocumentTranslation('DOCUMENT_TEMPLATE_MAPPING'),
    frame: true,
    items: [{
        xtype: 'form',
        itemId: 'documentTemplateMappingForm',
        standardSubmit: false,
        plugins: "formlabelrequired",
        defaults: {
            labelAlign: 'top'
        },
        items: [{
            xtype: 'hidden',
            name: 'id',
            itemId: 'template_hidden_id'
        }, {
            xtype: 'fieldcontainer',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            layout: 'hbox',
            items: [{
                xtype: 'customcombobox',
                name: 'configLevel',
                fieldLabel: getDocumentTranslation('DOCUMENT_CATEGORY'),
                itemId: 'document_category',
                editable: false,
                allowBlank: false,
                displayField: 'value',
                valueField: 'name',
                queryMode: 'local',
                msgTarget: 'qtip',
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.documentmanagement.DocumentCategorys');
                        combo.bindStore(store);
                    }
                }
            }, {
                xtype: 'customcombobox',
                name: 'documentTypeId',
                fieldLabel: getDocumentTranslation('DOCUMENT_NAME'),
                itemId: 'document_type',
                allowBlank: false,
                editable: false,
                displayField: 'typeName',
                valueField: 'documentTypeId',
                queryMode: 'local',
                msgTarget: 'qtip',
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.documentmanagement.DocumentTypes');
                        combo.bindStore(store);
                    }
                }
            }]
        },  {
            xtype: 'fieldcontainer',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            layout: 'hbox',
            items: [{
                xtype: 'checkbox',
                boxLabel: getDocumentTranslation('USE_DEFAULT_TEMPLATE'),
                name: 'useDefaultTemplate',
                inputValue: true,
                uncheckedValue: false,
                itemId: 'useDefaultTemplate',
                msgTarget: 'qtip'
            }, {
                xtype: 'checkbox',
                boxLabel: getDocumentTranslation('WHETHER_ACTIVE'),
                name: 'whetherActive',
                inputValue: true,
                uncheckedValue: false,
                checked: true,
                itemId: 'whetherActive',
                msgTarget: 'qtip'
            }]
        }, {
            xtype: 'fieldcontainer',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            layout: 'hbox',
            items: [{
                xtype: 'customcombobox',
                name: 'templateId',
                fieldLabel: getDocumentTranslation('TEMPLATE_NAME'),
                itemId: 'templateName',
                editable: false,
                allowBlank: false,
                displayField: 'templateName',
                valueField: 'templateId',
                queryMode: 'local',
                msgTarget: 'qtip',
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.documentmanagement.Templates');
                        combo.bindStore(store);
                    }
                }
            }]
        }, {
            xtype: 'fieldcontainer',
            itemId: 'buttonContainer',
            width: '100%',
            style :{
            	marginTop : '16px',
            	marginLeft : '-2px'
            },
            items: [{
                xtype: 'button',
                itemId: 'submitButtonId',
                text: getCommonTranslation('SUBMIT'), //Submit
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getServiceRequestTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'cancelButtonId',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});