/**
 * @author Deepak Sharma
 * This component is used for Document Master Grid
 */
Ext.define('Academia.view.documentmanagement.DocumentMasterGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.documentmastergrid',
    store : 'documentmanagement.DocumentMasterStore',
    border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	headerFix:{
        headerFix: true,
        portalIdsWithStructure: {
            'documentmasterstructure':1
        }
	},
    title: getTranslation('PLACEMENT_DOCUMENT_MASTER'),
    dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'documentmanagement.DocumentMasterStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH

    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH

    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'

    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH

    }],
    columns: [{
        header: getCommonTranslation('ITEM_CODE'),
        dataIndex: 'code',
        sortable: true,
        flex: .2
    }, {
        header: getCommonTranslation('ITEM_VALUE'),
        dataIndex: 'value',
        sortable: true,
        flex: .2
    }, {
        header: getCommonTranslation('DOCUMENT_APPLICABLE_TO'),
        dataIndex: 'docmentApplicable',
        sortable: true,
        flex: .2,
        renderer: function(val, rec) {
        	 var str = new Array();
            if (!isNullOrEmpty(rec)) {
            	if(rec.record.get('isApplicableForEmployee')){
            		str.push(getCommonTranslation('EMPLOYEE')); 
            	}
            	if(rec.record.get('isApplicableForStudent')){
            		str.push(getCommonTranslation('STUDENT'));
            	}
            	if(rec.record.get('isApplicableForParent')){
            		str.push(getPersonModuleTranslation('PARENTS_GUARDIANS'));
            	}
            	
                return str.join(', ');
            }
        }
    }]
});