/**
 *  @author Deepak Sharma
 */

Ext.define('Academia.view.documentmanagement.DocumentTemplateMappingAddCourseGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.documenttemplatemappingaddcoursegrid',
	title : getDocumentTranslation('COURSE'),
	store: Ext.create('Academia.store.documentmanagement.DocumentTemplateMappingAddCourseGridStore'),
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : true,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	autoScroll: false,
	height:380,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		loadMask: false,
		deferEmptyText: false,
		emptyText: getCommonTranslation('NORESULTSNMESSAGE')
	},
	border: true,
	tbar: [{
		xtype: 'button',
		text: getCommonTranslation('SUBMITKYS'),
		itemId: 'submitBtn',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'button',
		text: getCommonTranslation('RESET'),
		itemId: 'resetBtn',
		scale: CONSTANTS.BUTTONSIZE
	},{
		xtype: 'customcombobox',
		name: 'courseId',
		itemId:'courseId',
		store: Ext.create('Academia.store.documentmanagement.DocumentTemplateMappingAddCourseGridStore'),
		valueField: 'secondId',
		displayField: 'code',
		triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
		enableKeyEvents  : 'true',
		queryParam:'name',
		queryMode: 'remote',
		width:226,
		typeAhead : true,
		forceSelection:true,
		hideTrigger:false,
		triggerAction: '',
		minChars:3,
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}'  +
				'</div>';
			}
		}
	}],
	columns: [{
		header : getProgramandcourseTranslation('ACADEMY_LOCATION'),
		dataIndex : 'secondValue',
		flex : 1	 
	},{
		header : getCommonTranslation("COURSE_CODE_NAME"),
		dataIndex : 'code',
		flex : 1	 
	}],
	plugins: {
        ptype: 'bufferedrenderer'
    }
});