/**
 * Gajendra.verma
 */
  Ext.define('Academia.view.enquiry.CommunicationHistory.CommunicationHistoryGrid', {
	
    extend: 'Ext.grid.Panel',
    alias: 'widget.communicationhistorygrid',
    //store: 'messaging.CommunicationHistoryReportList',
    border: true,
    autoScroll: false,
    refreshStoreData: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    style:{
    	'padding-top':'2px',
    },
   /* dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'messaging.CommunicationHistoryReportList',
            emptyMsg: getMessagingModuleTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
   */ columns: [{
        header: getMessagingModuleTranslation('RECIPIENT_NAME'),
        dataIndex: 'recipientFullName',
        flex: 1
    }, {
        header: getMessagingModuleTranslation('CONTACT'),
        dataIndex: 'contact',
        flex: 1
    }, {
        header: getMessagingModuleTranslation('LASTUPDATE'),
        dataIndex: 'lastUpdate',
        flex: 1,
        renderer: function(date) {
            return dateRender(date) + '-' + timeRender(date);
        }
    }, {
        header: getMessagingModuleTranslation('MSGCONTENT'),
        dataIndex: 'msgContent',
        flex: 1,
        renderer: function(value) {
             return '<a href="#">view</a>';
        }
    }, {
        header: getMessagingModuleTranslation('SENT_BY'),
        dataIndex: 'sentBy',
        flex: 1
    }, {
        header: getMessagingModuleTranslation('EVENT_NAME'),
        dataIndex: 'eventName',
        flex: 1,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == 'RESET_PASSWORD' || value == 'Reset Password'){
					return getMessagingModuleTranslation('RESET_PASSWORD');
				}else if(value == 'ADD_EXTERNAL_USER' || value == 'Add External User'){
					return getMessagingModuleTranslation('ADD_EXTERNAL_USER');
				}else if(value == 'APPLICANT_RESET_PASSWORD' || value == 'Applicant Reset Password'){
					return getMessagingModuleTranslation('APPLICANT_RESET_PASSWORD');
				}else if(value == 'CREATE_ENQUIRY' || value == 'Create Enquiry'){
					return getMessagingModuleTranslation('CREATE_ENQUIRY');
				}else if(value == 'MSG_CREATE_CAMPAIGN' || value == 'Msg Create Campaign'){
					return getMessagingModuleTranslation('MSG_CREATE_CAMPAIGN');
				}else if(value == 'SA_SAU_MAU_MAPPING' || value == 'Sa Sau Mau Mapping'){
					return getMessagingModuleTranslation('SA_SAU_MAU_MAPPING');
				}else if(value == 'ADD_ORG_STRUCTURE' || value == 'Add Org Structure'){
					return getMessagingModuleTranslation('ADD_ORG_STRUCTURE');
				}else if(value == 'SEND_OFFER_LETTER' || value == 'Send Offer Letter'){
					return getMessagingModuleTranslation('SEND_OFFER_LETTER');
				}else if(value == 'USER_PROGRAM_COURSE_ASSOCIATION' || value == 'User Program Course Association'){
					return getMessagingModuleTranslation('USER_PROGRAM_COURSE_ASSOCIATION');
				}else if(value == 'USER_ACADMEY_LOCATION_ASSOCIATION' || value == 'User Acadmey Location Association'){
					return getMessagingModuleTranslation('USER_ACADMEY_LOCATION_ASSOCIATION');
				}else if(value == 'UNLOCK_USER' || value == 'Unlock User'){
					return getMessagingModuleTranslation('UNLOCK_USER');
				}else{
					return value;
				} 
			}
		}
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        //this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.messaging.CommunicationHistoryReportList');
    }
});