/**
 * @author Rajkumar.patidar
 * 
 */
Ext.define('Academia.view.enquiry.Reports.notificationfailurereport.NotificationFailureReportGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.notificationfailurereportgrid',
    store : 'enquiry.reports.NotificationFailureReport',
	//title : getCommonTranslation('ENQUIRY_STUDENT_DETAILS'),
	border : true,
	autoScroll : true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
			store:'enquiry.reports.NotificationFailureReport',
			emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	columns : [{
				hidden:true,
				dataIndex:'id'
			},{
				header : getCommonTranslation('ENQUIRY_NO'),
				dataIndex : 'enquiryNo',
				flex : 1,
				sortable : true
				
			},{
				header : getCommonTranslation('ENQUIRY_TYPE_1'),
				dataIndex : 'enquiryType',
				flex : 1,
				sortable : true	
			},{
				header : getCommonTranslation('TRACK_ENQUIRER_STUDENT_NAME'),
				dataIndex : 'studentName',
				flex : 1,
				sortable : true
			}, {
			    header : getCommonTranslation('ACADEMY'),
			    dataIndex : 'academy',
			    flex : 1,
			    sortable : true
			}, {
			    header : getCommonTranslation('LOCATION'),
			    dataIndex : 'location',
			    flex : 1,
			    sortable : true
			}, {
			    header : getCommonTranslation('PROGRAM'),
			    dataIndex : 'program',
			    flex : 1,
			    sortable : true
			},{
			    header : getCommonTranslation('FAILURE_DATE'),
			    dataIndex : 'failureDate',
			    flex : 1,
			    sortable : true,
				renderer:function(date) {
					return dateRender(date);
				}
			},{
			    header : getCommonTranslation('SMS_FAILURE'),
			    dataIndex : 'smsFailure',
			    flex : 1,
			    sortable : true
			},{
			    header : getCommonTranslation('E_MAIL_FAILURE'),
			    dataIndex : 'emailFailure',
			    flex : 1,
			    sortable : true
			},{
				header : getCommonTranslation('POSTAL_ADDRESS_FAILURE'),
				dataIndex : 'postalAddressFailure',
				flex : 1,
				sortable : true
			}]
});