/**
 * @author Rajkumar.patidar
 */

/*var closureRateGridStore = Ext.create('Ext.data.JsonStore', {
	fields: ['type','count'],
	data: []
});*/

var closureRatePieStore = Ext.create('Ext.data.JsonStore', {
	fields: ['type','count'],
	data: []
});

/*var closureRateGrid = Ext.define('Ext.grid.Panel', {
	alias:'widget.closureRateGrid',
	store: closureRateGridStore,
	autoScroll:false,
	close:'destroy',
	refreshStoreData:true,
	itemId:'closureRateGrid',
	height: 140,
	width: 210,
	columns: [{
		header  : getCommonTranslation('TYPE'),
		dataIndex: 'type'
	},{
		header   : getCommonTranslation('CAPACITY'),
		dataIndex: 'count'
	}]
});*/

var closureRatePieChart = Ext.create('Ext.chart.Chart', {
	width: 130,
	height: 130,
	animate: false,
	store: closureRatePieStore,
	shadow: false,
	insetPadding: 0,
	theme: 'Base:gradients',
	series: [{
		type: 'pie',
		field: 'count',
		showInLegend: false,
		label: {
			field: 'type',
			display: 'rotate',
			contrast: true,
			font: '9px Arial'
		}
	}]
});


Ext.define('Academia.view.enquiry.dashboard.RichTipChartForClosureRate' ,{
	extend: 'Ext.chart.Chart',
	requires:['Ext.chart.*','Ext.layout.container.Fit','Ext.window.MessageBox','Ext.grid.Panel'],
	style: 'background:#fff',
	alias : 'widget.richtipchartforclosurerate',
	animate: true,
	shadow: false,
	width: 600,
	height: 300,
	store:'enquiry.dashboard.ClosureRate',// 'programCourseDashboard.ProgramVacantSeatsChartStore',
	axes: [{
		type: 'Numeric',
		position: 'left',
		 fields: ['noOfEnquiry'],
		title: getEnquiryTranslation('NUMBER_OF_ENQUIRIES'),
		grid: true,
		label: {
			renderer: Ext.util.Format.numberRenderer('0,0')
		}
	}, {
		type: 'Category',
		position: 'bottom',
		 fields: ['range'],
		title: getEnquiryTranslation('CLOSED_IN_DAYS')
	}],
	series: [{
		type: 'line',
		axis: 'left',
		gutter: 50,
		xField: 'range',
		yField: ['noOfEnquiry'],
		tips: {
			trackMouse: true,
			background:'#dfe8f6',
			 width: 400,
             height: 190,
			layout: 'fit',
			items: {
				xtype: 'container',
				layout: 'hbox',
				items: [closureRatePieChart,{
					xtype:'closurerategrid'
				}]
			},
			renderer: function(klass, item) {
				var storeItem = item.storeItem;
				this.setTitle(getEnquiryTranslation('ENQUIRY_FOR') +' '+ storeItem.get('range'));
				var subData = storeItem.get("data");
				var closureRateGridStore = Ext.ComponentQuery.query('#closureRateGrid')[0].getStore();
				var myJson=[];
				//closureRatePieStore.clearFilter(true);
				//closureRateGridStore.clearFilter(true);
				if(subData.length>0){
					for(var i in subData){
					 myJson.push({
							"count" : subData[i].count,
							"type" : subData[i].type
						});
					}
					
					closureRatePieStore.loadRawData(myJson);
					closureRateGridStore.loadRawData(myJson);
				}else{
					item.series.hideTip(true);
				}
			}
		}
	}]
});
