/**
 *  @author Ravi Choudhary
 */

Ext.define('Academia.view.enquiry.student.StudentDetailFormRevamp', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
	customFieldEntity:CONSTANTS.ENQ_STUDENT_DETAIL_CUSTOM_FIELD,
	columns: 3,
	alias: 'widget.studentdetailformrevamp',
	autoScroll: false,
	frame: false,
	border:false,
	standardSubmit: false,
	defaults: {
		width: 226,
		labelAlign: 'top'
	},
	plugins : "formlabelrequired",
	items: [{
		xtype: 'hidden',
		name: 'id'
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 226,
			labelAlign:'top'
		},
		items:[{
			xtype: 'hidden',
			id:'studentDetails_id',
			name: 'id'
		},{
			xtype: 'nestedTextField',
			id:'studentDetails_enquiryId',
			hidden:true,
			name: 'enquiry'
		},{
			xtype:'hidden',
			id:'studentDetails_addressId',
			name:'addressId'
		},{
			xtype:'hidden',
			id:'studentDetails_enquiryAddressId',
			name:'enquiryAddressId'	  
		},{
			xtype: 'nestedJsonCombo',
			name: 'reservationCategory',
			id:'studentDetails_reservationCategory',
			fieldLabel: getEnquiryTranslation("RESERVATION_CATEGORY"),
			store: 'enquiry.studentDetail.ReservationCategoryStore',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			allowBlank: false
		},{
			xtype: 'nestedJsonCombo',
			fieldLabel: getCommonTranslation('SALUTATION'),
			id:'studentDetails_salutation',
			name: 'salutation',
			store: 'common.SalutationStore',
			valueField: 'id',
			displayField: 'salutationName',
			allowBlank: false,
			editable: false
		}]
	}, {
		xtype: 'fieldcontainer',
		width: '100%',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 226,
			labelAlign:'top',
			regex: /[a-zA-Z0-9]+/
		},
		items:[{        	
			xtype: 'textfield',
			name: 'studentFirstName',
			id:'studentDetails_studentFirstName',
			allowBlank: false,
			fieldLabel: getCommonTranslation('FIRST_NAME'),
			maxLength:100,
			enforceMaxLength : true
		},{
			xtype: 'textfield',
			name: 'studentMiddleName',
			id:'studentDetails_studentMiddleName',
			fieldLabel: getCommonTranslation('MIDDLE_NAME'),
			maxLength:53,
			enforceMaxLength : true
		},{
			xtype: 'textfield',
			name: 'studentLastName',
			id:'studentDetails_studentLastName',
			allowBlank:false,
			fieldLabel: getCommonTranslation('LAST_NAME'),
			maxLength:100,
			enforceMaxLength : true
		}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 226,
			labelAlign:'top',
			regex: /[a-zA-Z0-9]+/
		},
		items:[{
			xtype: 'datefield',
			name: 'studentDateOfBirth',
			id:'studentDetails_studentDateOfBirth',
			maxValue : new Date(),
			fieldLabel:getCommonTranslation('DOB_OF_STUDENT'),
			//--submitFormat: 'd-m-Y',// CONSTANTS.DATE_FORMAT,
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				},
				change : function(date){
					var calcAge = date.up('form').getForm().findField('ageAsOnBirthDate');
					// console.log('calcAge....',calcAge);
					var today = new Date();
					var birthDate = new Date(date.lastValue);
					var age = today.getFullYear() - birthDate.getFullYear();
					var dobMonth = birthDate.getMonth();
					var tillDtMonth = today.getMonth();
					var month;
					if(tillDtMonth<dobMonth){
						age--;
						month=12-(dobMonth-tillDtMonth);
					}else if (tillDtMonth>dobMonth){
						month=tillDtMonth-dobMonth;
					}else{
						month=0;
					}
					calcAge.setValue(age + ' Year'+' '+ month +' Months');
				}
			}
		},{
			xtype: 'textfield',
			fieldLabel: getCommonTranslation('PRESENT_AGE'),
			itemId: 'ageAsOnBirthDate',
			listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
			name: 'ageAsOnBirthDate',
			editable: false,
			readOnly:true,
			disabled:true,

		},{  
			xtype: 'customcombobox',
			name: 'gender',
			id:'studentDetails_gender',
			store: 'enquiry.studentDetail.GenderStore',
			fieldLabel: getCommonTranslation('GENDER'),
			editable: false,
			valueField: 'id',
			displayField: 'value',
			allowBlank: false
		}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout: {
			type: 'hbox'
		},
		hidden:true,
		defaults: {
			width: 226,
			labelAlign:'top',
			regex: /[a-zA-Z0-9]+/
		},
		items: [{
			xtype: 'customcombobox',
			name: 'country',
			//id: 'enquiryDetail_country',
			fieldLabel: getCommonTranslation('ADDRESS_COUNTRY'),
			store: 'common.CountryStore',
			valueField: 'id',
			displayField: 'countryName',
			itemId: 'country1',

		}, {
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('COUNTRY_REGION'),
			itemId : 'genericFieldId2',
			//id : 'genericFieldId1',
			store:'organization.CountryRegionStore',
			valueField : 'id',
			displayField : 'countryRegionName',
			name : 'parentCountryRegion',
			editable : false,
			valueNotFoundText:"",        		        						
			forceSelection :true,
			allowBlank:true
		},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('ADDRESS_CITY'),
			//id: 'enquiryDetail_city',
			name: 'city',
			editable: false,
			allowBlank: true,
			itemId: 'city1',
			store: 'organization.CityByCountryRegion',
			valueField: 'id',
			displayField: 'value'
		}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 226,
			labelAlign:'top',
			regex: /[a-zA-Z0-9]+/
		},
		items:[{
			xtype: 'nestedJsonCombo',
			name: 'incomeSlabs',
			id:'studentDetails_incomeSlabs',
			store: 'enquiry.studentDetail.IncomeSlabStore',
			fieldLabel: getCommonTranslation('FAMILY_INCOME'),
			editable: false,
			valueField: 'id',
			displayField: 'value',
			//	allowBlank: false,
			itemId: 'incomeSlab' 
		}],
	},{
		xtype: 'fieldset',
		title: '<b class="menu-title">'+getCommonTranslation('RELATIONSHIP_INFORMATION')+'</b>',
		style: {marginTop: '40px !important'},
		itemId:'relationshipDetailsId',
		width: 'auto',
		items:[{
			xtype:'panel',
			layout:'vbox',
			cls: 'panelNoSpace',
			items:[{
				xtype: 'fieldcontainer',        
				width: 'auto',
				layout: 'hbox',
				style: {
					marginTop: '-10px !important'
				},
				defaults: {
					labelAlign: 'top',
					width: 226
				},
				items: [{
					xtype: 'customcombobox',
					fieldLabel: getPersonModuleTranslation('RELATIONSHIP'),
					name: 'relationship',
					valueField: 'name',
					displayField: 'value',
					itemId: 'relationShipField',
					store: 'common.RelationshipStore',
					editable: false,
					allowBlank: true
				},{
					xtype: 'checkboxfield',
					itemId: 'relationshipCheckbox',
					labelAlign: 'right',
					boxLabel: getAdmissionTranslation('IS_EMPLOYEE_OF_ACADEMY'),
					name: 'relationshipCheckbox',
					inputValue: true,
					uncheckedValue: false,
					style:{marginTop:'23px'}
				},{
					xtype: 'customcombobox',
					name: 'relationshipStudent',
					itemId: 'relationshipStudent',
					fieldLabel: getAdmissionTranslation('STUDENT_NAME'),
					store: 'admission.manageForm.StudentWithOutAL',
					//style:{marginLeft:'52px !important'},
					valueField: 'id',
					hidden:true,
					displayField: 'valueCode',
					queryParam:'studentNameOrCode',
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					minChars:3,
					typeAhead:false,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					hideTrigger:false,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{studentCode} / {studentName}' +
							'</div>';
						}
					}
				},{
					xtype: 'customcombobox',
					name: 'relationshipUser',
					itemId: 'relationshipUser',
					fieldLabel: getAdmissionTranslation('EMPLOYEE_NAME'),
					store: 'criteriabuilder.userquicksearch.QuickSearchCode',
					valueField: 'id',
					displayField: 'value',
					queryParam:'code',
					//style:{marginLeft:'32px !important'},
					minChars:3,
					typeAhead:false,
					hidden:true,
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					//cls:'gridInputCustomStyle',
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					forceSelection:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
				},{
					xtype:'hidden',
					name:'personRelationshipsId'
				},{
					xtype:'hidden',
					name:'personRelationshipsVersion'
				}]
			},{
				xtype: 'fieldcontainer',        
				width: 'auto',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 226
				},
				items: [{
					xtype: 'textfield',
					name: 'relationshipName',
					itemId:'relationshipName',
					readOnly:true,
					fieldLabel: getAdmissionTranslation('NAME'), //Last Name       
					allowBlank: true
				},{
					xtype : 'numberfield',
					name: 'relationshipMobileNo',
					itemId: 'relationshipMobileNo',
					hideTrigger: true,
					mouseWheelEnabled:false,
					maxLength: 10,
					enforceMaxLength : true,
					readOnly:true,
					minValue:0,
					fieldLabel : getAdmissionTranslation('MOBILE_NO')//Contact No.
				}, {
					xtype: 'textfield',
					name: 'relationshipEmail',
					vtype:'email',
					itemId: 'relationshipEmail',
					readOnly:true,
					fieldLabel : getAdmissionTranslation('EMAIL_ID')//Email ID,
				}/*,{
					xtype:'hidden',
					name:'relatedPersonId'
				},{
					xtype:'hidden',
					name:'relatedPersonVersion'
				}*/,{
					xtype: 'button',
					itemId: 'btnAddRelationshipDetails',
					cls: 'CustomBodyBtnSettings',
					text: getCommonTranslation('ADDBUTTONTEXT'),
					style:{marginTop:'30px'},
					tooltip: getCommonTranslation('ADD')
				}]
			}]
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: {
			type: 'hbox'
		},
		items: [{
			xtype: 'button',
			action: 'Submit',
			text: getCommonTranslation('SAVE'),
			formBind:true,
			itemId: 'studentdetail_submitbuttonId',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		}, {
			xtype: 'button',
			text: getCommonTranslation('CANCEL'),
			ui: 'CustomBtnCancel',
			itemId:'studentdetail_cancelbuttonId',
			scale: CONSTANTS.BUTTONSIZE

		}]
	}]
});