/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.eventmeetingminutes.EMMMinuteReportsGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.emmminutereportsgrid',
    store: 'eventmeetingminutes.EMMMinuteReportsStore',
    title: getServiceRequestTranslation('EMM_MEETING_MINUTE_REPORTS'),
    border: true,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        itemId: 'dockedItemsItemId',
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'eventmeetingminutes.EMMMinuteReportsStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    tbar: [],
    columns: [{
        header: getServiceRequestTranslation('EMM_MINUTE_OWNER'),
        dataIndex: 'ownerPrintName',
        flex: 1,
        sortable: true
    }, {
        header: getServiceRequestTranslation('EVENT_NAME'),
        dataIndex: 'eventName',
        flex: 1,
        sortable: true,
    }, {
        header: getServiceRequestTranslation('EMM_ASSIGNED_DATE'),
        dataIndex: 'assignDate',
        flex: 1,
        renderer: function(date) {
            return dateRender(date);
        },
    }, {
        header: getServiceRequestTranslation('EMM_TOPIC'),
        dataIndex: 'topic',
        flex: 1,
        sortable: true,
        renderer: function(val) {
            if (!isNullOrEmpty(val)) {
                return getCommonTranslation(val);
            }
            return '';
        }
    }, {
        header: getServiceRequestTranslation('EMM_TYPE'),
        dataIndex: 'type',
        flex: 1,
        sortable: true,
        renderer: function(val) {
            var colorValue = '';
            if (val == 'AGENDA') {
                colorValue = "<span style = 'color:#2b78e4;'>" + getCommonTranslation(val) + "</span>";
            } else if (val == 'IDEA') {
                colorValue = "<span style = 'color:#ff9900;'>" + getCommonTranslation(val) + "</span>";
            } else if (val == 'DECISION') {
                colorValue = "<span style = 'color:#cc0000;'>" + getCommonTranslation(val) + "</span>";
            } else if (val == 'INFO') {
                colorValue = "<span style = 'color:#009e0f;'>" + getCommonTranslation(val) + "</span>";
            } else if (val == 'TASK') {
                colorValue = "<span style = 'color:#9900ff;'>" + getCommonTranslation(val) + "</span>";
            }
            return colorValue;
        }
    }, {
        header: getServiceRequestTranslation('DESCRIPTION'),
        dataIndex: 'description',
        flex: 1,
        sortable: true
    }, {
        header: getServiceRequestTranslation('DUE_DATE'),
        dataIndex: 'dueDate',
        flex: 1,
        sortable: true,
        renderer: function(date) {
            return dateRender(date);
        },
    }, {
        header: getServiceRequestTranslation('EMM_MINUTE_STATUS'),
        dataIndex: 'status',
        flex: 1,
        sortable: true,
        renderer: function(val) {
            var colorValue = '';
            if (val == 'PENDING') {
                colorValue = "<span style = 'color:#cc0000;'>" + getCommonTranslation(val) + "</span>";
            } else if (val == 'COMPLETED') {
                colorValue = "<span style = 'color:#009e0f;'>" + getCommonTranslation(val) + "</span>";
            }
            return colorValue;
        }
    }, {
        header: getServiceRequestTranslation('EMM_COMPLETION_DATE'),
        dataIndex: 'completionDate',
        flex: 1,
        sortable: true,
        renderer: function(date) {
            return dateRender(date);
        }
    }, {
        header: getServiceRequestTranslation('EMM_NO_OF_DAYS_OVERDUE'),
        dataIndex: 'noOfDaysOverdue',
        flex: 1,
        sortable: true
    }]
});