/**
 * Deepika p
 */
var examConcessionStore=Ext.create('Academia.store.examconcession.ExamConcessionGridStore');
Ext.define('Academia.view.examconcession.ExamConcessionGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.examconcessiongrid',
	store: examConcessionStore,
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	frame:false,
	title:getExaminationTranslation('LIST_OF_EXAM_CONCESSIONS'),
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
				xtype: 'custompagingtoolbar',
				itemId:'managePaggingToolBarItemId',
				plugins:['pagesize'],
			    store : examConcessionStore,
				emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
				displayInfo : true
		}]
	}],
  initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
 },
 tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		disabled: true
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip : getCommonTranslation('VIEW'),
		iconCls: 'view-icon',
		disabled: true
	} ,{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		disabled: true
	}, {
       xtype: 'button',
       itemId: 'btnApplyTo',
       tooltip: getCommonTranslation('APPLY_TO'),
       text: getCommonTranslation('APPLY_TO'),
       disabled: true
   }],
 	
	columns: [{
		header: getExaminationTranslation('EXAM_CONCESSION_CODE'),
		dataIndex: 'examConcessionCode',
		flex:.4,
		sortable:true
	},{
		header : getExaminationTranslation('EXAM_CONCESSION_NAME'),
		dataIndex : 'examConcessionName',
		flex:.3,
		sortable: true
	},{
		header: getExaminationTranslation('MAPPED_PROGRAMS'),
		dataIndex: 'mappedProgramCount',
		flex:.3,
		sortable: true,
		renderer:function(val,rec,e){
    		if(!isNullOrEmpty(val)){
    			if(val=='0' || val == '0.00' || val == '0.0'){
    				return "-";
    			}else{
    				return "<a href='#'>"+val+"</a>" ;
    			}
    		} else {
    			return "-";
    		}
    	}
	},{
		header: getExaminationTranslation('STATUS'),
		dataIndex: 'status',
		flex:.4,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.status)) {
				return getCommonTranslation(record.data.status);
			}                        
		}
	}]
});
