/**
 *  @author Vinay Kumrawat
 * 
 */
Ext.define('Academia.view.examinationattendancerule.AttendanceAddMappingAcademyLocationTab' ,{
	extend: 'Ext.panel.Panel',
	alias : 'widget.attendanceaddmappingacademylocationtab',
    width:'100%',
	title: getCommonTranslation('ACADEMY_LOCATION'),
	autoScroll:false,
	bodyStyle:{
		border: 0
	},
	items:[{
		xtype:'label',
		itemId:'attendanceRuleNameLabel',
		margin: 10
	},{
		xtype:'grid',
		title:getCommonTranslation('ACADEMY_LOCATION'),
		store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
		border: true,
		viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS
		},
		selType:'checkboxmodel',
		selModel: {
			checkOnly : false,
			multiSelect :true,
    	    mode: 'SIMPLE'
		},
		tbar: [{
			xtype: 'button',
			itemId: 'academyLocationNextBtn',
			tooltip: getCommonTranslation('NEXT'),
			text:getCommonTranslation('NEXT'),
			disabled: true
		}, {
			xtype: 'button',
			itemId: 'academyLocationResetBtn',
			tooltip: getCommonTranslation('RESET'),
			text: getCommonTranslation('RESET')
		}, {
            xtype: 'customcombobox',
            name: 'ACAD_LOC_ID',
            itemId:'academyLocationCombo',
            store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
            displayField: 'value',
            valueField: 'id',
            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
            enableKeyEvents  : 'true',
            typeAhead : true,
            forceSelection:true,
            hideTrigger:false,
            queryMode: 'remote',
            queryParam: 'qry',
    	    triggerAction: '',
            minChars:3,
            width: 226,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'  +
	                    '</div>';
	                }
	            }
        }],
		columns :[{
			header : getCommonTranslation('ACADEMY_LOCATION'),
			dataIndex : 'value',
			flex:1
		}]
	}]
});

