/**
 * Deepika P
 */
Ext.define('Academia.view.examinationcenters.assessmentEvent.AllowDetainedStudentWin', {
	extend: 'Ext.window.Window',
	alias: 'widget.allowdetainedstudentwin',
	modal: true,
	autoScroll:false,
	title: getExaminationTranslation('ALLOW_STUDENT'),
	maxHeight:500,
	items: [{
		xtype: 'form',
		method: 'POST',
		margin: 0,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items: [{
				xtype: 'customcombobox',
				name:'nonDetentionId',
				itemId:'nonDetentionItemId',
				store:'examinationcenters.NonDetentionReasonStore',
				fieldLabel:getExaminationTranslation('REASON_FOR_NON_DETENTION'),
				valueField: 'id',
				displayField: 'value',
				allowBlank:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					}
				}
			},{
				xtype: 'datefield',
				name: 'fromdate',
				itemId:'fromdataItemId',
				allowBlank:false,
				minValue:new Date(),
				fieldLabel:getExaminationTranslation('DATE'),
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name:'approverId',
				itemId:'approverItemId',
				store:'examinationcenters.CenterResponisble',
				fieldLabel:getExaminationTranslation('APPROVER_NAME'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				minChars:3,
				width:226,
				allowBlank:false,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'textarea',
				name:'description',
				itemId:'descriptionId',
				width: 460,
				maxLength : 250,
				fieldLabel: getExaminationTranslation('REMARKS')
			}]
		},{
			xtype: 'fieldcontainer',
			cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				action : 'Submit',
				text: getCommonTranslation('SAVE'),	
				itemId: 'btnSave',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId: 'btnCancel',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});