/**
 * Deepika Parmar
 */
Ext.define('Academia.view.examinationcenters.averagereport.StudentAverageReportWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.studentaveragereportwin',
	title : getCommonTranslation('EXPORT_REPORT'),
	modal: true,
	autoScroll:true,
	maxHeight:250,
	width: '15%',
	height:'20%',
	items: [{
		xtype: 'form',
		method: 'POST',
		margin: 0,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			autoScroll:true,
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults: {
				labelAlign: 'top',
        		width: 226
			},
			items: [{
            	xtype: 'customcombobox',
            	itemId:'studentAverageReportFilterId',
        		name: 'studentAverageReportFilter',
        	    store:Ext.create('Academia.store.setup.templatemapping.TemplateNameListFacultyByCode'),
        		displayField:'code',
        		valueField:'id',
        		forceSelection:true,
        		triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        		enableKeyEvents  : 'true',
        		typeAhead:true,
        		minChars:3,
        		listConfig: {
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				},
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				}
    			},
        		allowBlank:false,
        		fieldLabel:getExaminationTranslation('SELECT_TEMPLATE')
            }]
		},{
			xtype: 'fieldcontainer', 
			cls : 'windowBtnPos',
			layout : {
				type : 'hbox'
			},
			width:'auto',
			items : [{
				xtype : 'button',
				text : getExaminationTranslation("SUBMIT") ,
				itemId : 'submitBtn',
				ui : 'CustomBtnThird',
				buttonAlign: 'left',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			}]
		}]
	}]
});