/**
 * @author Ankush Solanki
 */
Ext.define('Academia.view.examinationcenters.calculateAverage.AssessmentSubjectDetailsStructure', {
	extend : 'Ext.panel.Panel',
    alias: 'widget.assessmentsubjectdetailsstructure',
    modal: false,
	autoScroll:false,
	frame: false,
	items: [{
		xtype:'form',
		name:'assessmentSubjectDetailForm',
		itemId:'assessmentSubjectDetailForm',
		items:[{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 420,
				labelWidth:120,
				labelAlign: 'top'
			},
			items:[{
				xtype:'displayfield',
				name:'studentCodeName',
				fieldLabel:'<b>'+getExaminationTranslation('STUDENT_ID_NAME')+'</b>'
			},{
				xtype:'displayfield',
				name:'gradeIntake',
				fieldLabel:'<b>'+getExaminationTranslation('GRADE_INTAKE')+'</b>'
			},{
				xtype:'displayfield',
				name:'sectionName',
				fieldLabel:'<b>'+getExaminationTranslation('CLASS')+'</b>'
			}]
		},
		{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 420,
				labelWidth:120,
				labelAlign: 'top'
			},
			items:[{
				xtype:'displayfield',
				name:'assessmentLevelName',
				fieldLabel:'<b>'+getExaminationTranslation('ASSESSMENT_LEVEL')+'</b>'
			},{
				xtype:'displayfield',
				name:'assessmentLevelValue',
				fieldLabel:'<b>'+getExaminationTranslation('ASSESSMENT_LEVEL_NAME')+'</b>'
			},{
				xtype:'displayfield',
				name:'droolName',
				fieldLabel:'<b>'+getExaminationTranslation('DROOL')+'</b>'
			}]
		}]
	},{
		xtype: 'grid',
		name:'assessmentSubjectListGridItemId',
		itemId:'assessmentSubjectListGridItemId',
		border:true,
		autoScroll:false,
		frame: false,
		cls: 'asl_summarygrid',
		store:Ext.create('Academia.store.examinationcenters.calculateAverage.AssessmentSubjectListGridStore'),
		viewConfig: {
			stripeRows: CONSTANTS.STRIPEROWS
		},
		title: '&nbsp;',
		style: {
			marginRight: 0
		},
		features: [{
			id: 'group',
			ftype: 'groupingsummary',
			groupHeaderTpl: '{name}',
			hideGroupedHeader: false,
			enableGroupingMenu: true
		},{
			ftype: 'summary',
			dock: 'bottom'
		}],
		dockedItems: [{
		        xtype: 'toolbar',
		        dock: 'bottom',
		        cls: 'gridAverageToolbar',
		        items: [{
		            xtype: 'displayfield',
		            label: '',
		            value: 'Average',
		            style:{
		                'float': 'left'
		            }
		        },
		        {
		        	xtype: 'displayfield',
		        	label: '',
		        	value: '',
		        	itemId: 'asl_gradeAverage',
		            style:{
		                'float': 'right',
		                'position': 'initial !important'
		            }
		        }]
		    }],
		columns: [{
			header: getExaminationTranslation('SUBJECT_CODE'),
			dataIndex: 'courseCode',
			flex:.1,
			align:'left',
			summaryType: 'count',
	        summaryRenderer: function(value, summaryData, dataIndex) {
	        	var text = "Total";
	            return text;
	        }
		},{
			header: getExaminationTranslation('SUBJECT_NAME'),
			dataIndex: 'courseName',
			flex:.1,
			align:'left',
		},{
			header: getExaminationTranslation('SUBJECT_OFFERING'),
			dataIndex: 'whetherOptional',
			flex:.1,
			align:'left',
			renderer:function(val,rec,e){
	    		if(!isNullOrEmpty(val)){
	    			if(val==true){
	    				return 'Optional';
	    			}else{
	    				return "Mandatory" ;
	    			}
	    		} else {
	    			return "-";
	    		}
	    	}
		},{
			header: getExaminationTranslation('SUBJECT_TYPE'),
			dataIndex: 'subjectType',
			flex:.1,
			align:'left',
			renderer:function(val,rec,e){
	    		if(!isNullOrEmpty(val)){
	    			if(val=="EXTENSION_AND_ENRICHMENT"){
	    				return getExaminationTranslation('EXTENSION_AND_ENRICHMENT');
	    			}else if (val=="THE_ARTS"){
	    				return getExaminationTranslation('THE_ARTS');
	    			}else {
		    			return val;
		    		}
	    		} 
	    	}
		},
		{
	        header: getExaminationTranslation('SUBJECT_MARKS'),
	        dataIndex: 'obtainedMarks',
	        align:'left',
	        flex:.1
	    },{
	        header: getExaminationTranslation('CONTRIBUTING_TO_AVERAGE'),
	        dataIndex: 'contributionToAverage',
	        flex:.1,
	        align:'left',
	        renderer:function(val,rec,e){
	    		if(!isNullOrEmpty(val)){
	    			var average=null;
	    			if(isNullOrEmpty(rec.record.data.isAverage)){
	    				average = false;
	    			}else{
	    				average = rec.record.data.isAverage;
	    			}
	    			if(val=="true" && average==true){
	    				return 'Average' ;
	    			} else if(val=="true" && average==false){
	    				return 'Yes';
	    			} else{
	    				return "No" ;
	    			}
	    		} else {
	    			return "-";
	    		}
	    	}
	    	
	    },{
	        header: getExaminationTranslation('WEIGHTING'),
	        dataIndex: 'courseCredits',
	        flex:.1,
	        summaryType: 'count',
	        align:'left',
	        renderer:function(val,rec,e){
	    		if(rec.record.data.contributionToAverage && !rec.record.data.isAverage){
	    			return val;
	    		}else {
	    			return rec.record.data.averageCredit;
	    		}
	    	},
	    	summaryRenderer: function(value, summaryData, dataIndex) {
	    		try{
	    			return this.getStore().data.items[0].data.totalCredits.toFixed(1);
	    		}
	    		catch(e){
	    			return '';
	    		}
	    	}
	    },{
			header: getExaminationTranslation('MARK_CONTRIBUTION'),
			dataIndex: 'marksContribution',
			flex:.1,
			summaryType: 'count',
			align:'left',
			renderer:function(val,rec,e){
	    		if(!isNullOrEmpty(val)){
	    			if(val % 1 === 0){
		    			return val;
	    			}
	    			else{
		    			return val.toFixed(2);
	    			}
	    		}
    		},
    		summaryRenderer: function(value, summaryData, dataIndex) {
    			try{
    				return this.getStore().data.items[0].data.totalMarksContribution.toFixed(2);
    			}
    			catch(e){
    				return '';
    			}
	        }
		}]
	}]
});