/**
 * @author sumit meena
 */
Ext.define('Academia.view.examinationcenters.dashboard.supervisorroleplayed.SupervisorRolePlayedFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.supervisorroleplayedfilter',
	autoScroll: false,
	frame: false,
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	cls:'panelNoSpace',
	items: [{
		xtype:'form',
		cls:'customSearchPanel',
		items:[{	
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'centerType',
				itemId:'centerTypeItemId',
				store:'program.programDetails.programBatches.assignExamCenter.ProgramCenterTypeStore',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true,
				fieldLabel:getExaminationTranslation('CENTER_TYPE'),
				allowBlank: false
			},{
				xtype: 'multiselectcombofield',
				name: 'centerName',
				store:'examinationcenters.evaluationgrouplisting.centerallocation.CenterNameByEvalGroupIdCenterType',
				fieldLabel:getExaminationTranslation('CENTER_NAME'),
				displayField:'code',
				valueField:'id',
				width: 460,
				typeAhead:true,
				forceSelection:true,
				disabled:true,
				cls:'placementProgramMultiselect'
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'programId',
				store:'common.ProgramStore',
				itemId:'programItemId',
				fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				displayField:'valueCode',
				valueField:'id',
				width: 460,
				typeAhead:true,
				forceSelection:true,
				/*cls:'receiptHeaderMultiselect',*/
			},{
				xtype: 'customcombobox',
				name: 'batchId',
				itemId:'batchItemId',
				store: 'common.BatchesByProgramId',
				displayField:'value',
				valueField:'id',
				//forceSelection:true,
				typeAhead:true,
				fieldLabel:getExaminationTranslation('BATCH'),
				disabled:true
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name:'courseId',
				itemId:'courseItemId',
				store:'examinationcenters.dashboard.CourseByMultipleAcdemyLocation',
				fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				width: 460,
				minChars:3,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				disabled:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}

			},{
				xtype: 'customcombobox',
				name: 'user',
				itemId:'userItemId',
				store:'examinationcenters.roomallocation.RoomAllocationInvigilator',
				fieldLabel:getExaminationTranslation('USER'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				hideTrigger:false,
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'datefield',
				name: 'fromDate',
				itemId:'fromDateItemId',
				//minValue: new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				fieldLabel:getExaminationTranslation('FROM_DATE')
			},{
				xtype: 'datefield',
				name: 'toDate',
				itemId:'toDateItemId',
				minValue: new Date(),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
				fieldLabel:getExaminationTranslation('To_DATE')
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind:true
			},{
				xtype: 'button',
				itemId: 'resetBtn',
				text: getCommonTranslation('RESET'),
				ui:'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	},{
		xtype:'supervisorroleplayedgridstructure',
		width:'100%'
	}]
	});