/**
 * @author Manas Luktuke     
 */
Ext.define('Academia.view.examinationcenters.evalresultlisting.EvaluationMethodLevelGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.evaluationmethodlevelgrid',  
    store: 'examinationcenters.evalresultlisting.EvaluationMethodLevelStore', 
    title: getExaminationTranslation('EVALUATION_SQUENCE'),          
    border: true,
    isGridConfigurable: true,
	enableColumnHide: true,    
    refreshStoreData: true,
    deferEmptyText: false,
    cls: 'grid-bottom-border',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    }, 
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        itemId: 'dockedItemsItemId',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'examinationcenters.evalresultlisting.EvaluationMethodLevelStore',        
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function () {
        var grid = this;
        grid.addExportToolBarItems(grid);   
        this.callParent(arguments);
    },
    tbar: [{
    	xtype: 'button',
    	itemId: 'approveButtonItemId',
    	text: getCommonTranslation('APPROVE'),
    	tooltip :getCommonTranslation('APPROVE'),
    	hidden: true 
    }],
    columns: [{ 
			        header: getCommonTranslation('EVALUATION_SEQUENCE_ID'),   
			        dataIndex: 'id',
			        flex: 1,
			        hidden: true     
			    },
			    {
			        header:getExaminationTranslation('EVALUATION_SQUENCE'), 
			        dataIndex: 'sequenceName',        
			        flex: 1, 
			        hidden: false,
			        renderer: function (value, meta, record) {
			    	if(!isNullOrEmpty(record)) {
			    		return record.raw.sequenceName;   
					} 
					
				}
			    
			    },
                {
                    header: getCommonTranslation('WEIGHTAGE'),
                    dataIndex: 'weightage',
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('MAX_MARKS'),
                    dataIndex: 'maxMarks', 
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('MAX_GRADE'),
                    dataIndex: 'gradeObtainedFrom', 
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('OBTAINED_MARKS'),
                    dataIndex: 'obtainedMarks',
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('EFFECTIVE_MARKS'),
                    dataIndex: 'effectiveMarks',
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('GRADE_OBTAINED'),
                    dataIndex: 'gradeObtained', 
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('GRADE_POINT'),
                    dataIndex: 'gradePoint', 
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('SECTION_WISE_RANK'),
                    dataIndex: 'sectionRank', 
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('TYPE_LEVEL_RANK'),
                    dataIndex: 'courseRank',  
                    flex: 1,
                    hidden: false
                },
                {
                    header: getCommonTranslation('STATUS'),
                    dataIndex: 'status',
                    flex: 1,
                    hidden: false,
			        renderer:function(value){
						if(!isNullOrEmpty(value)) {
							return value;  
						}                        
					}
                },
                {
                    header: getCommonTranslation('COURSE_VARIANT_ID'),
                    dataIndex: 'courseVariantId', 
                    flex: 1,
                    hidden: true
                },
                {
                    header: getCommonTranslation('SECTION_ID'),
                    dataIndex: 'sectionId',    
                    flex: 1,
                    hidden: true
                }  
            ]
}); 