/**
 * @author Pankaj Sisodiya     
 */
Ext.define('Academia.view.examinationcenters.evaluationgroup.AssessmentGroupsGridView', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.assessmentGroupsGridView',  
    store: 'examinationcenters.evalresultlisting.AssessmentGroupsGridStore', 
  title: getExaminationTranslation('CNTRL_EVALUATION_GROUP'),
    border: true,
    isGridConfigurable: true,
	enableColumnHide: true,    
    refreshStoreData: true,
    deferEmptyText: false,
    cls: 'grid-bottom-border',
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    }, 
    headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'evalgroupmasterstructure': 1
		}
	},
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        itemId: 'dockedItemsItemId',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'examinationcenters.evalresultlisting.AssessmentGroupsGridStore',      
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function () {
        var grid = this;
        grid.addExportToolBarItems(grid,false);
        this.callParent(arguments);
    },
    tbar: [{
		xtype: 'button',
		itemId: 'searchResultGridBtnAdd',
		tooltip: getFeeAndPaymentCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'searchResultGridBtnEdit',
		tooltip: getFeeAndPaymentCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'searchResultGridBtnView',
		tooltip: getFeeAndPaymentCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'searchResultGridBtnDelete',
		cls: 'CustomToolbarBtnReject',
		
		tooltip: getFeeAndPaymentCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},
	'->',
	{
		xtype: 'button',
		itemId: 'exportReportsId',
		disabled:true,
		tooltip : getCommonTranslation('EXPORTREPORTS'),
		text : getCommonTranslation('EXPORTREPORTS'),
	}],
    columns: [{
        header: getCommonTranslation('EXAM_DATE_FROM'),
        dataIndex: 'examDateFrom',
        flex: 1,
        hidden: false,
		renderer:function(val){		
			if(!isNullOrEmpty(val)){
				return dateRender(val);
			}
		}
    },{
        header: getCommonTranslation('FEE_PLAN_NAME'),
        dataIndex: 'feePlanName',
        flex: 1,
        hidden: false,
        renderer:function(val){		
			if(!isNullOrEmpty(val)){
				return "<a href='#'>" + val + "</a>"
			}
		}
    },{
        header: getCommonTranslation('NO_OF_BATCHES_COVERED'),
        dataIndex: 'numberOfBatchCovered',
        flex: 1,
        hidden: false,
        renderer:function(val){		
			if(!isNullOrEmpty(val)){
				return "<a href='#'>" + val + "</a>"
			}
		}
    },{ 
			        header: getCommonTranslation('EVALUATION_GROUP_CODE'),   
			        dataIndex: 'evaluationGroupCode',
			        flex: 1,
			        hidden: false     
			    },
			    
                
                {
                    header: getCommonTranslation('EXAM_DATE_TILL'),
                    dataIndex: 'examDateTill',
                    flex: 1,
                    hidden: false,
            		renderer:function(val){		
            			if(!isNullOrEmpty(val)){
            				return dateRender(val);
            			}
            		}
                },
                {
                    header: getCommonTranslation('APPLICATION_SUBMISSION_START_DATE'),
                    dataIndex: 'applicationSubmissionStartDate', 
                    flex: 1,
                    hidden: false,
            		renderer:function(val){		
            			if(!isNullOrEmpty(val)){
            				return dateRender(val);
            			}
            		}
                },
                {
                    header: getCommonTranslation('APPLICATION_TILL_DATE'),
                    dataIndex: 'applicationSubmissionTillDate',
                    flex: 1,
                    hidden: false,
            		renderer:function(val){		
            			if(!isNullOrEmpty(val)){
            				return dateRender(val);
            			}
            		}
                },
                {
                    header: getCommonTranslation('NUMBER_OF_BATCHES_IN_DAY'),
                    dataIndex: 'numberOfBatchesInADay',
                    flex: 1,
                    hidden: false
                },
                
                {
                    header: getCommonTranslation('HALL_TICKET_GENERATION_REQUIRED'),
                    dataIndex: 'hallTicketGenerationRequired', 
                    flex: 1,
                    hidden: false,
            		renderer:function(val){		
            			if(val){
            				return getCommonTranslation("YES");
            			}else{
            				return getCommonTranslation("NO");
            			}
            		}
                },
                {
                    header: getCommonTranslation('WHETHER_STUDENT_RESCHEDULE'),
                    dataIndex: 'whetherStudentReschedule', 
                    flex: 1,
                    hidden: false,
            		renderer:function(val){		
            			if(val){
            				return getCommonTranslation("YES");
            			}else{
            				return getCommonTranslation("NO");
            			}
            		}
                },
                {
                    header: getCommonTranslation('NO_OF_COURSE_COVERED'),
                    dataIndex: 'numberOfCourseCovered',  
                    flex: 1,
                    hidden: false,
                    renderer:function(val){		
            			if(!isNullOrEmpty(val)){
            				return "<a href='#'>" + val + "</a>"
            			}
            		}
                },
                {
                    header: getCommonTranslation('EVALUATION_GROUP_STATUS'),
                    dataIndex: 'evaluationGroupStatus',
                    flex: 1,
                    hidden: false,
                    renderer:function(val){		
                    	return getCommonTranslation(val);
            		}
                }       
            ]
}); 