/**
 * sumit.meena
 */
Ext.define('Academia.view.examinationcenters.evaluationgrouplisting.centerallocation.EGListingCenterAllocationGrid', {
    //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.eglistingcenterallocationgrid',
    store: 'examinationcenters.evaluationgrouplisting.centerallocation.EGListingCenterAllocationGrid',
    border: true,
    autoScroll: false,
    frame:false,
    title:getExaminationTranslation('CENTER_ALLOCATION_LIST'),
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			    store : 'examinationcenters.evaluationgrouplisting.centerallocation.EGListingCenterAllocationGrid',
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}
	],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
	 tbar: [{
	        xtype: 'button',
	        itemId: 'btnAdd',
	        tooltip: getCommonTranslation('ADD'),
	        glyph: ICONGLYPH.ADDGLYPH
	    }, /*{
	        xtype: 'button',
	        itemId: 'btnEdit',
	        tooltip: getCommonTranslation('EDIT'),
	        glyph: ICONGLYPH.EDITGLYPH
	    }, {
	        xtype: 'button',
	        itemId: 'btnView',
	        tooltip: getCommonTranslation('VIEW'),
	        iconCls: 'view-icon'
	    }*/, {
	        xtype: 'button',
	        itemId: 'btnDelete',
	        cls: 'CustomToolbarBtnReject',
	        tooltip: getCommonTranslation('DELETE'),
	        glyph: ICONGLYPH.DELETEGLYPH
	    }],
    columns: [{
        header: getExaminationTranslation('COURSE'),
        dataIndex: 'courseName',
        flex:.1,
        sortable: true
    },{
		header : getExaminationTranslation('COURSE_VARIANT'),
		dataIndex:'courseVariantName',
		flex:.1
	},{
		header : getExaminationTranslation('PERIOD'),
		dataIndex:'periodName',
		flex:.1
	},{
		header : getExaminationTranslation('SECTION'),
		dataIndex:'sectionName',
		flex:.1
	},{
        header: getExaminationTranslation('CENTER_NAME'),
        dataIndex: 'centerName',
        flex:.1,
        sortable:true
    }, {
        header: getExaminationTranslation('DATE'),
        dataIndex: 'scheduleDate',
        flex:.1,
        sortable: true,
        renderer: function(date) {
			if(date!=null){
				return dateRender(date);
			}else{
           		return 'NA';
			}
        }
    }, {
        header: getExaminationTranslation('TIME_SLOT'),
        dataIndex: 'batchName',
        flex:.1,
        sortable: true,
        renderer:function(value, record){
			if(record.record.data.timeFrom!=null){
				return timeRender(record.record.data.timeFrom)+" - "+(timeRender(record.record.data.timeTo));
			}else{
				return 'NA';
			}
        	
        }
    }, {
        header: getExaminationTranslation('DETAILED_SEQUENCE'),
        dataIndex: 'detailSequenceNumber',
        flex:.1,
        sortable: true
    }]
});