/**
 * @author sumit.meena
 */
Ext.define('Academia.view.examinationcenters.evaluationplanstatus.EvaluationStatusQuickFilter', {
	extend: 'Ext.form.Panel',
    alias: 'widget.evaluationstatusquickfilter',
    autoScroll: false,
    frame: false,
	cls:'customSearchPanel',
    modal: true,
    plugins:"formlabelrequired",
    standardSubmit: false,
    items: [{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
        	xtype: 'customcombobox',
            name: 'evaluationplantype',
        	itemId:'evaluationplantypeItemId',
            store:'examCenter.AssignSequence.EvaluationType',
            displayField:'value',
            valueField:'id',
            forceSelection:true,
            typeAhead:true,
            fieldLabel:getExaminationTranslation('EVALUATION_PLAN_TYPE'),
        },{
        	
        	  xtype : 'customcombobox',
        	  name : 'evaluationStage',
        	  itemId:'evaluationStageItemId',
        	  fieldLabel:getExaminationTranslation('EVALUATION_STAGE'),
        	  store : 'examinationcenters.CenterUseFor',
        	  valueField : 'id',
        	  displayField : 'value',
	          typeAhead:true,
        	  hidden:false
        },{
        	  xtype : 'customcombobox',
        	  name : 'placementEvaluationStage',
        	  itemId: 'placementEvaluationStageItemId',
        	  fieldLabel:getExaminationTranslation('EVALUATION_STAGE'),
        	  store : 'examinationcenters.evaluation.PlacementAcademyOthers',
        	  valueField : 'id',
        	  displayField : 'value',
	          typeAhead:true,
        	  hidden:true
          },{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'academicTerm',
			itemId : 'academicTermId',
			displayField : 'value',
			valueField : 'id',
			width: 226,
			minChars:3,
			queryMode:'local',
			typeAhead : true,
			forceSelection : true,
			allowBlank:false,
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.AcademicTermStore');
					combo.bindStore(store)
				}
			}
		},{
        	    xtype: 'customcombobox',
    			name:'programId',
    			itemId:'manageAssessmentProgramIdItemId',
    			store:'examinationcenters.evaluation.evaluationPlanHeirarchy.MappedProgramToOtherPlanStore',
    			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
    			valueField: 'id',
    			displayField: 'valueCode',
    			queryParam:'programName',
    			minChars:3,
    			forceSelection:true,
    			width: 226,
 				disabled:true,    
    			typeAhead:false,
    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    			enableKeyEvents  : 'true',
    			hideTrigger:false,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    						picker.maxWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				}
    			}  
        }]
        },{
	    	xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            width: 226,
	            labelAlign: 'top'
	        },
	        items: [{
				 xtype: 'customcombobox',
			     name: 'batchId',
			     itemId:'assessmentSchemeBatchIdItemId',
			     store: 'enquiry.EnrollStudentBatchStore',
			     displayField:'value',
			     valueField:'id',
			     forceSelection:true,
  				 minChars: 3,
            	 queryParam: "batchName",
			     typeAhead:true,
			     disabled:true,
			     fieldLabel: getExaminationTranslation('BATCH'),
			     listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{value}' +
    					'</div>';
    				}
    			}  
			},{
				 xtype: 'customcombobox',
			     name: 'periodId',
			     itemId:'assessmentSchemePeriodIdItemId',
			     fieldLabel: getExaminationTranslation('PERIOD'),
			     store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
			     displayField:'value',
			     valueField:'id',
			     forceSelection:true,
			     typeAhead:true,
			     disabled:true
            },{
	        	 xtype: 'customcombobox',
			     name: 'sectionId',
			     fieldLabel: getExaminationTranslation('SECTION'),
			     store:'attendance.SectionAndFacultyByPeriodID',
			     displayField:'sectionCode',
			     itemId:'assessmentSchemeSectionIdItemId',
			     valueField:'sectionId',
			     forceSelection:true,
			     typeAhead:true,
			     hidden:true,
			     disabled:true
            },{
	        	xtype: 'customcombobox',
				name:'evalautionPlanNo',
				itemId:'assessmentSchemeEvalautionPlanNoItemId',
				store:'examinationcenters.evaluationgroup.detailsequencecovered.EvaluationPlanManageStatus',
				fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
				valueField: 'id',
				displayField: 'value',
				width: 226,
				typeAhead:false,
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				disabled:true,
				editable : false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
	            }]
     },{
	    	xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            width: 226,
	            labelAlign: 'top'
	        },
	        items: [{
	        	xtype: 'customcombobox',
	            name: 'courseVariant',
	            itemId:'assessmentSchemecourseVariantItemId',
	            width:226,
	            store:'attendance.VariantMappedToPlanForManageEvalStatus', 
	            fieldLabel:getExaminationTranslation('COURSE_VARIANT'),
	            displayField:'value',
	            valueField:'id',
	            queryParam:'name',
				minChars:3,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				 disabled:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
				}
	    	},{
	        	xtype: 'customcombobox',
				name:'evalautionPlanNoForOther',
				itemId:'evalautionPlanNoForOtherItemId',
				store:'examinationcenters.evaluationgroup.detailsequencecovered.EvaluationPlanManageStatusForOtherScheme',
				fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
				valueField: 'id',
				displayField: 'value',
				width: 226,
				typeAhead:false,
				disabled:true,
				allowBlank:false,
				hideTrigger:false,
				forceSelection:false,
				hidden:true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					}
				}
	    	}]
     },{
		xtype: 'fieldset',
		collapsible : true,
		collapsed: true,
		title: getCommonTranslation('MORE_DETAILS'),
		titleCollapse: true,
		itemId : 'moreDetailId',
		defaults : {
			labelAlign:'top',
		},
		style: {
			marginTop: '35px!important',
			paddingTop:'18px!important' 
		},
		items:[{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'customcombobox',
				name: 'evaluationLevel',
				itemId: 'evaluationLevelItemId',
				store:'examinationcenters.reports.EvalListLevelPlanWithoutSchemeStore',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true,
				minChars:3,
				width:226,
				fieldLabel:getExaminationTranslation('EVALUATION_PLAN_LEVEL')
			},{
				xtype: 'customcombobox',
				name: 'evalLevelName',
				itemId: 'assessmentSchemeEvalLevelNameId',
				store:'examinationcenters.calculateAverage.EvaluationPlanLevelNameStore',
				fieldLabel:getExaminationTranslation('EVALUATION_LEVEL_NAME'),
				displayField:'value',
				valueField:'id',
				minChars:3,
				typeAhead:true,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				disabled:true,
				width:226,
				maxLength: 10000000,
				listConfig: {listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = 'auto';
						setTimeout(function(){
							picker.el.dom.style.width='auto';
							picker.el.dom.style.minWidth = picker.up('combobox').getSize().width+'px';
						},10);
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}}
	    	},{
	        	xtype: 'customcombobox',
	            name: 'markEntryStatus',
	            itemId: 'assessmentSchemeMarkEntryStatus',
	            store:'examinationcenters.marksheet.Jobstatus',
	            displayField:'value',
	            valueField:'id',
	            forceSelection:true,
	            typeAhead:true,
	            minChars:3,
	            fieldLabel:getExaminationTranslation('MARK_ENTRY_STATUS')
            }]
		}]
	},{
	    	xtype: 'fieldcontainer',
	        layout: 'hbox',
	        defaults: {
	            width: 226,
	            labelAlign: 'top'
	        },
	        items: []
     },{
		    xtype: 'fieldcontainer',
	        width:'100%',
	        cls:'windowBtnPos',
	        items: [{
	            xtype: 'button',
	            itemId:'searchBtn',
	            text: getCommonTranslation('SEARCH'),
	            ui: 'CustomBtnSubmit',
	            scale: CONSTANTS.BUTTONSIZE,
	            formBind:true
	        },{
	            xtype: 'button',
	            text: getCommonTranslation('RESET'),
	            itemId:'resetBtn',
	            ui: 'CustomBtnCancel',
	            scale: CONSTANTS.BUTTONSIZE
	        },{
				xtype: 'button',
				itemId: 'spBtnMoreActionsHierarchy',
				name:'spBtnMoreActionsHierarchy',
				disabled:true,
				text: getExaminationTranslation('MANAGE_HIERARCHY_STATUS'),
				ui:'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
   }]
});