	/**
	 * @author bhanu ps
	 */
	Ext.define('Academia.view.examinationcenters.evalution.CourseMappingTabView', {
	  //  extend: 'Ext.grid.Panel',
		extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
		alias: 'widget.coursemappingtabview',
	    store: 'examinationcenters.evaluation.coverageDetails.CourseCoverageStore',
	    title: getExaminationTranslation('MAPPED_COURSE'),
	    border: true,
	    autoScroll: false,
	  //  maxHeight: 700,
	    frame:false,
	    viewConfig: {
	        stripeRows: CONSTANTS.STRIPROWS,
	    },
	    headerFix: {
			headerFix: true,
			portalIdsWithStructure: {
				'coursemappingtab': 1
			}
		},
	    selType:'checkboxmodel',
	    selModel: {
	    	mode:'MULTI',
	    	showHeaderCheckbox: true,
	    	allowDeselect: false,
	    	checkOnly : true
	    },
	     listeners:{
    	beforeselect:function(selModel,record,index){
    		if(!isNullOrEmpty(selModel.view.up())){
				var grid = selModel.view.up();
    			var gridItemId = grid.getItemId();
    			
    			try{
	    			var isViewOnly = Ext.ComponentQuery.query('contentPanel')[0].getActiveTab().down('evaluationplanbasicdetailform').isViewOnly;
	    			if(isViewOnly == true){
						return false;
					}
				}
				catch(e){
					//--
				}				   			
    		}
    	}
    },
	    dockedItems: [{
	    	xtype : 'toolbar',
	    	dock : 'bottom',
	    	items : [ {
	    	    xtype : 'custompagingtoolbar',
	    	    plugins:['pagesize'],
	    	    store : 'examinationcenters.evaluation.coverageDetails.CourseCoverageStore',
	    	    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	    	    displayInfo : true
	    	} ]
	        }],
	        initComponent: function() {

	            var grid=this;                   

	            grid.addExportToolBarItems(grid);

	            this.callParent(arguments);     

	     },
	    tbar: [{
	        xtype: 'button',
	        itemId: 'btnAdd',
	        tooltip: getCommonTranslation('ADD'),
	        glyph: ICONGLYPH.ADDGLYPH
	    }, {
	        xtype: 'button',
	        itemId: 'btnEdit',
	        hidden:true,
	        tooltip: getCommonTranslation('EDIT'),
	        glyph: ICONGLYPH.EDITGLYPH
	    }, {
	        xtype: 'button',
	        itemId: 'btnDelete',
	        cls: 'CustomToolbarBtnReject',
	        tooltip: getCommonTranslation('DELETE'),
	        glyph: ICONGLYPH.DELETEGLYPH
	    }],
	    columns: [{
	        header: getExaminationTranslation('COURSE_CODE'),
	        dataIndex: 'courseCode',
	        flex:.1,
	        sortable:true
	    }, {
	        header: getExaminationTranslation('COURSE_NAME'),
	        dataIndex: 'courseName',
	        flex:.1,
	        sortable: true
	    }, /*{
	        header: getExaminationTranslation('PRIMERY_COURSE'),
	        dataIndex: 'isPrimaryCourse',
	        flex:.1,
	        sortable: true,
	        renderer:function(value,meta,record){
				if(!isNullOrEmpty(value)) {
					if(value){
						return "<span style='color:green'>Yes</span>"; 
					}else {
						return "<span style='color:red'>No</span>"; 
					}
					
				}                        
			} 
	     },*/ {
	         header: getExaminationTranslation('MARKING_TYPE'),
	         dataIndex: 'markingType',
	         flex:.1,
	          sortable: true,
	          renderer:function(value,meta,record){
					if(!isNullOrEmpty(value)) {
						if(value=="M"){
							return "Marks"; 
						}else if(value=="G") {
							return "Grade"; 
						}
						
					}                        
				} 
	      }]
	});