/**
 * @author bhanu ps
 */
Ext.define('Academia.view.examinationcenters.examinationRemark.AddRemarkWin', {
	extend: 'Ext.window.Window',
	alias: 'widget.addremarkwin',
	modal: true,
	autoScroll:true,
	title: getExaminationTranslation('REMARK'),
	maxHeight:500,
	width: 300,
	height:'25%',
	items: [{
		xtype: 'form',
		method: 'POST',
		margin: 0,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			autoScroll:false,
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items: [{
				xtype: 'textfield',
				fieldLabel: getExaminationTranslation('REMARK'),
				name: 'remarkName',
				itemId: 'remarkItemId',
				allowBlank:false,
				maxLength:2048
			}]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items: [{
				 	xtype: 'customcombobox',
		 			name:'courseId',
		 			itemId:'course_Id',
		 			store: 'examinationcenters.dashboard.CourseForExaminationRemark',
		 			fieldLabel: getCommonTranslation("COURSE_CODE_NAME"), //V2D-409459 label Changes  
		 			valueField: 'id',
		 			displayField:'valueCode',   
		 			queryParam:'name',
		 			minChars:3,
		 			typeAhead:false,
		 			matchFieldWidth:true,
		 			hidden:true,
		 			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		 			enableKeyEvents  : 'true',
		 			hideTrigger:false,
		 			forceSelection:true,
		 			width:226,
		 			allowBlank:false,
		 			emptyText: getCommonTranslation("ENTER_THREE_CHAR"),
					
		 			listConfig: {
						
		 				listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		 				loadingText: getCommonTranslation("SEARCHING"),
		 				emptyText: getCommonTranslation("NO_RECORDS_FOUND"),
		 				getInnerTpl: function() {
		 					return '<div class="search-item">' +
		 					'{courseId}' +
		 					'</div>';
		 				}
		 			}
		        }]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items: [{
				 	xtype: 'customcombobox',
		 			name:'program',
		 			itemId:'program_Id',
		 			store: 'facilitiesresources.resourcemaster.ProgramGridStore',
		 			fieldLabel: getPersonModuleTranslation('PROGRAM'),
		 			valueField: 'id',
		 			displayField: 'value',
		 			queryParam:'qry',
		 			minChars:3,
		 			typeAhead:false,
		 			hidden:true,
		 			matchFieldWidth:true,
		 			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		 			enableKeyEvents  : 'true',
		 			hideTrigger:false,
		 			forceSelection:true,
		 			width:226,
		 			allowBlank:false,
		 			emptyText: getCommonTranslation("ENTER_THREE_CHAR"),
		 			listConfig: {
		 				listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		 				loadingText: getCommonTranslation("SEARCHING"),
		 				emptyText: getCommonTranslation("NO_RECORDS_FOUND"),
		 				getInnerTpl: function() {
		 					return '<div class="search-item">' +
		 					'{courseId}' +
		 					'</div>';
		 				}
		 			}
		        }]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items: [{
				xtype: 'customcombobox',
				name:'evalautionPlanNo',
				itemId:'evalautionPlanNoItemId',
				store:'examinationcenters.dashboard.EvaluationPlanByAcademyAndEvalType', //evaluationPlanType
				fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'evaluationPlanNumber',
				minChars:3,
				typeAhead:false,
				allowBlank:false,
				matchFieldWidth:true,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation("ENTER_THREE_CHAR"),
				listConfig: {
					loadingText: getCommonTranslation("SEARCHING"),
					emptyText: getCommonTranslation("NO_RECORDS_FOUND"),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					},
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			width: '100%',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SUBMIT'),
				itemId: 'submitButtonId',
				buttonAlign: 'right',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'cancelButtonId',
				scale: CONSTANTS.BUTTONSIZE

			}]
		}]
	}]
});