/**
 * @author Bhanu PS
 */
Ext.define('Academia.view.examinationcenters.examlogistic.PlanLogisticFilter', {
	extend: 'Ext.form.Panel',
    alias: 'widget.planlogisticfilter',
    autoScroll: false,   
    frame: false,
	cls:'customSearchPanel',
    plugins : "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        width: '100%',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'multiselectcombofield',
            name: 'academyLocation',
            itemId: 'academyLocationIdExamAttend',
            autoloadStore: false,
            width: 460,
            fieldLabel: getProgramandcourseTranslation('ACADEMY_LOCATION'),
            store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
            valueField: 'id',
            displayField: 'value',
            editable: false,
            typeAhead: false,
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            cls: 'commonAutoHeightMultiselectField resetPasswordMultiselect',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
      	  	allowBlank:false,
            emptyText: getCommonTranslation('PLEASE_SELECT_DROPDOWN_VALUE'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    },
                    afterRender: function (combo) {
                        combo.getStore().on("load", function (store, items) {
                            try {
                                if (items.length == 0)
                                    Ext.select('.x-boundlist-item').elements[0].hidden = true;
                                else
                                    Ext.select('.x-boundlist-item').elements[0].hidden = false;
                            } catch (err) {
                                console.log(err);
                            }
                        });
                    }
                },
                cls: 'combo-word-break-all',
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{code}' +
                        '</div>';
                }
            },
        }]
    },{
            	xtype: 'fieldcontainer',
            	layout: 'hbox',
            	defaults: {
            		width: 226,
            		labelAlign: 'top'
            	},
            	items: [{
  	        	  xtype : 'customcombobox',
	        	  name : 'evaluationPlanType',
	        	  itemId:'evaluationType_Id',
	        	  fieldLabel : getExaminationTranslation('EVALUATION_PLAN_TYPE'),
	        	  store : 'examCenter.AssignSequence.EvaluationType',
	        	  valueField : 'id',
	        	  displayField : 'value',
	        	  allowBlank:false
	          },{
	        	  xtype : 'customcombobox',
	        	  name : 'evaluationStage',
	        	  itemId:'evaluationStageItemId',
	        	  fieldLabel : getExaminationTranslation('EVALUATION_STAGE'),
	        	  store : 'examinationcenters.CenterUseFor',
	        	  valueField : 'id',
	        	  displayField : 'value',
	        	  allowBlank:false
	          },{
	              xtype: 'customcombobox',
	              fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
	              name: 'academicTerm',
	              itemId: 'academicTermExamAttend', 
	              displayField: 'value',
	              valueField: 'id',
	              typeAhead: true,
	              forceSelection: true,
	        	  allowBlank:false,
	              listeners: {
	                  render: function (combo) {
	                      var store = Ext.create('Academia.store.common.AcademicTermStore');
	                      combo.bindStore(store);
	                  }
	              }
	          },{
					xtype: 'customcombobox',
					name: 'courseId',
					itemId: 'courseItemId',
					store:Ext.create('Academia.store.attendance.ExamAttendanceCourseStore'),
//					store:'examinationcenters.reports.ExaminationReportCourseStore',
					fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
					valueField: 'id',
					displayField: 'value',
					queryParam:'courseName',
					minChars:3,
//					width:460,
					typeAhead:false,
					allowBlank:false,
					//triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					triggerAction: '',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
								picker.maxWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
				},{
		        	xtype: 'customcombobox',
		  			name:'programId',
		  			itemId:'programIdQuickFiltr',
		  			store: Ext.create('Academia.store.exam.importMarkRemark.ProgramForOtherStore'),
		  			fieldLabel:getExaminationTranslation('PROGRAM'),
		  			valueField: 'id',
		  			displayField: 'value',
		  			queryParam:'name',
		  			minChars:3,
		  			//width:460,
		  			typeAhead:false,
		  			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
		  			enableKeyEvents  : 'true',
		  			hideTrigger:false,
		  			forceSelection:true,
		  			disable:true,
		  			//allowBlank:false,
		  			hidden:true,
		  			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		  			listConfig: {
		  				listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
								picker.maxWidth = picker.up('combobox').getSize().width;
							}
						},
		  				loadingText: getCommonTranslation('SEARCHING'),
		  				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		  				getInnerTpl: function() {
		  					return '<div class="search-item">' +
		  					'{value}' +
		  					'</div>';
		  				}
		  			}
				}]
            },{
            	xtype: 'fieldcontainer',
            	layout: 'hbox',
            	defaults: {
            		width: 226,
            		labelAlign: 'top'
            	},
            	items: [{
	                xtype: 'customcombobox',
	                name: 'batchId',
	            	itemId:'batchIdQuickFiltr',
	                store:'common.CurrentBatchStore',
	                displayField:'value',
	                valueField:'id',
	                disabled:true,
		            typeAhead:true,
		            hidden:true,
		            fieldLabel:getExaminationTranslation('BATCH')
	            },{
	            	xtype: 'customcombobox',
	                name: 'periodId',
	            	itemId:'periodIdQuickFiltr',
	                store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
	                displayField:'value',
	                valueField:'id',
	                disabled:true,
		            typeAhead:true,
		            hidden:true,
		            fieldLabel:getExaminationTranslation('PERIOD')
	            },{
	            	xtype: 'customcombobox',
	                name: 'sectionId',
	            	itemId:'sectionIdQuickFiltr',
	                store:'coursetransaction.sectionmanagement.SectionsStore',
	                displayField:'value',
	                valueField:'id',
	                disabled:true,
		            typeAhead:true,
		            hidden:true,
		            fieldLabel:getExaminationTranslation('SECTION')
	            }]
            },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		width: 226,
    		labelAlign: 'top'
    	},
    	items: [{
        	xtype: 'multiselectcombofield',
            name: 'courseVariant',
            itemId:'courseVariantItemId',
//            store:'examinationcenters.reports.ExaminationReportCVStore',
            store:Ext.create('Academia.store.attendance.VariantMappedToPlan'),
            displayField:'value',
			valueField:'id',
			queryParam:'name',
            width:226,
            minChars:3,
            typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			disabled:true,
			cls: 'MEAcourseVariantCls',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					},
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			},
            allowBlank:false,
            fieldLabel:getExaminationTranslation('COURSE_VARIANT')
        },{
			xtype: 'customcombobox',
			name: 'evaluationPlanId',
			itemId: 'evaluationPlanItemId',
			store:'examinationcenters.reports.ExaminationReportEPStore',
			fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			width:226,
			typeAhead:false,
			allowBlank:false,
			disabled:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
            xtype: 'groupingcombobox',
            name: 'evalPlanLevelId',
            itemId:'evalPlanLevelItemId',
            labelAlign:'top',
           // queryMode: 'local',
            groupField: 'code',
            groupDisplayField: 'code',
            //store: Ext.create('Academia.store.examinationcenters.examresultpublish.BulkExamResultPublishEvalPlanLevelStore'),
            store: Ext.create('Academia.store.examinationcenters.remark.EvaluationPlanLevelByEvaluationPlanId'),
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
            displayField: 'value',
           // valueField: 'id' ,
            minChar : 3,
			disabled:true,
            forceSelection:true,
            allowBlank:false,
            //emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        },{
			xtype: 'customcombobox',
			name: 'eventId',
			itemId: 'eventItemId',
			store:Ext.create('Academia.store.examinationcenters.manageEvaluation.EvaluationEventByEvalPlan'),
			fieldLabel:getExaminationTranslation('DETAILED_SEQUENCE'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'query',
			minChars:3,
			width:226,
			allowBlank:false,
			disabled:true,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.maxWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
    },{
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			// buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		},{
            xtype: 'button',
            text: getExaminationTranslation('GENERATE_REPORT'),
            itemId:'generateReport',
            ui: 'CustomBtnThird',
//            disabled:true,
            scale: CONSTANTS.BUTTONSIZE,
            formBind:true
		}]	
	}]
});