Ext.define('Academia.view.examinationcenters.manageEvaluation.ImportMapUnmapStudentFilter', {
    extend: 'Academia.view.common.DynamicFieldForm',
    alias: 'widget.importmapunmapstudentfilter',
    margin: '-16 10 8 0',
    autoScroll: false,
    frame: false,
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'assessmentSchemeType',
            itemId: 'importMapUnmapEvaluationTypeItemId',
            store: Ext.create('Academia.store.examCenter.AssignSequence.ImportMapUnmpStudentEvaluationType'),
            displayField: 'value',
            valueField: 'id',
            forceSelection: true,
            editable: false,
            typeAhead: true,
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN_TYPE'),
            allowBlank: false
        }, {
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
            name: 'academicTermId',
            itemId: 'importMapUnmapAcademicTermId',
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            minChars: 3,
            store: Ext.create('Academia.store.common.ImportMapUnmpStudentAcademicTermStoreForIntakeYearId'),
            typeAhead: true,
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
            allowBlank: false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' + '{value}' + '</div>';
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'assessmentSchemeId',
            itemId: 'importMapUnmapEvalautionPlanItemId',
            store: Ext.create('Academia.store.examinationcenters.evaluationgroup.detailsequencecovered.ImportMapUnmpStudentEvaluationPlanByCriteria'),
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN'),
            valueField: 'id',
            width: 226,
            displayField: 'value',
            queryParam: 'evaluationPlanNumber',
            minChars: 3,
            typeAhead: false,
            disabled: false,
            allowBlank: false,
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [ {
            xtype: 'customcombobox',
            name: 'courseId',
            itemId: 'importMapUnmapCourseItemId',
            store: Ext.create('Academia.store.attendance.ImportMapUnmpStudentCoursesForVariantMapping'),
            fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
            valueField: 'id',
            displayField: 'value',
            queryParam: 'courseName',
            minChars: 3,
            width: 226,
            typeAhead: true,
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            triggerAction: '',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
            disabled: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        },{
			xtype: 'multiselectcombofield',
			//addAllSelector: false,
			name: 'importMapUnmapCourseVariant',
			itemId:'importMapUnmapCourseVariantItemId',
			store: Ext.create('Academia.store.attendance.ImportMapUnmpStudentCourseVariantMappedToPlanTemplate'),
	        displayField: 'value',
	        valueField: 'id',
	        width: 462,
	        maxLength: 9999,
	        maxSelections: 9999,
	        forceSelection: true,
	        allowBlank: false,
	        typeAhead: false,
	        editable:false,
	        disabled:true,
	        submitValue: false,
	        autoloadStore: false,
	        triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
	        //emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	        cls:'commonAutoHeightMultiselectField resetPasswordMultiselect',
			fieldLabel:getExaminationTranslation('COURSE_VARIANT'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.maxWidth = picker.up('combobox').getSize().width;
					},
					refresh: function( boundList, eOpts ){
						try{
							var combo = boundList.up('combo');
							try{
								var isDynamic = combo.up('form').down('#importMapUnmapDetailSequenceItemId').getStore().getProxy().extraParams.isDynamicScheme;
							}
							catch(e){
								var isDynamic = false;
							}
							if(isDynamic==true || isDynamic=="true"){
								var newValue = combo.getValue();
								if(!isNullOrEmpty(newValue[0])){
									var allItems = combo.listKeyNav.boundList.all.elements;
									var selectedVariantId = 0;
									var selectedCourseId = 0;
									var comboStore = combo.getStore();
									if(typeof combo.getValue() == "string"){
										selectedVariantId = combo.getValue();
									}
									else{
										selectedVariantId = combo.getValue()[0].get('id');
									}
									if(selectedVariantId){
										var selectedRecord = comboStore.findRecord('id',selectedVariantId);
										var selectedCourseId = selectedRecord.get('courseId');
									}
									Ext.each(allItems, function(currentItem){
										var currentCourseVariantId = currentItem.viewRecordId;
										var currentCourseVariantRecord = comboStore.findRecord('id',currentCourseVariantId);
										if(currentCourseVariantRecord.get('courseId') == selectedCourseId){
											currentItem.classList.remove("disabledComboItem")
										}
										else{
											currentItem.classList.add("disabledComboItem");
										}
									});
								}
							}
						}
						catch(e){
							console.log(e);
						}
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			},
			listeners:{
				beforeselect:function(selModel,record,index){
					var combo = selModel.view.field;
					try{
						var isDynamic = combo.up('form').down('#importMapUnmapDetailSequenceItemId').getStore().getProxy().extraParams.isDynamicScheme;
					}
					catch(e){
						var isDynamic = false;
					}
					if(isDynamic==true || isDynamic=="true"){
						if(!isNullOrEmpty(combo.getValue()) && combo.getValue() != "") {
							var value = combo.getValue();
							if(value[0].data.courseId != record.data.courseId){
								return false;
							}
						}
					}
					else{
						return true;
					}
				},
				change: function(combo, newValue, oldValue, eOpt){
					var allItems = combo.listKeyNav.boundList.all.elements;
					var selectedVariantId = 0;
					var selectedCourseId = 0;
					var comboStore = combo.getStore();
					try{
						var isDynamic = combo.up('form').down('#importMapUnmapDetailSequenceItemId').getStore().getProxy().extraParams.isDynamicScheme;
					}
					catch(e){
						var isDynamic = false;
					}
					if(isDynamic==true || isDynamic=="true"){
						if(typeof combo.getValue() == "string"){
							selectedVariantId = combo.getValue();
						}
						else{
							selectedVariantId = combo.getValue()[0];
						}
						if(!isNullOrEmpty(selectedVariantId)){
							if(selectedVariantId){
								var selectedRecord = comboStore.findRecord('id',selectedVariantId);
								var selectedCourseId = selectedRecord.get('courseId');
							}
							Ext.each(allItems, function(currentItem){
								var currentCourseVariantId = currentItem.viewRecordId;
								var currentCourseVariantRecord = comboStore.findRecord('id',currentCourseVariantId);
								if(currentCourseVariantRecord.get('courseId') == selectedCourseId){
									currentItem.classList.remove("disabledComboItem")
								}
								else{
									currentItem.classList.add("disabledComboItem");
								}
							});
						}
					}
				}
			}
		},
		{
        	xtype: 'hidden',
        	name: 'courseVariantIds'
        }, {
			xtype: 'customcombobox',
			name:'programId',
			itemId:'importMapUnmapProgramIdQuickFiltr',
			store: Ext.create('Academia.store.exam.importMarkRemark.ProgramForOtherStore'),
			fieldLabel:getExaminationTranslation('PROGRAM'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'programName',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			autoloadStore: false,
			forceSelection:true,
			hidden:true,
			disabled:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}  
		},{
			xtype: 'customcombobox',
			name: 'batchId',
			itemId:'importMapUnmapBatchIdQuickFiltr',
			store: Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationBatchStore'),
			displayField:'value',
			queryParam:'batchName',
			minChars:3,
			valueField:'id',
			typeAhead:true,
			hidden:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}  ,
			disabled:true,
			forceSelection:true,
			fieldLabel:getExaminationTranslation('BATCH'),
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId:'importMapUnmapPeriodIdQuickFiltr',
			store:Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationPeriodStore'),
			displayField:'value',
			valueField:'id',
			typeAhead:true,
			disabled:true,
			hidden:true,
			forceSelection:true,
			fieldLabel:getExaminationTranslation('PERIOD')
		}]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'hidden',
            name: 'evaluationEventStatus'
        }, {
            xtype: 'hidden',
            name: 'isDynamicScheme'
        }, {
			xtype: 'multiselectcombofield',
			name: 'sectionIds',
			itemId:'importMapUnmapSectionIdQuickFiltr',
			store: Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.EvaluationSectionTemplateStore'),
			displayField:'value',
			valueField:'id',
			disabled:true,
			width: 226,
			typeAhead:true,
			hidden:true,
			fieldLabel:getExaminationTranslation('SECTION'),
			submitValue: false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}, {
            xtype: 'hidden',
            name: 'sectionId'
        }, {
            xtype: 'groupingcombobox',
            name: 'assessmentSchemeLevelId',
            itemId: 'importMapUnmapEvalPlanLevelItemId',
            labelAlign: 'top',
            groupField: 'code',
            groupDisplayField: 'code',
            store: Ext.create('Academia.store.examinationcenters.remark.ImportMapUnmpStudentEvaluationPlanLevelByEvaluationPlanId'),
            fieldLabel: getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
            displayField: 'value',
            valueField: 'levelId',
            minChar: 3,
            disabled: true,
            forceSelection: true
        }, {
            xtype: 'customcombobox',
            name: 'assessmentEventId',
            itemId: 'importMapUnmapDetailSequenceItemId',
            store: Ext.create('Academia.store.examinationcenters.manageEvaluation.EvaluationEventForImportMarkRemark'),
            displayField: 'value',
            valueField: 'id',
            forceSelection: true,
            editable: false,
            typeAhead: true,
            disabled: true,
            fieldLabel: getExaminationTranslation('DETAILED_SEQUENCE'),
            allowBlank: false
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'validationOn',
            itemId: 'importMapUnmapValiationOn',
            store: Ext.create('Ext.data.Store', {
            	fields: ['id', 'value'],
            	data: [{
            		id: 'ADMISSION_CODE',
            		value: getExaminationTranslation('IMPORT_MARK_REMARK_ADMISSION_CODE')
            	}, {
            		id: 'STUDENT_CODE',
            		value: getExaminationTranslation('IMPORT_MARK_REMARK_STUDENT_CODE')
            	}, {
            		id: 'EXTERNAL_REFERENCE',
            		value: getExaminationTranslation('IMPORT_MARK_REMARK_EXTERNAL_REFERENCE_1')
            	}]
            }),
            displayField: 'value',
            valueField: 'id',
            forceSelection: true,
            editable: false,
            fieldLabel: getExaminationTranslation('VALIDATION_ON'),
            allowBlank: false
        }, {
            xtype: 'customcombobox',
            name: 'importUtilityMasterId',
            itemId: 'importMapUnmapModuleName',
            store: 'importutility.importMapUnmapStudentModuleName',
            fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
            valueField: 'id',
            displayField: 'value',
            typeAhead: true,
            forceSelection: true,
            allowBlank: false,
            readOnly: true
        }]
    }, {
        xtype: 'filefield',
        ui: 'CustomBtnThird',
        width: 460,
        fieldLabel: getCommonTranslation('UPLOAD_FILE'),
        labelAlign: 'top',
        buttonText: getCommonTranslation('BROWSE_FILE'),
        itemId: 'importMapUnmapUploadFileField',
        name: 'file',
        allowBlank: false,
        validateOnChange: true,
        listeners: {
            change: function (fileField, value) {
                value = value.replace('C:\\fakepath\\', '');
                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                fileField.setRawValue(newValue);
                if (!isNullOrEmpty(newValue)) {
                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                    var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
                    if (!baseController.isValidFileExtensionForLoader(extension)) {
                        fileField.reset();
                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
                    }
                }
            }
        }
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        cls: 'windowBtnPos',
        items: [{
            xtype: 'button',
            action: 'Submit',
            text: getTranslation('UPLOAD_DATA'),
            formBind: true,
            itemId: 'mapUnmapUpload',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetBtn',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }, {
    	html: '<b><span style="color: red;">' + getCommonTranslation('NOTE') + ': </span>' + getExaminationTranslation('IMPORT_MAP_UNMAP_NOTE') + '</b>',
    	margin: '8 10 0 -6',
    	cls: 'note-section'
    }]
});