/**
 * @author Amit G
 */

 
Ext.define('Academia.view.examinationcenters.markgrade.markgradedetail.VWExamTransformStudentDetailWindow', {
	extend : 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.vwexamtransformstudentdetailwindow',
	modal : true,
	itemId : 'vwexamtransformstudentdetailwindow',
	border:true,
	autoScroll: false,
	title:getExaminationTranslation('NUMBER_OF_STUDENTS'),
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'examinationcenters.markgrade.StoMarkBasedTransformStudentGridStore',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments); 
        
    },
	columns: [{
		header : getCommonTranslation('GRADE'),
		dataIndex : 'grade',
		flex : .2,
		renderer:function(val){
			if(!isNullOrEmpty(val)){
				return val;
			}
		}
	}, {
		header : getCommonTranslation('GRADE_POINT'),
		dataIndex : 'gradePoint',
		flex : .2,
		renderer:function(val){
			if(!isNullOrEmpty(val)){
				return val;
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('ADMISSION_ID'),
		dataIndex : 'admissionCode',
		flex : .3,
		renderer:function(val){
			if(!isNullOrEmpty(val)){
				return val;
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex : .3,
		renderer:function(val){
			if(!isNullOrEmpty(val)){
				return val;
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex : .5,
		renderer:function(value){
			if(!isNullOrEmpty(value)){
				return value;
			}
		}
	}]
});
