/**
 * Abhishek Chouhan
 */
Ext.define('Academia.view.examinationcenters.markgrade.markgradedetail.resultstatistic.GradeDistributionDetailsGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.gradedistributiondetailsgrid',
    store: 'examinationcenters.markgrade.GradeMasterDetailsStore',
    border: true,
    autoScroll: false,
    //title: getExaminationTranslation('LIST_OF_STUDENT_WITH_GRADES'),
    frame:false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			    store : 'examinationcenters.markgrade.GradeMasterDetailsStore',
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
    columns: [{
        header: getExaminationTranslation('GRADE_NAME'),
        dataIndex: 'grade',
        flex:1,
        sortable:true
    }, {
        header: getExaminationTranslation('MARKS_FROM'),
        dataIndex: 'markRangeFrom',
        flex:1,
        sortable: true,
        renderer  : Ext.util.Format.numberRenderer('0.00')
    }, {
        header: getExaminationTranslation('MARKS_TO'),
        dataIndex: 'markRangeTo',
        flex:1,
        sortable: true,
        renderer  : Ext.util.Format.numberRenderer('0.00')
    }, {
        header: getExaminationTranslation('GRADE_POINT'),
        dataIndex: 'gradePoint',
        flex:1,
        sortable: true
    }, {
        header: getExaminationTranslation('NO_OF_STUDENT'),
        dataIndex: 'studentCount',
        flex:1,
        sortable: true
    },  {
        header: getExaminationTranslation('GRADE_POINT_DISTRIBUTION'),
        dataIndex: 'distributionPoint',
        flex:1,
        sortable: true,
        renderer:function(value,record){
			if(!isNullOrEmpty(record.record.data.studentCount)){
				return record.record.data.studentCount*record.record.data.gradePoint;
			}else{
				return "-";
			}
			
		} 
    }]
});
