/**
 * @author sumit.meena
 */
Ext.define('Academia.view.examinationcenters.marksheet.MarksheetGenerationFilter', {
	extend: 'Ext.form.Panel',
    alias: 'widget.marksheetgenerationfilter',
    autoScroll: false,
    frame: false,
	cls:'customSearchPanel',
    plugins : "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		labelAlign: 'top'
    	},
        items: [{
        	xtype:'displayfield',
        	value:'<b>'+getExaminationTranslation('MARKSHEET_SETUP_DETAILS') +'</b>'
        }]		
    	},{
	        xtype: 'fieldcontainer',
        	layout: 'hbox',
        	defaults: {
        		width: 226,
        		labelAlign: 'top'
        	},
        	items: [{
        		xtype:'hidden',
        		name:'marksheetJobId'
        	},{
        		xtype: 'textfield',
        		name: 'jobName',
        		itemId:'marksheetJobItemId',
        		allowBlank:false,
        		fieldLabel:getExaminationTranslation('JOB_NAME'),
        		maxLength : 255
        	},{
        		xtype: 'textfield',
        		name: 'jobId',
        		itemId:'jobItemId',
        		allowBlank:false,
        		fieldLabel:getExaminationTranslation('MARKSHEET_LEVEL_NAME'),
        		maxLength : 255
        	},{
            	xtype: 'customcombobox',
        		name: 'consolidatedField',
        		itemId:'consolidatedItemId',
        		store: 'examinationcenters.YesNo',
        		displayField:'value',
        		valueField:'id',
        		forceSelection:true,
        		typeAhead:true,
        		minChars:3,
        		//allowBlank:false,
        		//disabled:true,
        		fieldLabel:getExaminationTranslation('WHETHER_CONSOLIDATED')
            }]
        },{
	        xtype: 'fieldcontainer',
        	layout: 'hbox',
        	defaults: {
        		labelAlign: 'top',
        		width:226
        	},
            items: [{
                xtype: 'radiogroup',
                itemId: 'whetherFixedDate',
                columns: 2,
                width: 550,
                vertical: false,
                layout: {
                    type: 'hbox'
                },
                items: [{
                    boxLabel: getExaminationTranslation('FIXED_DATE'),
                    inputValue: 'whetherFixedDateTrue',
                    name: 'whetherFixedDate'
                }, {
                    boxLabel: getExaminationTranslation('CURRENT_DATE'),
                    inputValue: 'whetherFixedDateFalse',
                    name: 'whetherFixedDate'
                }]
            }]		
        },{
	        xtype: 'fieldcontainer',
        	layout: 'hbox',
        	hidden: true,
        	itemId: 'dateFieldContainerItemId',
        	defaults: {
        		labelAlign: 'top',
        		width:226
        	},
            items: [{
            	xtype: 'datefield',
            	name: 'resultDate',
            	itemId:'resultDateItemId',
            	//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
//            	format:CONSTANTS.DATE_FORMAT,
                allowBlank:false,
//                value : new Date(),
                fieldLabel:getExaminationTranslation('RESULT_DEC_DATE'),
                listeners: {
                	render: function(obj) {
                		obj = dateFormatRender(obj);						
                		obj.setValue(new Date());
                	}
                }
            },{
            	xtype: 'datefield',
            	name: 'publishDate',
            	itemId:'publishDateItemId',
            	//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
                allowBlank:false,
//                value : new Date(),
                fieldLabel:getExaminationTranslation('PUBLISH_DATE'),
                listeners: {
                	render: function(obj) {
                		obj = dateFormatRender(obj);						
                		obj.setValue(new Date());
                	}
                }
            }]		
        },
        {
	        xtype: 'fieldcontainer',
        	layout: 'hbox',
        	defaults: {
        		labelAlign: 'top'
        	},
            items: [{
    			xtype: 'textarea',
    			name: 'additionalParameters',
    			itemId:'additionalParameters',
    			fieldLabel:getExaminationTranslation('ADDITIONAL_PARAMETERS_FOR_PRINT'),
    			//height:80,
    			width: 460,
    		    emptyText: getCommonTranslation('MARKSHEET_ADDITIONAL_PARAMETER_PLACEHOLDER')
    		}]		
        },{
            xtype: 'fieldcontainer',
        	layout: 'hbox',
        	defaults: {
        		width: 226,
        		labelAlign: 'top'
        	},
            	items: [{
        			xtype: 'customcombobox',
        			name:'marksheetFilePattern',
        			itemId:'marksheetFilePatternId',
        			store:'examinationcenters.marksheet.MarksheetFilePatternStore',
        			fieldLabel:getExaminationTranslation('MARKSHEET_FILE_PATTERN'),
        			valueField: 'id',
        			displayField: 'value',
        			forceSelection:true,
        			width: 460,
        			typeAhead:false,
        			allowBlank:false,
        			listConfig: {
        				loadingText: getCommonTranslation('SEARCHING'),
        				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        				getInnerTpl: function() {
        					return '<div class="search-item">' +
        					'{value}' +
        					'</div>';
        				},
        				listeners: {
        					beforeshow: function(picker) {
        						picker.minWidth = picker.up('combobox').getSize().width;
        					}
        				},
        			}
            	}]
         },{
    		xtype: 'fieldcontainer',
    		width: 'auto',
    		items: [{
    			xtype: 'button',
    			text: getExaminationTranslation('SAVE'),
    			itemId: 'saveItemId',
    			buttonAlign: 'left',
    			ui: 'CustomBtnSubmit',
    			scale: CONSTANTS.BUTTONSIZE,
    		//	formBind:true
    		}/*,{
    			xtype: 'button',
    			text: getCommonTranslation('RESET'),
    			itemId: 'resetItemId',
    			ui: 'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE   
    		}*/]	
    	},{
	        xtype: 'fieldcontainer',
        	layout: 'hbox',
        	defaults: {
        		labelAlign: 'top'
        	},
            items: [{
	        	xtype:'displayfield',
	        	value:'<h4>'+getExaminationTranslation('SELECT_EVALUATION_PLAN_LEVEL_FOR_MARKSHEET_PRINTING') +'</h4>'
            }]		
        },{
	        xtype: 'fieldcontainer',
        	layout: 'hbox',
        	defaults: {
        		width: 226,
        		labelAlign: 'top'
        	},
            items: [{
            	xtype: 'customcombobox',
            	itemId:'chooseMarksheetTemplate',
        		name: 'reportTemplateConfigurationId',
        	    store:'examinationcenters.marksheet.MarksheetTemplateStore',
        		displayField:'code',
        		valueField:'id',
        		forceSelection:true,
                queryParam:'templateName',
                triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
                enableKeyEvents  : 'true',
        		typeAhead:false,
                hideTrigger:false,
        		minChars:3,
        		width: 460,
        		allowBlank:false,
        		fieldLabel:getExaminationTranslation('CHOSSE_MARKSHEET_TEMPLATE'),
                emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code}' +
							'</div>';
						}
					}
            },{
        		xtype: 'button',
        		style:{
        			marginTop:'30px'
        		},
    			text:'Preview Template',
    			itemId: 'previewTemplateBtn',
    			buttonAlign: 'bottom',
    			ui: 'CustomBtnThird',
    			scale: CONSTANTS.BUTTONSIZE,
        	}]		
        },{
	        xtype: 'fieldcontainer',
        	layout: 'hbox',
        	defaults: {
        		width: 226,
        		labelAlign: 'top'
        	},
            	items: [{
            		xtype: 'customcombobox',
            		name: 'evaluationLevel',
            		itemId: 'evaluationLevelItemId',
            	    store:'examinationcenters.marksheet.EvaluationLevelType',
            		displayField:'value',
            		valueField:'id',
            		forceSelection:true,
            		typeAhead:true,
            		minChars:3,
            		fieldLabel:getExaminationTranslation('EVALUATION_PLAN_LEVEL'),
            		//disabled:true,
            		//allowBlank:false
            	},{
            		xtype: 'multiselectcombofield',
            		name: 'evalLevelName',
            	    store:'examinationcenters.marksheet.EvaluationLevelNameForPost',//changed get to post due to long data
            	    displayField:'value',
            		valueField:'id',
            		forceSelection:true,
            		//typeAhead:true,
            		//minChars:3,
            		fieldLabel:getExaminationTranslation('EVALUATION_LEVEL_NAME'),
            		width: 460,
            		maxLength:1000000,
            		autoloadStore: false,
            		allowBlank:false,
            		disabled:true,
            		matchFieldWidth: false
        		/*	listConfig: {
        				loadingText: getCommonTranslation('SEARCHING'),
        				getInnerTpl: function() {
        					return '<div class="search-item">' +
        					'{code}' +
        					'</div>';
        				},
        				listeners: {
        					beforeshow: function(picker) {
        						picker.minWidth = picker.up('combobox').getSize().width;
        						picker.width = 'auto';
        						setTimeout(function(){
        							picker.el.dom.style.width='auto';
        							picker.el.dom.style.minWidth = picker.up('combobox').getSize().width+'px';
        						},10);
        					}
        				},
        			}*/
            	/*},{
            		xtype: 'textfield',
            		name: 'marksheetLevel',
            		fieldLabel:getExaminationTranslation('MARKSHEET_LEVEL')*/
            	}]
    },
    {
        xtype: 'radiogroup',
        itemId: 'autoSchemeSelection',
        name: 'autoSchemeSelection',
        fieldLabel: getExaminationTranslation('AUTO_SCHEME_SELECTION'),
       // hidden: true, // This hides the radio group by default
        layout: 'hbox',
        defaults: {
            margin: '0 10 0 0' // Add a small margin between the buttons (right margin of 10px)
        },
        items: [
            {
                boxLabel: getExaminationTranslation('YES'),
                name: 'autoSchemeSelection',
                inputValue: true
            },
            {
                boxLabel: getExaminationTranslation('NO'),
                name: 'autoSchemeSelection',
                checked: true,
                inputValue: false
            }
        ]
    },
    {
        xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		labelAlign: 'top'
    	},
        items: [{
        	xtype:'displayfield',
        	value:'<h4>'+'</h4>'
        }]		
    },{
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			text: getExaminationTranslation('SAVE_TO_GENERATE_MARKSHEET'),
			itemId: 'saveBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		}/*,{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}*/]	
	}]
});
