4/**
 * @author sumit.meena
 */
Ext.define('Academia.view.examinationcenters.marksheet.student.MarksheetStudentFilter', {
	extend: 'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.marksheetstudentfilter',
    autoScroll: false,
    frame: false,
	cls:'customSearchPanel',
    plugins : "formlabelrequired",
    standardSubmit : false,
    modal: true,
    items: [{
	        xtype: 'fieldcontainer',
	    	layout: 'hbox',
	    	defaults: {
	    		width: 226,
	    		labelAlign: 'top'
	    	},
	        	items: [{
            		xtype: 'customcombobox',
					name:'programId',
					itemId:'programItemId',
					store:'common.ProgramStore',
					fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
					valueField: 'id',
					displayField: 'valueCode',
					queryParam:'programName',
					minChars:3,
					typeAhead:false,
					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					forceSelection:true,
					allowBlank:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
            	},{
            		xtype: 'customcombobox',
            		name: 'batchId',
            		itemId:'batchItemId',
            	    store:Ext.create('Academia.store.common.CurrentBatchStore'),
            		displayField:'value',
            		valueField:'id',
            		forceSelection:true,
            		typeAhead:true,
            		minChars:3,
					queryParam:'batchName',
            		fieldLabel:getExaminationTranslation('BATCH'),
            		disabled:true,
            		allowBlank:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
										listConfig: {
											listeners: {
												beforeshow: function(picker) {
													picker.minWidth = picker.up('combobox').getSize().width;
												}
											},
											loadingText: getCommonTranslation('SEARCHING'),
											emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
											getInnerTpl: function() {
												return '<div class="search-item">' +
												'{value}' +
												'</div>';
											} 
										}
            	},{
                	xtype: 'customcombobox',
            		name: 'consolidatedField',
            		itemId:'consolidatedItemId',
            		store: 'examinationcenters.YesNo',
            		displayField:'value',
            		valueField:'id',
            		disabled:true,
            		forceSelection:true,
            		typeAhead:true,
            		minChars:3,
            		allowBlank:false,
            		fieldLabel:getExaminationTranslation('WHETHER_CONSOLIDATED')
                }]
	   },{
	        xtype: 'fieldcontainer',
        	layout: 'hbox',
        	defaults: {
        		width: 226,
        		labelAlign: 'top'
        	},
            	items: [{
    				xtype: 'fieldcontainer',        
    				//width: 236,
    				itemId:'considerProgramTransferField',
    				hidden:true,
    				items:[{
    					xtype: 'radiogroup',
    					//style:{marginLeft:'-2px !important'},
    					itemId:'isConsiderProgramTransfer',
    					name:'isConsiderProgramTransfer',
    					labelAlign: 'top',
    					fieldLabel:getExaminationTranslation('CONSIDER_PROGRAM_TRANSFER'),
    					//columns: 2,
    					vertical: true,
    					items: [
    					        { boxLabel: getAdmissionTranslation('YES'), name: 'isConsiderProgramTransfer', inputValue: true,checked:true},
    					        { boxLabel: getAdmissionTranslation('NO'), name: 'isConsiderProgramTransfer', inputValue: false,}
    					        ]
    				},]
    			},{
            		xtype: 'customcombobox',
            		name: 'periodId',
            		itemId: 'periodItemId',
            		store:Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'),
            		displayField:'value',
            		valueField:'id',
            		forceSelection:true,
            		typeAhead:true,
            		minChars:3,
            		fieldLabel:getExaminationTranslation('PERIOD'),
            		disabled:true,
            		allowBlank:false
            	},{
	        		xtype: 'customcombobox',
					name:'marksheetJobName',
					itemId:'marksheetJobNameItemId',
					store: 'examinationcenters.marksheet.MarksheetJobIdCombo',
					fieldLabel: getExaminationTranslation('MARKSHEET_JOB_NAME'),
					valueField: 'id',
					displayField: 'value',
					queryParam:'jobName',
					minChars:3,
					typeAhead:false,
					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
	        	},{
	        		xtype: 'customcombobox',
	        		/**
	        		 * name and itemId for these fields should be marksheetSubLevelNameId, marksheetLevelNameItemId but due to old implementation, I am using old one.
	        		 * */
					name:'marksheetJobId',
					itemId:'marksheetJobItemId',
					store: 'examinationcenters.marksheet.MarksheetLevelsCombo',
					fieldLabel: getExaminationTranslation('MARKSHEET_LEVEL_NAME'),
					valueField: 'id',
					displayField: 'value',
					queryParam:'jobSubLevelName',
					minChars:3,
					typeAhead:false,
					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					enableKeyEvents  : 'true',
					hideTrigger:false,
					forceSelection:true,
					disabled:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
	        	},]
        },{
	        xtype: 'fieldcontainer',
        	layout: 'hbox',
        	defaults: {
        		width: 226,
        		labelAlign: 'top'
        	},
            	items: [{
            		xtype: 'multiselectcombofield',
            		name: 'sectionId',
            	    store:'attendance.SectionAndFacultyByPeriodID',
            		displayField:'sectionCode',
            		valueField:'sectionId',
            		forceSelection:true,
            		typeAhead:false,
            		editable:false,
      //      		cls:'placementProgramMultiselect',
            		fieldLabel:getExaminationTranslation('SECTION'),
            		style:{
            			height:'auto !important',
            			maxHeight: '115px !important'
            		},
            		width: 460,
            		autoloadStore: false,
            		disabled:true,
            		listConfig: {
    	  				listeners: {
    	 					beforeshow: function(picker) {
    	 						picker.minWidth = picker.up('combobox').getSize().width;
    	 					}
    	 				},
    	             }
            	},{
	        		xtype: 'customcombobox',
					name:'studentStatus',
					itemId:'studentStatus',
					fieldLabel: getExaminationTranslation('STUDENT_STATUS'),
					minChars:3,
					typeAhead:false,
					value:true,
					 valueField: 'value',
	                 displayField: 'name',
					forceSelection:true,
					store:'common.picklist.StudentActiveInactiveStatusStoreForMarkSheet',
					disabled:false,
	        	}, {
            		xtype: 'customcombobox',
					name:'admissionStatus',
					itemId:'admissionStatus',
					store: Ext.create('Ext.data.Store', {
					    fields: ['id', 'valueCode'],
					    data: [{
							id: 'all',
							valueCode: 'All'
						}, {
							id: 'ACTIVE',
							valueCode: 'Active'
						}, {
							id: 'INACTIVE',
							valueCode: 'Inactive'
						}]
					}),
					value: 'all',
					fieldLabel:getCommonTranslation('ADMISSION_STATUS'),
					valueField: 'id',
					displayField: 'valueCode',
					editable:false,
					triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
					forceSelection:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
            	}]
	    },{
			xtype: 'fieldcontainer',
			width: 'auto',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind:true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
	 }]
});
