/**
 * @author Amit G
 */
Ext.define('Academia.view.examinationcenters.remark.EvaluationGenerateGenericRemarkWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.evaluationgenerategenericremarkwin',
	title:getExaminationTranslation('GENERIC_REMARK'),
	frame: true,
	autoScroll:true,
	modal:true,
	method: 'POST',
	width:'38%',
	height:400,
	resizable:true,
	items: [{
		xtype: 'form',
		plugins : "formlabelrequired",
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			itemId: 'levelOneId',
			name: 'levelOne'
		},{
			xtype: 'hidden',
			itemId: 'levelTwoId',
			name: 'levelTwo'
		},{
			xtype: 'hidden',
			itemId: 'levelThreeId',
			name: 'levelThree'
		},{
			xtype: 'hidden',
			itemId: 'courseVariantId',
			name: 'courseVariant'
		},{
			xtype: 'fieldcontainer',
			plugins : "formlabelrequired",
			defaults: {
				labelAlign: 'top'
			},
			standardSubmit: false,
			items: [{
			xtype: 'textarea',
			name: 'personalObservations',
			itemId:'personalObservationsId',
			fieldLabel: '<b>'+getCommonTranslation('ADD_YOUR_PERSONAL_OBSERVATIONS')+'</b>',
			maxLength:1500,
			width: 510,
			}]
		},{ 	
			xtype:'fieldcontainer',
			width: 510,
			layout: 'hbox',
			margin: '0 0 16 0',
			items: [{
				xtype: 'tbspacer',
				flex: 1
			}, {
				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('GENERATE'),
				itemId: 'generateGenericBtnRemark',
				cls : 'CustomBtnSubmitGenerateAI',
				scale : CONSTANTS.BUTTONSIZE
			}, {
				xtype: 'button',
				text: getCommonTranslation("RESET"),
				itemId:'resetBtnRemark',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}, {
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults: {
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textarea',
				name: 'personalObservationsDesc',
				itemId:'personalObservationsDescId',
				width: 510,
				maxLength:1500,
				enterIsSpecial:true,
				grow: true
			}]		
		},{
			xtype:'displayfield',
			name:'remarkNoticeRemark',
			width:'100%',
			itemId:'remarkNoticeRemarkId',
			value: '<span class="maxCharacterCls">'+getExaminationTranslation('MAX_CHARACTER_LENGTH')+" "+1500+'/'+1500+'</span>',
			
			
		},{ 	
		   xtype:'fieldcontainer',
    	   width:'auto',
		   items: [{
		    	 xtype: 'button',
				 action: 'Submit',
				 text: getFeeAndPaymentCommonTranslation('SAVE'),
				 disabled: true,
				 itemId: 'submitBtnWin',
				 ui: 'CustomBtnSubmit',
				 scale: CONSTANTS.BUTTONSIZE
		      },{
				 xtype: 'button',
				 text: getFeeAndPaymentCommonTranslation('CANCEL'),
				 ui: 'CustomBtnCancel',
				 itemId: 'cancelBtn',
				 scale: CONSTANTS.BUTTONSIZE
		      }]
	       }]
		}]	
});