/**
 * @author Bhanu Pratap Singh
 */
Ext.define('Academia.view.examinationcenters.reports.AnonymousReportForm',{
	extend:'Ext.form.FormPanel',
	alias:'widget.anonymousreportform',
	plugins:"formlabelrequired",
	autoScroll:false,
	frame:false,
	cls:'customSearchPanel',
	method:'POST',
	standardSubmit:false,
	defaults:{
		labelAlign:'top',
		width:226
	},
	items:[{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'customcombobox',
			name:'evaluationGroup',
			itemId:'evaluationGroupItemId',
			store:'examinationcenters.reports.EvaluationGroupFilterStore',
			fieldLabel:getExaminationTranslation('EVALUATION_GROUP'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'textSearch',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name:'studentId',
			itemId:'studentIdId',
			store:'examinationcenters.reports.anonymousreportfilter.AnonymousStudentStore',
			fieldLabel:getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'searchText',
			minChars:3,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name:'uniqueCodeId',
			itemId:'uniqueCodeId',
			store:'examinationcenters.reports.anonymousreportfilter.AnonymousUniqueCodeStore',
			fieldLabel:getExaminationTranslation('UNIQUE_CODE'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'searchText',
			minChars:3,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		}]
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'customcombobox',
			name:'programId',
			itemId:'programItemId',
			store:'examinationcenters.reports.anonymousreportfilter.AnonymousProgramStore',
			fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'searchText',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name:'batchId',
			itemId:'batchItemId',
			store:'examinationcenters.reports.anonymousreportfilter.AnonymousBatchStore',
			fieldLabel:getExaminationTranslation('BATCH'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'searchText',
			minChars:3,
			typeAhead:false,
			disabled:true,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId: 'periodItemId',
			store:'examinationcenters.reports.anonymousreportfilter.AnonymousPeriodStore',
			fieldLabel:getExaminationTranslation('PERIOD'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'searchText',
			minChars:3,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			disabled:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		}]	
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype: 'customcombobox',
			name: 'courseVariantId',
			itemId: 'courseVariantItemId',
			store:'examinationcenters.reports.anonymousreportfilter.AnonymousCVStore',
			fieldLabel: getCourseTxCommonTranslation('COURSE_VARIANT'),
			valueField: 'id',
			displayField: 'value',
			queryParam:'searchText',
			minChars:3,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			disabled:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		},{
			xtype: 'customcombobox',
			name : 'detailSequenceId',
        	itemId:'detailSequenceItemId',
        	fieldLabel : getExaminationTranslation('DETAILED_SQUENCE'),
			store:'examinationcenters.reports.anonymousreportfilter.AnonymousEventStore',
			valueField: 'id',
			displayField: 'value',
			queryParam:'searchText',
			minChars:3,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			disabled:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
			}
		}]
	},
		{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls : 'windowBtnPos',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}
	]
});
