/**
 * @author Ravi Choudhary
 */
Ext.define('Academia.view.examinationcenters.reports.ExamEligibiltySTPortalAndProfile', {
    //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.exameligibiltystportalandprofile',
   store: 'examinationcenters.reports.ExamEligibilitySTPortalAndProfileStore',
    title: getCommonTranslation('EXAM_ELIGIBILITY'),
	border: true,
	refreshStoreData:true,
    frame:false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
		        xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			    store :'examinationcenters.reports.ExamEligibilitySTPortalAndProfileStore',
			    emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			    displayInfo : true
		}]
	}
	],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
   /* initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },*/
   /* buildStore: function() {
        return Ext.create('Academia.store.examinationcenters.reports.ExamEligibilitySTPortalAndProfileStore');
    },*/
    columns: [{
        header: getExaminationTranslation('ADMISSION_ID'),
        dataIndex: 'admissionCode',
        hidden:true,
        flex:.4,
        sortable:true
    },{
        header: getExaminationTranslation('STUDENT_NAME'),
        dataIndex: 'studentName',
        hidden:true,
        flex:.4,
        sortable:true
    }, {
        header: getExaminationTranslation('PROGRAM'),
        dataIndex: 'programName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('BATCH'),
        dataIndex: 'batchName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('PERIOD'),
        dataIndex: 'periodName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('EVALUATION_PLAN'),
        dataIndex: 'evaluationGroupPlan',
        flex:.3,
        hidden:false,
        sortable: true
    }, {
        header: getExaminationTranslation('COURSE')+'/'+getExaminationTranslation('COURSE_VARIANT'),
        dataIndex: 'courseName',
        flex:.3,
        hidden:false,
        sortable: true
    }, {
        header: getExaminationTranslation('EVALUATION_EVENT'),
        dataIndex: 'eventName',
        flex:.3,
        sortable: true
    }, {
        header: getExaminationTranslation('ELIGIBILITY'),
        dataIndex: 'whetherElegible',
        flex:.3,
        sortable: true,
        renderer:function(value){
        	if(value) {
        		return '<span style="color:green">Eligible</span>'
        	}else {
        		return '<span style="color:red">Detained</span>'
        	}
        }
    }]
});