/**
 * @author Anand Verma
 */

Ext.define('Academia.view.examinationcenters.reports.MarksheetReportsWin', {
    extend: 'Ext.window.Window',
    alias: 'widget.marksheetreportswin',
    title: getCommonTranslation('EXPORTREPORTS'),
    frame: true,
    modal: true,
    height: "320px",
    autoScroll: true,
    resizable: false,
    items: [
        {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            width: 'auto',
            items: [
                {
                    xtype: 'customcombobox',
                    name: 'reportType',
                    itemId: 'reportTypeId',
                    store: 'reports.examination.ReportType',
                    fieldLabel: getExaminationTranslation('REPORTTYPE'),
                    labelAlign: 'top',
                    valueField: 'id',
                    displayField: 'value',
                    width: 226
                },
                {
                    xtype: 'button',
                    name: 'preview',
                    itemId: 'previewId',
                    text: getExaminationTranslation('PREVIEW'),
                    ui: 'CustomBtnThird',
                    style: {
                        marginTop: '30px'
                    }
                }
            ]
        },
        {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            width: 'auto',
            items: [
                {
                    xtype: 'customcombobox',
                    name: 'sortingFilter',
                    itemId: 'sortingFilterItemId',
                    fieldLabel: getExaminationTranslation('SORT_REPORT_DATA_BY'),
                    store: 'examinationcenters.evaluation.MarksheetReportSortingFilterStore',
                    labelAlign: 'top',
                    displayField: 'value',
                    valueField: 'value',
                    forceSelection: true,
                    editable: false,
                    typeAhead: true,
                    width: 226
                }
            ]
        },
        {
            xtype: 'radiogroup',
            itemId: 'studentStatusItemId',
            fieldLabel: getCommonTranslation('STATUS'),
			labelAlign: 'top', 
			vertical: true,   
			width: 300, 
            defaults: {
                flex: 1
            },
            items: [
                {
                    boxLabel: getCommonTranslation('All'),
                    name: 'studentStatus',
                    inputValue: null,
                    checked: true
                },
                {
                    boxLabel: getCommonTranslation('Active'),
                    name: 'studentStatus',
                    inputValue: true
                },
                {
                    boxLabel: getCommonTranslation('Inactive'),
                    name: 'studentStatus',
                    inputValue: false
                }
           
            ]
        },
        {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            width: 'auto',
            style: { marginTop: '20px !important' },
            items: [
                {
                    xtype: 'button',
                    name: 'generateReport',
                    itemId: 'generateReportId',
                    text: getExaminationTranslation('GENERATEREPORT'),
                    ui: 'CustomBtnSubmit'
                }
            ]
        }
    ]
});
