/**
 * @author Bhanu Pratap Singh
 */
Ext.define('Academia.view.examinationcenters.reports.StudentReportForm',{
	extend:'Ext.form.FormPanel',
	alias:'widget.studentreportform',
	autoScroll:false,
	frame:false,
	cls:'customSearchPanel',
	method:'POST',
	standardSubmit:false,
	defaults:{
		labelAlign:'top',
		width:226
	},
	plugins:"formlabelrequired",
	items:[{
		xtype:'fieldcontainer',
		width:'100%',
		layout:'hbox',
		defaults:{
			labelAlign:'top',
			width:226
		},
		items:[{
		    	   xtype: 'datefield',
		    	   name: 'fromdate',
		    	   itemId:'fromdataItemId',
		    	    editable:false,
		    	   fieldLabel:getExaminationTranslation('FROM_DATE'),
		    	 //--submitFormat:CONSTANTS.DATE_TIME_FORMAT,
		    	   listeners: {
		    		   render: function(field) {
		    			   return dateFormatRender(field);
		    		   }
		    	   }
		       },{
		    	   xtype: 'datefield',
		    	   name: 'tilldate',
		    	   itemId:'tilldateItemId',
		    	    editable:false,
		    	   fieldLabel:getExaminationTranslation('TILL_DATE'),
		    	 //--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
		    	   listeners: {
		    		   render: function(field) {
		    			   return dateFormatRender(field);
		    		   }
		    	   }
		       }]
	},{
		xtype:'fieldset',
		title: getTransportTranslation('MORE_FILTERS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:true,
		style:{marginTop: '33px!important'},
		width:'100%',
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			width:'100%',
			defaults: {
				width: 460,
				labelAlign: 'top',
			},
			items:[{
				xtype: 'multiselectcombofield',
				itemId: 'userItemId',
				name: 'usersId',
				fieldLabel: getTransportTranslation('USER'),
				store:'examinationcenters.reports.ExaminationReportUserStore',	    
				valueField: 'id',
				displayField: 'value',
				width: 460
			}]
		},
		{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:460
			},
			items:[{
				xtype: 'customcombobox',
				name:'programId',
				itemId:'programItemId',
				store:'examinationcenters.reports.ExaminationReportProgramStore',
				fieldLabel:getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'name',
				minChars:3,
				width:460,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name:'batchId',
				itemId:'batchItemId',
				store:'examinationcenters.reports.ExaminationReportBatchStore',
				fieldLabel:getExaminationTranslation('BATCH'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				minChars:3,
				disabled:true,
				width:226,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}]	
		},
		{
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:460
			},
			items:[{
				xtype: 'customcombobox',
				name: 'periodId',
				itemId: 'periodItemId',
				store:'examinationcenters.reports.ExaminationReportPeriodStore',
				fieldLabel:getExaminationTranslation('PERIOD'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				disabled:true,
				minChars:3,
				width:226,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'multiselectcombofield',
				name: 'sectionId',
				itemId: 'sectionItemId',
				store:'examinationcenters.reports.ExaminationReportSectionStore',
				fieldLabel:getExaminationTranslation('SECTION'),
				valueField: 'id',
				displayField: 'value',
				width:460,
				disabled:true,
				typeAhead:false,
				hideTrigger:false,
				forceSelection:true,
				cls:'placementProgramMultiselect'
			}]

		},
		{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: '100%',
			defaults: {
				width: 460,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'courseId',
				itemId: 'courseItemId',
				store:'examinationcenters.reports.ExaminationReportCourseStore',
				fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				minChars:3,
				width:460,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'evaluationPlanId',
				itemId: 'evaluationPlanItemId',
				store:'examinationcenters.reports.ExaminationReportEPStore',
				fieldLabel:getExaminationTranslation('EVALUATION_PLAN'),
				valueField: 'id',
				displayField: 'value',
				queryParam:'name',
				minChars:3,
				width:226,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			}]
		},
		{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: '100%',
			defaults: {
				width: 460,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'studentId',
				itemId: 'studentItemId',
				store:'examinationcenters.reports.ExaminationReportStudentStore',
				fieldLabel:getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'name',
				minChars:3,
				width:460,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}' +
						'</div>';
					}
				}
			},{
        		xtype: 'customcombobox',
        		width:226,
				name:'studentStatus',
				itemId:'studentStatus',
				fieldLabel: getCommonTranslation('STATUS'),
				minChars:3,
				typeAhead:false,
				value:true,
				 valueField: 'value',
                 displayField: 'name',
				forceSelection:true,
				store:'common.picklist.StudentActiveInactiveStatusStore',
				disabled:false,
        	}]
		}],
		listeners:{
			render: function(myfieldset){
				myfieldset.setMargin('-10px');
			}
		}
	},
	{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls : 'windowBtnPos',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}
	]
});
